/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.property.PrintCountProp;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.print.BosPrintBusinessService;
import kd.bos.mservice.print.param.PrintInfoParam;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.svc.acl.AclAdapter;

public class PrintClientUtil {
    private static final DistributeSessionlessCache distributeCache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    private static Log log = LogFactory.getLog(PrintClientUtil.class);
    private static String HEARTBEAT_REGION_PREFIX = "pclient_beat_";
    private static int HEART_BEAT_PERIOD = 60000;

    public static LicenseCheckResult checkCloudPrintLicense() {
        LicenseCheckResult result = new LicenseCheckResult(Boolean.valueOf(true), "");
        return result;
    }

    public static boolean clientIsOnline(String serviceN, String serviceType) {
        if ("B".equals(serviceType)) {
            String type = RequestContext.get().getAccountId();
            return PrintClientUtil.isOnline(type, serviceN, HEART_BEAT_PERIOD * 2);
        }
        return true;
    }

    private static boolean isOnline(String regionType, String serviceN, int timeOut) {
        boolean isOnline = false;
        String regionKey = PrintClientUtil.getHeartBeatRegion(HEARTBEAT_REGION_PREFIX, regionType);
        String value = (String)distributeCache.get(regionKey, serviceN);
        if (value != null) {
            Long t = Long.parseLong(value);
            if (System.currentTimeMillis() - t <= (long)timeOut) {
                isOnline = true;
            } else {
                distributeCache.remove(regionKey, serviceN);
            }
        }
        return isOnline;
    }

    public static List<String> getAllOnlineService() {
        String regionKey = PrintClientUtil.getHeartBeatRegion(HEARTBEAT_REGION_PREFIX, RequestContext.get().getAccountId());
        Map all = distributeCache.getAll(regionKey);
        if (all == null || all.isEmpty()) {
            return Collections.emptyList();
        }
        long now = System.currentTimeMillis();
        ArrayList<String> onlineServiceNList = new ArrayList<String>(all.size());
        ArrayList removeKey = new ArrayList(10);
        for (Map.Entry entry : all.entrySet()) {
            Long t = Long.parseLong((String)entry.getValue());
            if (t - now > (long)(HEART_BEAT_PERIOD * 2)) {
                removeKey.add(entry.getKey());
                continue;
            }
            onlineServiceNList.add((String)entry.getKey());
        }
        if (!removeKey.isEmpty()) {
            distributeCache.remove(regionKey, removeKey.toArray(new String[removeKey.size()]));
        }
        return onlineServiceNList;
    }

    public static void updatePrinterStatus(String serviceN, Map<String, Object> info) {
        long time = System.currentTimeMillis();
        ArrayList<String> removeList = new ArrayList<String>(2);
        HashMap<String, String> map = new HashMap<String, String>(2);
        Iterator<Map.Entry<String, Object>> iterator = info.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String value = String.valueOf(entry.getValue());
            if ("0".equals(value)) {
                removeList.add(entry.getKey());
                iterator.remove();
            }
            if (!"1".equals(value)) continue;
            map.put(entry.getKey(), time + ":1");
        }
        if (info.size() > 0) {
            distributeCache.put(serviceN, map, HEART_BEAT_PERIOD * 5);
        }
        if (removeList.size() > 0) {
            distributeCache.remove(serviceN, removeList.toArray(new String[0]));
        }
    }

    public static PrinterStatus printerStatus(String serviceN, String printer, String serviceType) {
        if ("A".equals(serviceType)) {
            return PrinterStatus.idle;
        }
        if (!PrintClientUtil.clientIsOnline(serviceN, "B")) {
            return PrinterStatus.offline;
        }
        String cacheValue = (String)distributeCache.get(serviceN, printer);
        if (cacheValue == null) {
            return PrinterStatus.idle;
        }
        try {
            String[] split = cacheValue.split(":");
            Long t = Long.parseLong(split[0]);
            long now = System.currentTimeMillis();
            if ("1".equals(split[1]) && now - t < (long)(HEART_BEAT_PERIOD * 2)) {
                return PrinterStatus.busy;
            }
        }
        catch (Exception ignore) {
            return PrinterStatus.idle;
        }
        return PrinterStatus.idle;
    }

    public static void doHeartBeat(String sessionId, String serviceN) {
        String accountId = PrintClientUtil.getAccountId(sessionId);
        String heartBeatKey = PrintClientUtil.getHeartBeatRegion(HEARTBEAT_REGION_PREFIX, accountId);
        distributeCache.put(heartBeatKey, serviceN, String.valueOf(System.currentTimeMillis()), HEART_BEAT_PERIOD * 5);
    }

    public static void doHeartBeatOld(String accountId, String serviceN) {
        String heartBeatKey = PrintClientUtil.getHeartBeatRegion(HEARTBEAT_REGION_PREFIX, accountId);
        distributeCache.put(heartBeatKey, serviceN, String.valueOf(System.currentTimeMillis()), HEART_BEAT_PERIOD * 5);
    }

    public static void turnOffLine(String sessionId, String serviceId) {
        String accountId = PrintClientUtil.getAccountId(sessionId);
        String heartBeatKey = PrintClientUtil.getHeartBeatRegion(HEARTBEAT_REGION_PREFIX, accountId);
        distributeCache.remove(heartBeatKey, serviceId);
    }

    private static String getHeartBeatRegion(String prefix, String region) {
        return prefix + region;
    }

    private static String getAccountId(String sessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        String accountId = sessionDAO.getAttribute("accountId");
        return accountId;
    }

    public static boolean existPrinter() {
        Map printerMap = BusinessDataServiceHelper.loadFromCache((String)"bos_cloudprintmanage", (String)"id", null);
        return printerMap != null && printerMap.size() > 0;
    }

    public static boolean existOnlineNewService() {
        return PrintClientUtil.getAllOnlineService().size() > 0;
    }

    public static boolean existNewService() {
        Map printerMap = BusinessDataServiceHelper.loadFromCache((String)"bos_cloudprintmanage", (String)"id", (QFilter[])new QFilter[]{new QFilter("group.servicetype", "=", (Object)"B")});
        return printerMap != null && printerMap.size() > 0;
    }

    public static CloudPrinter getCloudPrinter(long printerId) {
        DynamicObject cloudPrint = BusinessDataServiceHelper.loadSingleFromCache((Object)printerId, (String)"bos_cloudprintmanage");
        if (cloudPrint == null) {
            return null;
        }
        String serviceN = cloudPrint.getString("group.number");
        long serviceId = cloudPrint.getLong("group.id");
        String serviceType = cloudPrint.getString("group.servicetype");
        String printerName = cloudPrint.getString("printeraddress");
        CloudPrinter cloudPrinter = new CloudPrinter();
        cloudPrinter.printerId = printerId;
        cloudPrinter.printerName = printerName;
        cloudPrinter.serviceId = serviceId;
        cloudPrinter.serviceN = serviceN;
        cloudPrinter.serviceType = serviceType;
        return cloudPrinter;
    }

    public static void updatePrintInfo(PrintInfoParam param) {
        BosPrintBusinessService service = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
        service.updatePrintInfo(param);
    }

    @Deprecated
    public static void updatePrintCountField(String entityTypeId, List<Object> pkIds, PrintCountProp.PrintRecordModel recordModel) {
        PrintInfoParam param = new PrintInfoParam();
        param.setEntityTypeId(entityTypeId);
        param.setPkIds(pkIds);
        param.setRecordModel(recordModel.getValue());
        param.setUserId(RequestContext.get().getCurrUserId());
        PrintClientUtil.updatePrintInfo(param);
    }

    public static class CloudPrinter {
        private long printerId;
        private String printerName;
        private String serviceN;
        private long serviceId;
        private String serviceType;

        public long getPrinterId() {
            return this.printerId;
        }

        public String getPrinterName() {
            return this.printerName;
        }

        public String getServiceN() {
            return this.serviceN;
        }

        public long getServiceId() {
            return this.serviceId;
        }

        public String getServiceType() {
            return this.serviceType;
        }
    }

    public static enum PrinterStatus {
        idle,
        busy,
        offline;

    }
}

