/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.webapi;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.validation.Valid;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.result.OpenApiFile;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.print.service.webapi.PrintAttachParam;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.PrintPermissionUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import org.apache.commons.io.IOUtils;

@ApiController(value="bos", desc="\u6253\u5370\u901a\u7528\u670d\u52a1API")
@ApiMapping(value="/kdprint/comm")
public class PrintBusinessController {
    private static final Log log = LogFactory.getLog(PrintBusinessController.class);

    @ApiPostMapping(value="/execPrint", desc="\u6267\u884c\u6253\u5370")
    public CustomApiResult<@ApiResponseBody(value="\u6253\u5370\u7ed3\u679c\u4fe1\u606f") PrtAttach> execPrint(@Valid @ApiRequestBody(value="\u6253\u5370\u53c2\u6570", required=true) PrintWork printWork) {
        try {
            if (PrintWork.EXP_TYPE.EXP_SCPT.getCode().equals(printWork.getExpType())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u4e0d\u652f\u6301\u901a\u8fc7\u5ba2\u6237\u7aef\u8fdb\u884c\u6253\u5370\u3002", (String)"BosPrintServiceHelper_2", (String)"bos-print-service", (Object[])new Object[0]));
            }
            PrtAttach prtAttach = BosPrintServiceHelper.execPrint(printWork);
            return CustomApiResult.success((Object)prtAttach);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/downloadAttach", desc="\u4e0b\u8f7d\u6253\u5370\u9644\u4ef6")
    public CustomApiResult<OpenApiFile> downloadAttach(@Valid @ApiRequestBody(value="\u6253\u5370\u9644\u4ef6\u53c2\u6570", required=true) PrintAttachParam param) {
        try {
            byte[] fileBytes;
            String taskId = param.getTaskId();
            String attachId = param.getAttachId();
            boolean isMobile = param.isMobile();
            PrtTaskResult prtResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
            if (prtResult == null) {
                return CustomApiResult.fail((String)"702", (String)ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PrintAction_2", (String)"bos-attachment", (Object[])new Object[0]));
            }
            boolean hasPermission = PrintPermissionUtil.checkPermission((boolean)isMobile, (PrtTaskResult)prtResult);
            if (!hasPermission) {
                log.info("PrtTaskResult:" + SerializationUtils.toJsonString((Object)prtResult));
                return CustomApiResult.fail((String)"702", (String)ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)"bos-webactions", (Object[])new Object[0]));
            }
            List attachList = prtResult.getAttach();
            PrtTaskResult.Attach attach = null;
            for (PrtTaskResult.Attach att : attachList) {
                if (!StringUtils.equals((CharSequence)attachId, (CharSequence)att.getAttachId())) continue;
                attach = att;
                break;
            }
            if (attach == null) {
                return CustomApiResult.fail((String)"702", (String)ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PrintAction_2", (String)"bos-attachment", (Object[])new Object[0]));
            }
            String filePath = attach.getFilePath();
            String fileName = attach.getFileName();
            boolean forceDownload = param.isDownloadAttach();
            String contentType = this.getFileContentType(fileName, forceDownload);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                 InputStream inputStream = PrintFileUtil.getFileInputStream((String)filePath, (String)prtResult.getDiskType());){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream, (int)2048);
                fileBytes = outputStream.toByteArray();
            }
            OpenApiFile openApiFile = new OpenApiFile(fileName, contentType, forceDownload, fileBytes);
            return CustomApiResult.success((Object)openApiFile);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }

    private String getFileContentType(String fileName, boolean forceDownload) {
        String ext;
        if (forceDownload) {
            return "application/octet-stream";
        }
        switch (ext = fileName.substring(fileName.lastIndexOf(46) + 1)) {
            case "pdf": {
                return "application/pdf";
            }
            case "png": {
                return "image/png";
            }
            case "jpeg": 
            case "jpe": 
            case "jfif": 
            case "jpg": {
                return "image/jpeg";
            }
            case "bmp": {
                return "image/bmp";
            }
        }
        return "application/octet-stream";
    }
}

