/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.webapi;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.result.OpenApiFile;
import kd.bos.print.core.ctrl.common.util.StreamUtil;
import kd.bos.print.service.provider.AttachmentServiceProvider;
import kd.bos.print.service.provider.ClientScptServiceProvider;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.print.service.webapi.ClientPrintTask;
import kd.bos.print.service.webapi.ClientPrinterParam;
import kd.bos.print.service.webapi.DelPrinterParam;
import kd.bos.print.service.webapi.service.PrintClientService;

@ApiController(value="bos", desc="\u6253\u5370\u5ba2\u6237\u7aef\u670d\u52a1API")
@ApiMapping(value="/kdprint/client")
public class PrintClientControler {
    private Log log = LogFactory.getLog(PrintClientControler.class);
    private PrintClientService clientService = new PrintClientService();

    private DistributeSessionlessCache getDistributeSessionlessCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("CachePrtRegion", new DistributeCacheHAPolicy(true, true));
    }

    @ApiGetMapping(value="/touchServer", desc="\u5ba2\u6237\u7aef\u8bbf\u95ee\u670d\u52a1")
    public CustomApiResult<String> touchServer(@NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) @NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) String serviceNumber) {
        String globalSessionId = RequestContext.get().getGlobalSessionId();
        PrintClientUtil.doHeartBeat(globalSessionId, serviceNumber);
        return CustomApiResult.success((Object)"success");
    }

    @ApiGetMapping(value="/downloadRc", desc="\u4e0b\u8f7d\u6253\u5370\u6587\u4ef6\u8d44\u6e90")
    public CustomApiResult<OpenApiFile> downloadRc(@ApiParam(value="\u8d44\u6e90\u6587\u4ef6\u6807\u8bc6", required=true) @ApiParam(value="\u8d44\u6e90\u6587\u4ef6\u6807\u8bc6", required=true) String rcKey, @ApiParam(value="\u8d44\u6e90\u6587\u4ef6\u7c7b\u578b") @ApiParam(value="\u8d44\u6e90\u6587\u4ef6\u7c7b\u578b") String type) {
        try {
            if ("font".equals(type)) {
                Map<String, Object> fontInfo = this.clientService.getFontInfo(rcKey);
                Object data = fontInfo.get("data");
                String url = String.valueOf(fontInfo.get("url"));
                String fileName = String.valueOf(fontInfo.get("fileName"));
                if (data == null) {
                    InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    StreamUtil.copy((InputStream)inputStream, (OutputStream)outputStream, (int)1024);
                    data = outputStream.toByteArray();
                    inputStream.close();
                    outputStream.close();
                }
                OpenApiFile result = new OpenApiFile(fileName, "application/octet-stream", true, (byte[])data);
                return CustomApiResult.success((Object)result);
            }
            if ("tpl".equals(type)) {
                rcKey = new String(Base64.getDecoder().decode(rcKey.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                String url = "tempfile/download.do?" + rcKey;
                StreamUtil.copy((InputStream)tempFileCache.getInputStream(url), (OutputStream)outputStream, (int)1024);
                OpenApiFile result = new OpenApiFile("tpl.png", "application/json", true, outputStream.toByteArray());
                tempFileCache.remove(url);
                return CustomApiResult.success((Object)result);
            }
            if ("scpt".equals(type)) {
                String[] arr = rcKey.split("_");
                String taskId = arr[0];
                String seq = arr[1];
                String taskKey = ClientScptServiceProvider.getTaskKey(taskId);
                String filePath = (String)this.getDistributeSessionlessCache().get(taskKey, seq);
                if (StringUtils.isBlank((CharSequence)filePath)) {
                    return CustomApiResult.fail((String)"602", (String)"File Not Exist");
                }
                TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                String url = "tempfile/download.do?" + filePath;
                StreamUtil.copy((InputStream)tempFileCache.getInputStream(url), (OutputStream)outputStream, (int)1024);
                byte[] oriByte = outputStream.toByteArray();
                OpenApiFile result = new OpenApiFile(seq + ".tpl", "application/json", true, oriByte);
                return CustomApiResult.success((Object)result);
            }
            byte[] image = AttachmentServiceProvider.getProvider().getImage(rcKey);
            String fileName = rcKey + ".png";
            OpenApiFile result = new OpenApiFile(fileName, "image", true, image);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/addPrinter", desc="\u6dfb\u52a0\u6253\u5370\u673a")
    public CustomApiResult<String> addPrinter(@Valid @ApiRequestBody(value="\u6253\u5370\u673a\u53c2\u6570\u4fe1\u606f", required=true) ClientPrinterParam printerParam) {
        try {
            boolean success = this.clientService.addPrinter(printerParam);
            if (success) {
                return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"PrintClientController_0", (String)"bos-print-service", (Object[])new Object[0]));
            }
            return CustomApiResult.fail((String)"702", (String)ResManager.loadKDString((String)"\u6dfb\u52a0\u5931\u8d25\u3002", (String)"PrintClientController_1", (String)"bos-print-service", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/delPrinter", desc="\u5220\u9664\u6253\u5370\u673a")
    public CustomApiResult<String> delPrinter(@Valid @ApiRequestBody(value="\u5220\u9664\u6253\u5370\u673a\u4fe1\u606f", required=true) DelPrinterParam printerParam) {
        try {
            this.clientService.delPrinter(printerParam);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PrintClientController_2", (String)"bos-print-service", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/queryPrinter", desc="\u67e5\u8be2\u6253\u5370\u673a")
    public CustomApiResult<@ApiResponseBody(value="\u8fd4\u56de\u6253\u5370\u673a\u4fe1\u606f") ClientPrinterParam> queryPrinter(@NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) @NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) String serviceNumber) {
        try {
            ClientPrinterParam clientPrinterParam = this.clientService.queryPrinter(serviceNumber);
            return CustomApiResult.success((Object)clientPrinterParam);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/queryTask", desc="\u67e5\u8be2\u6253\u5370\u4efb\u52a1")
    public CustomApiResult<@ApiResponseBody(value="\u8fd4\u56de\u6253\u5370\u673a\u4efb\u52a1\u4fe1\u606f") ClientPrintTask> queryTask(@NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) @NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) String serviceNumber) {
        try {
            ClientPrintTask clientTask = this.clientService.queryTask(serviceNumber);
            return CustomApiResult.success((Object)clientTask);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/updateTaskStatus", desc="\u66f4\u65b0\u6253\u5370\u72b6\u6001")
    public CustomApiResult<String> updateTaskStatus(@NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) @NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) String taskId, @NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) @NotNull @ApiParam(value="\u670d\u52a1\u7f16\u7801", required=true) boolean status) {
        try {
            this.clientService.updateTask(taskId, status);
            return CustomApiResult.success((Object)"success");
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }
}

