/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.webapi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.print.param.PrintDeployFile;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.print.service.webapi.PrintMultiLangData;
import kd.bos.print.service.webapi.PrintMultiLangParam;
import kd.bos.print.service.webapi.PrintTplInfo;
import kd.bos.print.service.webapi.service.PrintMultiLangService;
import kd.bos.service.metadata.util.GzipUtils;

@ApiController(value="bos", desc="\u6253\u5370\u6a21\u677f\u591a\u8bed\u8a00\u670d\u52a1API")
@ApiMapping(value="/kdprint/lang")
public class PrintMultiLangController {
    private static final Log log = LogFactory.getLog(PrintMultiLangController.class);

    @ApiPostMapping(value="/queryTplIds")
    public CustomApiResult<Map<String, List<PrintTplInfo>>> queryTplIds(@ApiParam(value="\u5e94\u7528ID") @ApiParam(value="\u5e94\u7528ID") String appId) {
        try {
            PrintMultiLangService service = new PrintMultiLangService();
            Map<String, List<PrintTplInfo>> formId2TplIdMap = service.queryTplIds(appId);
            return CustomApiResult.success(formId2TplIdMap);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return CustomApiResult.success(Collections.emptyMap());
        }
    }

    @ApiPostMapping(value="/queryTplInfo")
    public CustomApiResult<Map<String, List<PrintTplInfo>>> queryTplInfo(@ApiParam(value="\u5e94\u7528ID") @ApiParam(value="\u5e94\u7528ID") String appId, @ApiParam(value="\u8bed\u8a00") @ApiParam(value="\u8bed\u8a00") String srcLang) {
        try {
            PrintMultiLangService service = new PrintMultiLangService();
            Map<String, List<PrintTplInfo>> formId2TplIdMap = service.queryTplIds(appId, srcLang);
            return CustomApiResult.success(formId2TplIdMap);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return CustomApiResult.success(Collections.emptyMap());
        }
    }

    @ApiPostMapping(value="/loadMultiLangData")
    public CustomApiResult<PrintMultiLangData> loadMultiLangData(@Valid @ApiRequestBody(value="\u6253\u5370\u591a\u8bed\u8a00\u53c2\u6570", required=true) PrintMultiLangParam param) {
        try {
            PrintMultiLangService service = new PrintMultiLangService();
            PrintMultiLangData applyPrintLangParams = service.loadMultiLangData(param);
            return CustomApiResult.success((Object)applyPrintLangParams);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/applyMultiLangData")
    public CustomApiResult<String> applyMultiLangData(@ApiParam(value="Gzip\u591a\u8bed\u8a00\u6570\u636e", required=true) @ApiParam(value="Gzip\u591a\u8bed\u8a00\u6570\u636e", required=true) String gzipData) {
        try {
            PrintMultiLangService service = new PrintMultiLangService();
            PrintMultiLangData param = (PrintMultiLangData)SerializationUtils.fromJsonString((String)GzipUtils.uncompress((String)gzipData, (String)"utf-8"), PrintMultiLangData.class);
            service.applyMultiLangData(param);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
        return CustomApiResult.success((Object)"success");
    }

    @ApiPostMapping(value="/buildMultiLangFile")
    public CustomApiResult<List<PrintDeployFile>> buildMultiLangFile(@Valid @ApiRequestBody(value="\u6253\u5370\u591a\u8bed\u8a00\u53c2\u6570", required=true) PrintMultiLangParam param) {
        try {
            PrintMultiLangService service = new PrintMultiLangService();
            List<PrintDeployFile> deployFiles = service.getMultiLangFile(param);
            return CustomApiResult.success(deployFiles);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return CustomApiResult.fail((String)"702", (String)e.getMessage());
        }
    }
}

