/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.webapi.service;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PrintCountProp;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.print.param.PrintInfoParam;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.print.service.webapi.ClientPrintTask;
import kd.bos.print.service.webapi.ClientPrinterParam;
import kd.bos.print.service.webapi.DelPrinterParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.tenant.TenantInfo;
import kd.bos.web.DispatchServiceHelper;

public class PrintClientService {
    private static final String ACCOUNTID = "accountid";
    private static final String MODIFYTIME = "modifytime";
    private static final String ENABLE = "enable";
    private static final String CREATETIME = "createtime";
    private static final String STATUS = "status";
    private static final String NUMBER = "number";
    private static final String PRINTER_ADDRESS = "printeraddress";
    private static final String NAME = "name";
    private static final String CTRL_STRATEGY = "ctrlstrategy";
    private static Log log = LogFactory.getLog(PrintClientService.class);
    private static final Interner<String> interner = Interners.newWeakInterner();

    private DistributeSessionlessCache getDistributeCache() {
        return AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPrinter(ClientPrinterParam param) {
        LicenseCheckResult licenseCheckResult = PrintClientUtil.checkCloudPrintLicense();
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            throw new KDBizException(licenseCheckResult.getMsg());
        }
        String serviceNumber = param.getServiceNumber();
        if (serviceNumber == null) {
            throw new PrintException("5", ResManager.loadKDString((String)"\u6253\u5370\u5ba2\u6237\u7aef\u670d\u52a1\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PrintClientService_0", (String)"bos-print-service", (Object[])new Object[0]));
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_cloudprintmanage");
        Object serviceId = this.registerNewServiceByNumber(RequestContext.get().getAccountId(), serviceNumber, param.getServiceName());
        if (serviceId == null) {
            throw new PrintException("5", ResManager.loadKDString((String)"\u6253\u5370\u5ba2\u6237\u7aef\u670d\u52a1\u6ce8\u518c\u5931\u8d25\u3002", (String)"PrintClientService_1", (String)"bos-print-service", (Object[])new Object[0]));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject curUser = BusinessDataServiceHelper.loadSingleFromCache((Object)currUserId, (String)"bos_user");
        long userOrgId = UserServiceHelper.getUserDefaultOrgID((long)currUserId);
        if (userOrgId == 0L) {
            userOrgId = UserServiceHelper.getUserMainOrgId((long)currUserId);
        }
        DynamicObject curOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)userOrgId, (String)"bos_org");
        QFilter filter = new QFilter("group", "=", serviceId);
        String string = (String)interner.intern((Object)param.getServiceNumber());
        synchronized (string) {
            Map cachePrinters = BusinessDataServiceHelper.loadFromCache((String)"bos_cloudprintmanage", (QFilter[])new QFilter[]{filter});
            ArrayList<String> existAddress = new ArrayList<String>(10);
            Map printerMap = param.getPrinters().stream().filter(f -> StringUtils.isNotBlank(f.get(PRINTER_ADDRESS))).collect(Collectors.toMap(m -> m.get(PRINTER_ADDRESS), Function.identity()));
            ArrayList<DynamicObject> printers = new ArrayList<DynamicObject>(10);
            if (cachePrinters != null && !cachePrinters.isEmpty()) {
                DynamicObject[] currentObjs;
                for (DynamicObject o : currentObjs = BusinessDataServiceHelper.load((Object[])cachePrinters.keySet().toArray(), (DynamicObjectType)dt)) {
                    Object name;
                    String pAddress = (String)o.get(PRINTER_ADDRESS);
                    Map printer = (Map)printerMap.get(pAddress);
                    if (printer != null && (name = printer.get(NAME)) != null) {
                        o.set(NAME, (Object)new LocaleString(name.toString()));
                        o.set(MODIFYTIME, (Object)new Date());
                        existAddress.add(pAddress);
                    }
                    printers.add(o);
                }
            }
            for (Map.Entry mp : printerMap.entrySet()) {
                String printerAddress = mp.getKey().toString();
                Map printer = (Map)mp.getValue();
                if (existAddress.contains(printerAddress)) continue;
                DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
                dynaObj.set(NUMBER, (Object)UUID.randomUUID());
                Object name = printer.get(NAME);
                if (name == null) {
                    dynaObj.set(NAME, (Object)new LocaleString());
                } else {
                    dynaObj.set(NAME, (Object)new LocaleString(name.toString()));
                }
                dynaObj.set(STATUS, (Object)"C");
                dynaObj.set(ENABLE, (Object)"1");
                dynaObj.set("group", serviceId);
                dynaObj.set(MODIFYTIME, (Object)new Date());
                dynaObj.set(CREATETIME, (Object)new Date());
                dynaObj.set("creator", (Object)curUser);
                dynaObj.set("createorg", (Object)curOrg);
                dynaObj.set(PRINTER_ADDRESS, (Object)printerAddress);
                dynaObj.set(CTRL_STRATEGY, (Object)5);
                printers.add(dynaObj);
            }
            String bizErrorCode = "PrintClientSerice_BizError";
            try {
                OperationResult operationResult;
                if (!printers.isEmpty() && !(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_cloudprintmanage", (DynamicObject[])printers.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess()) {
                    log.warn("\u540c\u6b65\u6dfb\u52a0\u6253\u5370\u673a\u5931\u8d25\uff1aresult=" + SerializationUtils.toJsonString((Object)operationResult.getAllErrorOrValidateInfo()) + ",createOrgId=" + curOrg.getPkValue() + ",creatorId=" + curUser.getPkValue());
                    ValidateResultCollection validateResult = operationResult.getValidateResult();
                    if (validateResult != null && !validateResult.isSuccess()) {
                        throw new KDBizException(new ErrorCode(bizErrorCode, ResManager.loadKDString((String)"\u6dfb\u52a0\u4e91\u6253\u5370\u673a\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u767b\u5f55\u8d26\u53f7\u662f\u5426\u6388\u6743\u4f7f\u7528\u3010\u6253\u5370\u673a\u7ba1\u7406\u3011\u3002", (String)"PrintClientService_9", (String)"bos-print-service", (Object[])new Object[0])), new Object[0]);
                    }
                    PrintOpLogUtils.addLog((String)"cts", (String)"bos_cloudprintmanage", (String)"web", (String)"", (PrintOpLogMsgEnum)PrintOpLogMsgEnum.PRINTER_ADD_FAIL);
                    return false;
                }
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u6dfb\u52a0\u6253\u5370\u673a\u5931\u8d25\uff1a", (Throwable)e);
                PrintOpLogUtils.addLog((String)"cts", (String)"bos_cloudprintmanage", (String)"web", (String)"", (PrintOpLogMsgEnum)PrintOpLogMsgEnum.PRINTER_ADD_FAIL);
                if (e instanceof KDBizException && bizErrorCode.equals(((KDBizException)e).getErrorCode().getCode())) {
                    throw e;
                }
                throw new PrintException("5", ResManager.loadKDString((String)"\u540c\u6b65\u6dfb\u52a0\u6253\u5370\u673a\u5931\u8d25\u3002", (String)"PrintClientService_2", (String)"bos-print-service", (Object[])new Object[0]));
            }
        }
        PrintOpLogUtils.addLog((String)"cts", (String)"bos_cloudprintmanage", (String)"web", (String)"", (PrintOpLogMsgEnum)PrintOpLogMsgEnum.PRINTER_ADD_SUCCESS);
        return true;
    }

    public void delPrinter(DelPrinterParam param) {
        Object serviceId;
        String serviceNumber = param.getServiceNumber();
        DynamicObject serviceObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_cloudprintservice", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)serviceNumber)});
        if (serviceObj == null || (serviceId = serviceObj.getPkValue()) == null) {
            throw new PrintException("5", String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u6253\u5370\u670d\u52a1\u7f16\u7801number=%s\u4e0d\u5b58\u5728\u3002", (String)"PrintClientService_8", (String)"bos-print-service", (Object[])new Object[0]), serviceNumber));
        }
        List<String> printerAdds = param.getPrinters();
        QFilter filter = new QFilter("group", "=", serviceId).and(new QFilter(PRINTER_ADDRESS, "in", printerAdds));
        try (TXHandle h = TX.requiresNew((String)"syncprinter_del");){
            try {
                if (printerAdds != null && !printerAdds.isEmpty()) {
                    DeleteServiceHelper.delete((String)"bos_cloudprintmanage", (QFilter[])new QFilter[]{filter});
                }
            }
            catch (Exception e) {
                h.markRollback();
                log.error("\u540c\u6b65\u5220\u9664\u6253\u5370\u673a\u5931\u8d25\uff1a", (Throwable)e);
                PrintOpLogUtils.addLog((String)"cts", (String)"bos_cloudprintmanage", (String)"web", (String)"", (PrintOpLogMsgEnum)PrintOpLogMsgEnum.PRINTER_DEL_FAIL);
                throw new PrintException("5", ResManager.loadKDString((String)"\u540c\u6b65\u5220\u9664\u6253\u5370\u673a\u5931\u8d25\u3002", (String)"PrintClientService_3", (String)"bos-print-service", (Object[])new Object[0]));
            }
        }
        PrintOpLogUtils.addLog((String)"cts", (String)"bos_cloudprintmanage", (String)"web", (String)"", (PrintOpLogMsgEnum)PrintOpLogMsgEnum.PRINTER_DEL_SUCCESS);
    }

    public ClientPrinterParam queryPrinter(String serviceNumber) {
        Object serviceId;
        ClientPrinterParam result = new ClientPrinterParam();
        result.setServiceNumber(serviceNumber);
        TenantInfo tenantInfo = AccountUtils.getTenantByid((String)RequestContext.get().getTenantId());
        result.setTenantId(RequestContext.get().getTenantId());
        result.setTenantCode(RequestContext.get().getTenantCode());
        result.setInstanceN(tenantInfo.getInstanceNumber());
        DynamicObject serviceObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_cloudprintservice", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)serviceNumber)});
        if (serviceObj == null || (serviceId = serviceObj.getPkValue()) == null) {
            return result;
        }
        Map serviceMap = BusinessDataServiceHelper.loadFromCache((String)"bos_cloudprintservice", (QFilter[])new QFilter[]{new QFilter("id", "=", serviceId).or(new QFilter("parent", "=", serviceId))});
        Optional<Map.Entry> currentServiceOp = serviceMap.entrySet().stream().filter(f -> serviceId.equals(f.getKey())).findFirst();
        if (!currentServiceOp.isPresent()) {
            return result;
        }
        DynamicObject currentService = (DynamicObject)currentServiceOp.get().getValue();
        Object[] ids = serviceMap.values().stream().map(m -> m.get("id")).toArray();
        QFilter filter = new QFilter("group", "in", (Object)ids);
        Map cachePrinters = BusinessDataServiceHelper.loadFromCache((String)"bos_cloudprintmanage", (QFilter[])new QFilter[]{filter});
        ArrayList<Map<String, Object>> printers = new ArrayList<Map<String, Object>>(cachePrinters.size());
        cachePrinters.forEach((printerId, cachePrinter) -> {
            HashMap<String, String> printer = new HashMap<String, String>(2);
            printer.put(PRINTER_ADDRESS, cachePrinter.getString(PRINTER_ADDRESS));
            printer.put(NAME, cachePrinter.getString(NAME));
            printers.add(printer);
        });
        result.setPrinters(printers);
        result.setServiceNumber(String.valueOf(currentService.get(NUMBER)));
        result.setServiceName(currentService.getString(NAME));
        return result;
    }

    private Object registerNewServiceByNumber(String accountId, String serviceNumber, String serviceName) {
        boolean isExistService;
        if (StringUtils.isBlank((CharSequence)serviceNumber)) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_cloudprintservice", (QFilter[])new QFilter[]{new QFilter(NAME, "=", (Object)serviceName)});
        if (dynamicObject != null && !serviceNumber.equals(dynamicObject.get(NUMBER))) {
            throw new PrintException("5", ResManager.loadKDString((String)"\u529e\u516c\u70b9\u540d\u79f0\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PrintClientService_4", (String)"bos-print-service", (Object[])new Object[0]));
        }
        DynamicObject dynaObj = null;
        if (StringUtils.isNotBlank((CharSequence)serviceNumber) && (isExistService = QueryServiceHelper.exists((String)"bos_cloudprintservice", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)serviceNumber)})) && (dynaObj = BusinessDataServiceHelper.loadSingle((String)"bos_cloudprintservice", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)serviceNumber)})) != null) {
            dynaObj.set(NAME, (Object)new LocaleString(serviceName));
            dynaObj.set("servicetype", (Object)"B");
            dynaObj.set(MODIFYTIME, (Object)new Date());
            dynaObj.set(ACCOUNTID, (Object)accountId);
        }
        if (dynaObj == null || ObjectUtils.isEmpty((Object)dynaObj.getPkValue())) {
            dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_cloudprintservice");
            if (StringUtils.isNotBlank((CharSequence)serviceNumber)) {
                dynaObj.set(NUMBER, (Object)serviceNumber);
                dynaObj.set("longnumber", (Object)serviceNumber);
            }
            dynaObj.set(NAME, (Object)new LocaleString(serviceName));
            dynaObj.set(STATUS, (Object)"C");
            dynaObj.set(CREATETIME, (Object)new Date());
            dynaObj.set(MODIFYTIME, (Object)new Date());
            dynaObj.set(ENABLE, (Object)"1");
            dynaObj.set(ACCOUNTID, (Object)accountId);
            dynaObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            dynaObj.set("servicetype", (Object)"B");
        }
        log.debug("registerService, accountId = " + accountId + ", serviceNumber = " + serviceNumber);
        Object[] obj = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynaObj});
        if (obj != null && obj.length > 0) {
            return ((DynamicObject)obj[0]).getPkValue();
        }
        return null;
    }

    public ClientPrintTask queryTask(String serviceNumber) {
        QFilter qFilter = new QFilter("servicen", "=", (Object)serviceNumber);
        qFilter.and(new QFilter("exptype", "=", (Object)"client"));
        LocalDate localDate = LocalDate.now().plusDays(-2L);
        qFilter.and(new QFilter(CREATETIME, ">=", (Object)localDate));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTask", (String)"bos_print_result", (String)"taskid,printer,taskname,createtime,status", (QFilter[])new QFilter[]{qFilter}, (String)"createtime desc");){
            ClientPrintTask clientTask = new ClientPrintTask();
            clientTask.setServiceNumber(serviceNumber);
            while (ds.hasNext()) {
                Row row = ds.next();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("taskId", row.getString("taskid"));
                map.put("taskName", row.getString("taskname"));
                map.put("printer", row.getString("printer"));
                map.put(CREATETIME, row.getDate(CREATETIME));
                map.put(STATUS, row.getString(STATUS));
                clientTask.addTask(map);
            }
            ClientPrintTask clientPrintTask = clientTask;
            return clientPrintTask;
        }
    }

    public void clearTask() {
        QFilter qFilter = new QFilter("disktype", "=", (Object)"2");
        LocalDate localDate = LocalDate.now().plusDays(-30L);
        qFilter.and(new QFilter(CREATETIME, "<", (Object)localDate));
        DeleteServiceHelper.delete((String)"bos_print_result", (QFilter[])new QFilter[]{qFilter});
    }

    public void updateTask(String taskId, boolean isSuccess) {
        ExecuteLife executeLife;
        log.debug("\u6253\u5370\u5ba2\u6237\u7aef\uff0c\u66f4\u65b0\u6253\u5370\u72b6\u6001\u5b8c\u6210,taskId={},isSuccess={}", (Object)taskId, (Object)isSuccess);
        String status = "C";
        if (isSuccess) {
            status = "B";
        }
        if ("C".equals(status) && (executeLife = ExecuteLife.get((String)taskId)) != null) {
            executeLife.setStop();
        }
        String sql = "update t_svc_printresult set fstatus = ? where ftaskId = ?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(2);
        params.add(new SqlParameter(":fstatus", 12, (Object)status));
        params.add(new SqlParameter(":ftaskId", 12, (Object)taskId));
        int ret = DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (ret > 0) {
            DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_svc_printresult");
            cacheManager.removeByPrimaryKey(new Object[]{Long.parseLong(taskId)});
        }
        try {
            String prtInfo;
            if (isSuccess && (prtInfo = (String)this.getDistributeCache().get("cPrintInfo" + taskId)) != null) {
                String appId;
                PrtTaskResult prtResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId, (boolean)true);
                if (prtResult == null) {
                    prtResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId, (boolean)false);
                }
                long userId = -1L;
                String u = prtResult.getUserId();
                if (StringUtils.isNotBlank((CharSequence)u)) {
                    userId = Long.parseLong(u);
                }
                if (StringUtils.isBlank((CharSequence)(appId = prtResult.getAppId()))) {
                    appId = "bos";
                }
                String finalAppId = appId;
                Map infoMap = (Map)SerializationUtils.fromJsonString((String)prtInfo, Map.class);
                long finalUserId = userId;
                infoMap.forEach((formId, pkIds) -> {
                    PrintInfoParam param = new PrintInfoParam();
                    param.setUserId(finalUserId);
                    param.setRecordModel(PrintCountProp.PrintRecordModel.PRINT.getValue());
                    param.setPkIds(pkIds);
                    param.setEntityTypeId(formId);
                    DispatchServiceHelper.invokeBOSServiceByAppId((String)finalAppId, (String)"BosPrintBusinessService", (String)"updatePrintInfo", (Object[])new Object[]{param});
                });
                this.getDistributeCache().remove("cPrintInfo" + taskId);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return;
        }
    }

    public Map<String, Object> getFontInfo(String fontKey) {
        String sql = "select frcid,fnumber,fname from t_svc_printfont where fnumber = ? or fname=?";
        Map res = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{fontKey, fontKey}, rSet -> {
            HashMap<String, String> result = new HashMap<String, String>(16);
            while (rSet.next()) {
                result.put("rcId", rSet.getString(1));
                result.put(NUMBER, rSet.getString(2));
                result.put(NAME, rSet.getString(3));
            }
            return result;
        });
        sql = "select filename,furl,filetype,fdata,filetype  from t_svc_printresource where fid=?";
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{Long.parseLong(res.get("rcId").toString())}, rSet -> {
            while (rSet.next()) {
                res.put("fileName", rSet.getString(1));
                res.put("url", rSet.getString(2));
                res.put("ext", rSet.getString(3));
                res.put("data", rSet.getBytes(4));
            }
            return null;
        });
        return res;
    }
}

