/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.webapi.service;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.print.param.PrintDeployFile;
import kd.bos.print.api.metedata.MetadataUtil;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadata;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadataL;
import kd.bos.print.business.metedata.bean.DesignMetadata;
import kd.bos.print.business.metedata.bean.DesignMetadataL;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadata;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadataL;
import kd.bos.print.business.metedata.bean.PrintMetaLangXml;
import kd.bos.print.service.webapi.PrintMultiLangData;
import kd.bos.print.service.webapi.PrintMultiLangParam;
import kd.bos.print.service.webapi.PrintTplInfo;
import kd.bos.print.service.webapi.PrintTplMultiLang;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;

public class PrintMultiLangService {
    private static final Log log = LogFactory.getLog(PrintMultiLangService.class);
    private static final String TPL_META = "bos_printtpl_lbr";
    private static final String TABLE_META = "t_svc_printmeta";
    private static final String TABLE_META_L = "t_svc_printmeta_l";
    private static final String TABLE_TPL = "t_svc_printtpl";
    private static final String TABLE_TPL_L = "t_svc_printtpl_l";
    private static final String SPIT = ",";
    private static final String TPL_APP_ID = "18XR3MJ0W0ET";
    private boolean sysLibrary;

    private IDataEntityType getDataEntityType(boolean sysLibrary) {
        if (sysLibrary) {
            return OrmUtils.getDataEntityType(LibraryDesignMetadata.class);
        }
        return OrmUtils.getDataEntityType(DesignMetadata.class);
    }

    private IDataEntityType getDataEntityLType(boolean sysLibrary) {
        if (sysLibrary) {
            return OrmUtils.getDataEntityType(LibraryDesignMetadataL.class);
        }
        return OrmUtils.getDataEntityType(DesignMetadataL.class);
    }

    public PrintMultiLangData loadMultiLangData(PrintMultiLangParam param) {
        Object[] metas;
        String tplIds = param.getTplIds();
        String langs = param.getLangs();
        boolean allLang = param.isAllLang();
        Object[] tplIdArr = tplIds.split(SPIT);
        String[] langArr = allLang ? this.getLocalLang().toArray(new String[0]) : langs.split(SPIT);
        Map<String, Map<String, Map<String, Object>>> tplId2KeyLocaleValueMap = this.createTplId2LocaleDataMap((String[])tplIdArr);
        PrintMultiLangData result = new PrintMultiLangData();
        ArrayList<PrintTplMultiLang> tplLangs = new ArrayList<PrintTplMultiLang>(tplIdArr.length);
        result.setTplLangs(tplLangs);
        for (Object meta : metas = BusinessDataReader.load((Object[])tplIdArr, (IDataEntityType)this.getDataEntityType(this.sysLibrary))) {
            if (!(meta instanceof AbstractDesignMetadata)) continue;
            AbstractDesignMetadata designMetadata = (AbstractDesignMetadata)meta;
            String metaData = designMetadata.getData();
            if (StringUtils.isBlank((CharSequence)metaData)) {
                return null;
            }
            PrintMetadata printMetadata = MetadataUtil.parseMetadata((String)metaData);
            printMetadata.setVersion(designMetadata.getVersion());
            Map<String, Map<String, Object>> key2LocaleValueMap = tplId2KeyLocaleValueMap.get(printMetadata.getId());
            if (key2LocaleValueMap == null) {
                key2LocaleValueMap = new HashMap<String, Map<String, Object>>(0);
            }
            Map localDataMap = MetadataUtil.buildLocaleDataMap((PrintMetadata)printMetadata, key2LocaleValueMap, (String[])langArr, null);
            PrintTplMultiLang tplLang = new PrintTplMultiLang();
            tplLang.setTplId(printMetadata.getId());
            tplLang.setLocaleInfos(localDataMap);
            tplLangs.add(tplLang);
        }
        return result;
    }

    private Map<String, Map<String, Map<String, Object>>> createTplId2LocaleDataMap(String[] tplIdArr) {
        Object[] metaLs = this.loadDesignMetadataL(tplIdArr);
        HashMap<String, Map> tplId2LocaleDataMap = new HashMap<String, Map>(tplIdArr.length);
        for (Object localValue : metaLs) {
            String data;
            AbstractDesignMetadataL designMetadataL = (AbstractDesignMetadataL)localValue;
            String tplId2 = designMetadataL.getId();
            if (StringUtils.isBlank((CharSequence)tplId2)) continue;
            HashMap<String, Map> localeDataMap = (HashMap<String, Map>)tplId2LocaleDataMap.get(tplId2);
            if (localeDataMap == null) {
                localeDataMap = new HashMap<String, Map>(8);
            }
            if (StringUtils.isNotBlank((CharSequence)(data = designMetadataL.getData()))) {
                Map value = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                localeDataMap.put(designMetadataL.getLocaleId(), value);
            }
            tplId2LocaleDataMap.put(tplId2, localeDataMap);
        }
        HashMap<String, Map<String, Map<String, Object>>> tplId2KeyLocaleValueMap = new HashMap<String, Map<String, Map<String, Object>>>(tplIdArr.length);
        tplId2LocaleDataMap.forEach((tplId, localeId2LocaleDataMap) -> {
            HashMap key2LocaleValueMap = new HashMap(16);
            localeId2LocaleDataMap.forEach((localeId, key2TextMap) -> key2TextMap.forEach((key, text) -> {
                HashMap<String, Object> localeId2ValueMap = (HashMap<String, Object>)key2LocaleValueMap.get(key);
                if (localeId2ValueMap == null) {
                    localeId2ValueMap = new HashMap<String, Object>(8);
                }
                localeId2ValueMap.put((String)localeId, text);
                key2LocaleValueMap.put(key, localeId2ValueMap);
            }));
            tplId2KeyLocaleValueMap.put((String)tplId, key2LocaleValueMap);
        });
        tplId2LocaleDataMap.clear();
        return tplId2KeyLocaleValueMap;
    }

    private Map<String, List<AbstractDesignMetadataL>> createTplId2DesignMetaLsMap(String[] tplIdArr, List<String> targetLangs) {
        Object[] metaLs = this.loadDesignMetadataL(tplIdArr);
        HashMap<String, List<AbstractDesignMetadataL>> tplId2DesignMetaLMap = new HashMap<String, List<AbstractDesignMetadataL>>(tplIdArr.length);
        for (Object localValue : metaLs) {
            AbstractDesignMetadataL designMetadataL = (AbstractDesignMetadataL)localValue;
            String tplId = designMetadataL.getId();
            if (StringUtils.isBlank((CharSequence)tplId) || !targetLangs.contains(designMetadataL.getLocaleId())) continue;
            ArrayList<AbstractDesignMetadataL> designMetadataLs = (ArrayList<AbstractDesignMetadataL>)tplId2DesignMetaLMap.get(tplId);
            if (designMetadataLs == null) {
                designMetadataLs = new ArrayList<AbstractDesignMetadataL>(10);
            }
            designMetadataLs.add(designMetadataL);
            tplId2DesignMetaLMap.put(tplId, designMetadataLs);
        }
        return tplId2DesignMetaLMap;
    }

    private Object[] loadDesignMetadataL(String[] tplIdArr) {
        Object[] metaLs = BusinessDataReader.load((Object[])tplIdArr, (IDataEntityType)this.getDataEntityLType(false));
        if (metaLs == null || metaLs.length == 0) {
            metaLs = BusinessDataReader.load((Object[])tplIdArr, (IDataEntityType)this.getDataEntityLType(true));
            this.sysLibrary = true;
        } else {
            this.sysLibrary = false;
        }
        return metaLs;
    }

    public List<PrintDeployFile> getMultiLangFile(PrintMultiLangParam param) {
        ArrayList<PrintDeployFile> result = new ArrayList<PrintDeployFile>(10);
        String tplIds = param.getTplIds();
        boolean allLang = param.isAllLang();
        List<String> targetLangs = allLang ? this.getLocalLang() : Arrays.asList(param.getLangs().split(SPIT));
        if (targetLangs.isEmpty()) {
            return new ArrayList<PrintDeployFile>(0);
        }
        String[] tplIdArr = tplIds.split(SPIT);
        Map<String, List<AbstractDesignMetadataL>> tplId2DesignMetaLsMap = this.createTplId2DesignMetaLsMap(tplIdArr, targetLangs);
        Map<String, String> tplId2NumberMap = this.selectTplId2NumberMap(tplIds, this.sysLibrary);
        for (String tplId : tplIdArr) {
            List<AbstractDesignMetadataL> designMetadataLs;
            String number = tplId2NumberMap.get(tplId);
            if (number == null || (designMetadataLs = tplId2DesignMetaLsMap.get(tplId)) == null) continue;
            List<PrintDeployFile> deployFiles = this.buildDeployFiles(tplId, number, designMetadataLs);
            result.addAll(deployFiles);
        }
        return result;
    }

    private List<String> getLocalLang() {
        List<String> targetLangs;
        try {
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            List languages = inteService.getLocalLangForPrint("1");
            targetLangs = languages.stream().map(EnabledLang::getNumber).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            targetLangs = new ArrayList<String>(0);
        }
        return targetLangs;
    }

    private List<PrintDeployFile> buildDeployFiles(String tplId, String number, List<AbstractDesignMetadataL> designMetadataLs) {
        ArrayList<PrintDeployFile> files = new ArrayList<PrintDeployFile>(designMetadataLs.size());
        designMetadataLs.forEach(metadataL -> {
            try (StringWriter writer = new StringWriter();){
                PrintMetaLangXml metaLangXml = new PrintMetaLangXml();
                metaLangXml.setId(tplId);
                metaLangXml.setNumber(number);
                metaLangXml.setName(metadataL.getName());
                metaLangXml.setLocalId(metadataL.getLocaleId());
                metaLangXml.setData(metadataL.getData());
                JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{PrintMetaLangXml.class});
                Marshaller marshaller = cont.createMarshaller();
                marshaller.marshal((Object)metaLangXml, (Writer)writer);
                writer.flush();
                String fileContent = writer.toString();
                String fileName = number + "." + metadataL.getLocaleId() + ".prtx";
                PrintDeployFile deployFile = new PrintDeployFile();
                deployFile.setFileName(fileName);
                deployFile.setContent(fileContent);
                deployFile.setId(tplId);
                deployFile.setNumber(number);
                files.add(deployFile);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        });
        return files;
    }

    private Map<String, String> selectTplId2NumberMap(String tplIds, boolean sysLibrary) {
        return this.selectTplId2NumberMap(tplIds.split(SPIT), sysLibrary);
    }

    private Map<String, String> selectTplId2NumberMap(String[] tplIdArr, boolean sysLibrary) {
        SqlBuilder select = new SqlBuilder();
        select.append(String.format("select fid,fnumber from %s where ", sysLibrary ? TABLE_TPL : TABLE_META), new Object[0]).appendIn("fid", (Object[])tplIdArr);
        return (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)select, rs -> {
            HashMap<String, String> numberMap = new HashMap<String, String>(2);
            while (rs.next()) {
                String number;
                String id = rs.getString(1);
                if (!StringUtils.isNotBlank((CharSequence)id) || !StringUtils.isNotBlank((CharSequence)(number = rs.getString(2)))) continue;
                numberMap.put(id, number);
            }
            return numberMap;
        });
    }

    private Map<String, List<String>> selectLocaleIdMap(String[] tplIdArr, boolean sysLibrary) {
        SqlBuilder select = new SqlBuilder();
        select.append(String.format("select fid,flocaleid from %s where ", sysLibrary ? TABLE_TPL_L : TABLE_META_L), new Object[0]).appendIn("fid", (Object[])tplIdArr);
        return (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)select, rs -> {
            HashMap<String, ArrayList<String>> localeIdMap = new HashMap<String, ArrayList<String>>(2);
            while (rs.next()) {
                String localeId;
                String id = rs.getString(1);
                if (!StringUtils.isNotBlank((CharSequence)id) || !StringUtils.isNotBlank((CharSequence)(localeId = rs.getString(2)))) continue;
                ArrayList<String> localeIds = (ArrayList<String>)localeIdMap.get(id);
                if (localeIds == null) {
                    localeIds = new ArrayList<String>(10);
                }
                localeIds.add(localeId);
                localeIdMap.put(id, localeIds);
            }
            return localeIdMap;
        });
    }

    public void applyMultiLangData(PrintMultiLangData param) {
        Throwable throwable;
        TXHandle tx;
        List<PrintTplMultiLang> tplLangs = param.getTplLangs();
        tplLangs.stream().map(PrintTplMultiLang::getTplId).findFirst().ifPresent(tplId -> {
            this.sysLibrary = QueryServiceHelper.exists((String)TPL_META, (Object)tplId);
        });
        String[] tplIdArr = (String[])tplLangs.stream().map(PrintTplMultiLang::getTplId).toArray(String[]::new);
        Map<String, String> tplId2NumberMap = this.selectTplId2NumberMap(tplIdArr, this.sysLibrary);
        Map<String, List<String>> tplId2LocaleIdMap = this.selectLocaleIdMap(tplIdArr, this.sysLibrary);
        ArrayList insertMetaParams = new ArrayList(10);
        ArrayList insertTplParams = new ArrayList(10);
        ArrayList updateMetaParams = new ArrayList(10);
        ArrayList updateTplParams = new ArrayList(10);
        for (PrintTplMultiLang tplLang : tplLangs) {
            String tplId2 = tplLang.getTplId();
            Map<String, String> localeInfos = tplLang.getLocaleInfos();
            if (tplId2NumberMap.get(tplId2) == null) continue;
            List<String> localeIds = tplId2LocaleIdMap.get(tplId2);
            if (localeIds == null) {
                localeInfos.forEach((localeId, data) -> this.buildInsertParams(insertMetaParams, insertTplParams, tplId2, this.sysLibrary, (String)localeId, (String)data));
                continue;
            }
            localeInfos.forEach((localeId, data) -> {
                if (localeIds.contains(localeId)) {
                    this.buildUpdateParams(updateMetaParams, updateTplParams, tplId2, this.sysLibrary, (String)localeId, (String)data);
                } else {
                    this.buildInsertParams(insertMetaParams, insertTplParams, tplId2, this.sysLibrary, (String)localeId, (String)data);
                }
            });
        }
        String insertSql = "insert into %s (fpkid,fid,flocaleid,fdata) values(?,?,?,?)";
        String updateSql = "update %s set fdata = ? where fid = ? and flocaleid = ?";
        try {
            tx = TX.required();
            throwable = null;
            try {
                if (!insertMetaParams.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)String.format(insertSql, TABLE_META_L), insertMetaParams);
                }
                if (!updateMetaParams.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)String.format(updateSql, TABLE_META_L), updateMetaParams);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        try {
            tx = TX.required();
            throwable = null;
            try {
                if (!insertTplParams.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)String.format(insertSql, TABLE_TPL_L), insertTplParams);
                }
                if (!updateTplParams.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)String.format(updateSql, TABLE_TPL_L), updateTplParams);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void buildInsertParams(List<Object[]> insertMetaParams, List<Object[]> insertTplParams, String tplId, boolean sysLibrary, String localeId, String data) {
        SqlParameter[] insertParams = new SqlParameter[]{new SqlParameter("fpkid", 12, (Object)DB.genStringId((String)(sysLibrary ? TABLE_TPL_L : TABLE_META_L))), new SqlParameter("fid", 12, (Object)tplId), new SqlParameter("flocaleid", 12, (Object)localeId), new SqlParameter("fdata", 12, (Object)data)};
        if (sysLibrary) {
            insertTplParams.add(insertParams);
        } else {
            insertMetaParams.add(insertParams);
        }
    }

    private void buildUpdateParams(List<Object[]> updateMetaParams, List<Object[]> updateTplParams, String tplId, boolean sysLibrary, String localeId, String data) {
        SqlParameter[] updateParams = new SqlParameter[]{new SqlParameter("fdata", -16, (Object)data), new SqlParameter("fid", 12, (Object)tplId), new SqlParameter("flocaleid", 12, (Object)localeId)};
        if (sysLibrary) {
            updateTplParams.add(updateParams);
        } else {
            updateMetaParams.add(updateParams);
        }
    }

    public Map<String, List<PrintTplInfo>> queryTplIds(String appId) {
        if (TPL_APP_ID.equals(appId)) {
            return this.selectAllTplId(true, null);
        }
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            return this.selectTplIdByAppId(appId, null);
        }
        return this.selectAllTplId(false, null);
    }

    public Map<String, List<PrintTplInfo>> queryTplIds(String appId, String srcLang) {
        if (TPL_APP_ID.equals(appId)) {
            return this.selectAllTplId(true, srcLang);
        }
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            return this.selectTplIdByAppId(appId, srcLang);
        }
        return this.selectAllTplId(false, srcLang);
    }

    private Map<String, List<PrintTplInfo>> selectAllTplId(boolean sysLibrary, String srcLang) {
        if (sysLibrary) {
            return (Map)DB.query((DBRoute)DBRoute.basedata, (String)String.format("select fid,fname,fnumber from %s where fstatus = 'C'", TABLE_TPL), rs -> {
                HashMap<String, ArrayList<PrintTplInfo>> result = new HashMap<String, ArrayList<PrintTplInfo>>(1);
                ArrayList<PrintTplInfo> infoList = new ArrayList<PrintTplInfo>(10);
                result.put("", infoList);
                while (rs.next()) {
                    String id = rs.getString(1);
                    if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                    PrintTplInfo info = new PrintTplInfo();
                    info.setId(id);
                    info.setName(rs.getString(2));
                    info.setNumber(rs.getString(3));
                    infoList.add(info);
                }
                if (srcLang != null && infoList.size() > 0) {
                    this.selectFromLangTable(srcLang, infoList, TABLE_TPL_L);
                }
                return result;
            });
        }
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)String.format("select fbillformid,fid,fname,fnumber from %s where ftype = 'B' and (ftpltype = '1' or fisv = 'kingdee')", TABLE_META), rs -> {
            HashMap result = new HashMap(16);
            while (rs.next()) {
                String id;
                String formId = rs.getString(1);
                if (!StringUtils.isNotBlank((CharSequence)formId) || !StringUtils.isNotBlank((CharSequence)(id = rs.getString(2)))) continue;
                ArrayList<PrintTplInfo> infoList = (ArrayList<PrintTplInfo>)result.get(formId);
                if (infoList == null) {
                    infoList = new ArrayList<PrintTplInfo>(10);
                }
                PrintTplInfo info = new PrintTplInfo();
                info.setId(id);
                info.setName(rs.getString(3));
                info.setNumber(rs.getString(4));
                infoList.add(info);
                result.put(formId, infoList);
            }
            List<PrintTplInfo> infoList = result.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (srcLang != null && infoList.size() > 0) {
                this.selectFromLangTable(srcLang, infoList, TABLE_META_L);
            }
            return result;
        });
    }

    private Map<String, List<PrintTplInfo>> selectTplIdByAppId(String appId, String srcLang) {
        String select = String.format("select fbillformid,fid,fname,fnumber from %s where fbizappid = ? and ftype = 'B' and (ftpltype = '1' or fisv = 'kingdee')", TABLE_META);
        Object[] parameters = new SqlParameter[]{new SqlParameter("fbizappid", 12, (Object)appId)};
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)select, (Object[])parameters, rs -> {
            HashMap formId2TplIdMap = new HashMap(8);
            while (rs.next()) {
                String tplId;
                String formId = rs.getString(1);
                if (!StringUtils.isNotBlank((CharSequence)formId) || !StringUtils.isNotBlank((CharSequence)(tplId = rs.getString(2)))) continue;
                ArrayList<PrintTplInfo> infoList = (ArrayList<PrintTplInfo>)formId2TplIdMap.get(formId);
                if (infoList == null) {
                    infoList = new ArrayList<PrintTplInfo>(10);
                }
                PrintTplInfo info = new PrintTplInfo();
                info.setId(tplId);
                info.setName(rs.getString(3));
                info.setNumber(rs.getString(4));
                infoList.add(info);
                formId2TplIdMap.put(formId, infoList);
            }
            List<PrintTplInfo> infoList = formId2TplIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (srcLang != null && infoList.size() > 0) {
                this.selectFromLangTable(srcLang, infoList, TABLE_META_L);
            }
            return formId2TplIdMap;
        });
    }

    private void selectFromLangTable(String srcLang, List<PrintTplInfo> infoList, String tableMeta) {
        Map infoMap = infoList.stream().collect(Collectors.toMap(PrintTplInfo::getId, Function.identity()));
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(String.format("select fid,flocaleid,fname from %s where ", tableMeta), new Object[0]);
        sqlBuilder.appendIn("fid", infoList.stream().map(PrintTplInfo::getId).toArray());
        sqlBuilder.append(" and ", new Object[0]);
        sqlBuilder.append("flocaleid = ?", new Object[]{srcLang});
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, resultSet -> {
            while (resultSet.next()) {
                String name;
                String fid = resultSet.getString(1);
                PrintTplInfo info = (PrintTplInfo)infoMap.get(fid);
                if (info == null || (name = resultSet.getString(3)) == null) continue;
                info.setName(name);
            }
            return true;
        });
    }
}

