/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.execute.PFileStorageType;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.service.PrintServiceProxy;
import kd.bos.util.ThreadLocals;

public class ExecuteContext
implements AutoCloseable {
    private static ThreadLocal<ExecuteContext> current = ThreadLocals.create();
    private String taskId;
    private String formId;
    private String appId;
    private String lang;
    private int pageLimit;
    private int dpi = 0;
    private boolean showExp;
    private boolean preview;
    private boolean isVerEconomizePaper;
    private boolean isHorEconomizePaper;
    private boolean economizeByBill;
    private String pageNumType;
    private boolean isPageSeparation;
    private String fileCreateType;
    private Map<String, Object> extParam;
    private boolean isSplicePrint;
    private String expType;
    private PFileStorageType pFileStorageType;
    private String tplVer;
    private String tplId;
    private String tplKey;
    private PrintServiceProxy serviceProxy;
    private PrintPluginProxy pluginProxy;
    private Map<String, Set<String>> hasMergePrintDsMap = new HashMap<String, Set<String>>(1);
    private boolean calculateTotalPage = false;
    private boolean isLastRunModel = false;
    private Map<String, Map<String, Integer>> totalPageMap = new HashMap<String, Map<String, Integer>>(16);

    public static void set(ExecuteContext rc) {
        current.set(rc);
    }

    public static ExecuteContext get() {
        ExecuteContext context = current.get();
        if (context == null) {
            ExecuteContext.set(new ExecuteContext());
        }
        return current.get();
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public void setPageLimit(int pageLimit) {
        this.pageLimit = pageLimit;
    }

    public boolean isShowExp() {
        return this.showExp;
    }

    public void setShowExp(boolean showExp) {
        this.showExp = showExp;
    }

    public PrintServiceProxy getServiceProxy() {
        if (this.serviceProxy == null) {
            this.serviceProxy = new PrintServiceProxy();
        }
        return this.serviceProxy;
    }

    public void setServiceProxy(PrintServiceProxy serviceProxy) {
        this.serviceProxy = serviceProxy;
    }

    public PrintPluginProxy getPluginProxy() {
        return this.pluginProxy;
    }

    public void setPluginProxy(PrintPluginProxy pluginProxy) {
        this.pluginProxy = pluginProxy;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public boolean isVerEconomizePaper() {
        return this.isVerEconomizePaper;
    }

    public void setVerEconomizePaper(boolean verEconomizePaper) {
        this.isVerEconomizePaper = verEconomizePaper;
    }

    public boolean isHorEconomizePaper() {
        return this.isHorEconomizePaper;
    }

    public void setHorEconomizePaper(boolean horEconomizePaper) {
        this.isHorEconomizePaper = horEconomizePaper;
    }

    public String getPageNumType() {
        return this.pageNumType;
    }

    public void setPageNumType(String pageNumType) {
        this.pageNumType = pageNumType;
    }

    public boolean isPageSeparation() {
        return this.isPageSeparation;
    }

    public void setPageSeparation(boolean isPageSeparation) {
        this.isPageSeparation = isPageSeparation;
    }

    public boolean isSplicePrint() {
        return this.isSplicePrint;
    }

    public void setSplicePrint(boolean splicePrint) {
        this.isSplicePrint = splicePrint;
    }

    public String getExpType() {
        return this.expType;
    }

    public void setExpType(String expType) {
        this.expType = expType;
    }

    public Map<String, Object> getExtParam() {
        if (this.extParam == null) {
            return Collections.EMPTY_MAP;
        }
        return this.extParam;
    }

    public void setExtParam(Map<String, Object> extParam) {
        this.extParam = extParam;
    }

    public boolean isRunFast() {
        return true;
    }

    public void setRunFast(boolean runFast) {
    }

    public PFileStorageType getpFileStorageType() {
        return this.pFileStorageType;
    }

    public void setpFileStorageType(PFileStorageType pFileStorageType) {
        this.pFileStorageType = pFileStorageType;
    }

    @Override
    public void close() throws Exception {
    }

    public String getTplVer() {
        return this.tplVer;
    }

    public void setTplVer(String tplVer) {
        this.tplVer = tplVer;
    }

    public String getTplId() {
        return this.tplId;
    }

    public void setTplId(String tplId) {
        this.tplId = tplId;
    }

    public String getTplKey() {
        return this.tplKey;
    }

    public void setTplKey(String tplKey) {
        this.tplKey = tplKey;
    }

    public Map<String, Set<String>> getHasMergePrintDsMap() {
        return this.hasMergePrintDsMap;
    }

    public void setHasMergePrintDsMap(Map<String, Set<String>> hasMergePrintDsMap) {
        this.hasMergePrintDsMap = hasMergePrintDsMap;
    }

    public boolean isCalculateTotalPage() {
        return this.calculateTotalPage;
    }

    public void setCalculateTotalPage(boolean calculateTotalPage) {
        this.calculateTotalPage = calculateTotalPage;
    }

    public Map<String, Integer> getTotalPageMap() {
        if (StringUtils.isBlank((CharSequence)this.tplKey)) {
            return new HashMap<String, Integer>(0);
        }
        if (!this.totalPageMap.containsKey(this.tplKey)) {
            this.totalPageMap.put(this.tplKey, new HashMap(16));
        }
        return this.totalPageMap.get(this.tplKey);
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int dpi) {
        if (dpi < 0) {
            dpi = 0;
        }
        this.dpi = dpi;
    }

    public boolean isFileCreateBySingleBill() {
        return "2".equals(this.fileCreateType);
    }

    public void setFileCreateType(String fileCreateType) {
        this.fileCreateType = fileCreateType;
    }

    public boolean isEconomizeByBill() {
        return this.economizeByBill || this.isFileCreateBySingleBill() && "pdf".equals(this.expType);
    }

    public void setEconomizeByBill(boolean economizeByBill) {
        this.economizeByBill = economizeByBill;
    }

    public boolean isLastRunModel() {
        return this.isLastRunModel;
    }

    public void setLastRunModel(boolean lastRunModel) {
        this.isLastRunModel = lastRunModel;
    }
}

