/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.currency;

import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ctrl.common.currency.ICurrencyUpperFunction;
import kd.bos.print.core.ctrl.common.digitalstyle.Format;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.variant.Variant;

public class FormatRMB
implements ICurrencyUpperFunction {
    private Format formatField;

    public String format(Variant variant) {
        this.formatField = Formats.getFormat("[Rmb]G/\u901a\u7528\u683c\u5f0f;[Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        FormatResult result = this.formatField.format(variant);
        return result.toString();
    }

    @Override
    public String format(Locale locale, Variant variant, boolean isAddPrefix) {
        String result = null;
        if (locale == Locale.ENGLISH) {
            this.formatField = Formats.getFormat("[ENG-RMB]g/\u901a\u7528\u683c\u5f0f");
        } else if (locale == Locale.SIMPLIFIED_CHINESE) {
            this.formatField = Formats.getFormat("[Rmb]G/\u901a\u7528\u683c\u5f0f;[Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        } else if (locale == Locale.TRADITIONAL_CHINESE) {
            this.formatField = Formats.getFormat("[CHT-Rmb]G/\u901a\u7528\u683c\u5f0f;[CHT-Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        } else {
            throw new RuntimeException("Not support language: " + locale);
        }
        result = this.formatField.format4Print(variant).toString();
        if (isAddPrefix) {
            if (locale == Locale.ENGLISH) {
                return result;
            }
            if (locale == Locale.SIMPLIFIED_CHINESE) {
                result = String.format(ResManager.loadKDString((String)"\u4eba\u6c11\u5e01%s", (String)"FormatRMB_3", (String)"bos-print-core", (Object[])new Object[0]), result);
            } else if (locale == Locale.TRADITIONAL_CHINESE) {
                result = String.format(ResManager.loadKDString((String)"\u4eba\u6c11\u5e01%s", (String)"FormatRMB_3", (String)"bos-print-core", (Object[])new Object[0]), result);
            } else {
                throw new RuntimeException("Not support language: " + locale);
            }
        }
        return result;
    }
}

