/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.currency;

import java.util.Locale;
import kd.bos.print.core.ctrl.common.currency.ICurrencyUpperFunction;
import kd.bos.print.core.ctrl.common.digitalstyle.Format;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.variant.Variant;

public class FormatUSD
implements ICurrencyUpperFunction {
    private Format formatField;

    public String format(Variant variant) {
        this.formatField = Formats.getFormat("[Dollar]G/\u901a\u7528\u683c\u5f0f;[Dollar](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        FormatResult result = this.formatField.format4Print(variant);
        return result.toString();
    }

    @Override
    public String format(Locale locale, Variant variant, boolean isAddPrefix) {
        String result = null;
        if (locale == Locale.ENGLISH) {
            this.formatField = Formats.getFormat("[ENG-USD]g/\u901a\u7528\u683c\u5f0f");
        } else if (locale == Locale.SIMPLIFIED_CHINESE) {
            this.formatField = Formats.getFormat("[Dollar]G/\u901a\u7528\u683c\u5f0f;[Dollar](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        } else if (locale == Locale.TRADITIONAL_CHINESE) {
            this.formatField = Formats.getFormat("[CHT-USD]G/\u901a\u7528\u683c\u5f0f;[CHT-USD](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        } else {
            throw new RuntimeException("Not support language: " + locale);
        }
        result = this.formatField.format4Print(variant).toString();
        return result;
    }
}

