/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.digitalstyle;

import java.util.Calendar;
import java.util.Locale;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.LanguageCondition;
import kd.bos.print.core.ctrl.common.digitalstyle.Node;
import kd.bos.print.core.ctrl.common.digitalstyle.SimpleFormat;
import kd.bos.print.core.ctrl.common.digitalstyle.Symbols;
import kd.bos.print.core.ctrl.common.variant.SyntaxErrorException;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.swing.util.CtrlFormatUtilities;

class DateTimeFormat
extends SimpleFormat {
    private boolean _am_pm;
    private LanguageCondition _lc;

    DateTimeFormat() {
    }

    void setLanguageCondition(LanguageCondition lc) {
        this._lc = lc;
    }

    void setAM_PM(boolean b) {
        this._am_pm = b;
    }

    @Override
    public FormatResult format(Variant var, boolean parse) {
        if (var == null) {
            return FormatResult.NullResult;
        }
        Calendar calendar = null;
        try {
            if (parse || var.isNumber() || var.isDate()) {
                calendar = var.toCalendar();
            }
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        if (calendar == null) {
            return FormatResult.NullResult;
        }
        StringBuilder sb = new StringBuilder();
        int repeatIndex = -1;
        int size = this._nodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = (Node)this._nodes.get(i);
            sb.append(this.getNodeText(node, calendar));
            if (node.getType() != 24) continue;
            repeatIndex = sb.length() - 1;
        }
        String result = sb.toString();
        return new FormatResult(result, repeatIndex);
    }

    private String getNodeText(Node node, Calendar cal) {
        switch (node.getType()) {
            case 4: {
                String str = String.valueOf(cal.get(1));
                if (this._lc != null) {
                    str = this._lc.translate3(str);
                }
                return str;
            }
            case 5: {
                String str = String.valueOf(cal.get(1)).substring(2);
                if (this._lc != null) {
                    str = this._lc.translate2(str);
                }
                return str;
            }
            case 6: {
                String str = String.valueOf(cal.get(2) + 1);
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 7: {
                String str = this.getFullString(String.valueOf(cal.get(2) + 1));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 8: {
                return Symbols.getMonth(cal.get(2) + 1).substring(0, 3);
            }
            case 9: {
                return Symbols.getMonth(cal.get(2) + 1);
            }
            case 10: {
                return Symbols.getMonth(cal.get(2) + 1).substring(0, 1);
            }
            case 11: {
                String str = String.valueOf(cal.get(5));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 12: {
                String str = this.getFullString(String.valueOf(cal.get(5)));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 13: {
                return Symbols.getDay(cal.get(7)).substring(2);
            }
            case 14: {
                return Symbols.getDay(cal.get(7), this.getDefaultLocale());
            }
            case 15: 
            case 30: {
                String str = this.getHour(node, cal);
                if (this._lc != null) {
                    str = this.tryDealZero(str);
                }
                return str;
            }
            case 16: 
            case 31: {
                String str = this.getFullString(this.getHour(node, cal));
                if (this._lc != null) {
                    str = this.tryDealZero(str);
                }
                return str;
            }
            case 17: {
                String str = String.valueOf(cal.get(12));
                if (this._lc != null) {
                    str = this.tryDealZero(str);
                }
                return str;
            }
            case 18: {
                String str = this.getFullString(String.valueOf(cal.get(12)));
                if (this._lc != null) {
                    str = this.tryDealZero(str);
                }
                return str;
            }
            case 19: {
                String str = String.valueOf(cal.get(13));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 20: {
                String str = this.getFullString(String.valueOf(cal.get(13)));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 27: {
                this._am_pm = true;
                return cal.get(11) >= 12 ? CtrlFormatUtilities.getDateFormatSymbols().getAmPmStrings()[1] : CtrlFormatUtilities.getDateFormatSymbols().getAmPmStrings()[0];
            }
        }
        return node.getText();
    }

    private Locale getDefaultLocale() {
        String lang = ExecuteContext.get().getLang();
        if (StringUtils.isBlank((CharSequence)lang)) {
            return ZH_CN;
        }
        if ("en_US".equalsIgnoreCase(lang)) {
            return EN_US;
        }
        return ZH_CN;
    }

    private String tryDealZero(String str) {
        str = "0".equals(str) || "00".equals(str) ? this._lc.translate3(str) : this._lc.translate(str);
        return str;
    }

    private String getHour(Node node, Calendar cal) {
        if (node == Node.Hour_one || node == Node.Hour_two || this._am_pm) {
            int hour = cal.get(10);
            return hour == 0 ? "12" : String.valueOf(hour);
        }
        return String.valueOf(cal.get(11));
    }

    private String getFullString(String str) {
        if (str.length() == 1) {
            str = '0' + str;
        }
        return str;
    }

    @Override
    public FormatResult format4Print(Variant obj, boolean parse) {
        return FormatResult.EmptyResult;
    }
}

