/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.digitalstyle;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.digitalstyle.Node;
import kd.bos.print.core.ctrl.common.digitalstyle.SimpleFormat;
import kd.bos.print.core.ctrl.common.variant.Util;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.kdf.util.CtrlFormatUtilities;

class GeneralFormat
extends SimpleFormat {
    static final GeneralFormat defaultInstance = new GeneralFormat();

    GeneralFormat() {
    }

    @Override
    public FormatResult format(Variant var, boolean parse) {
        if (var == null) {
            return FormatResult.NullResult;
        }
        String likelyValue = this.getLikelyValue(var);
        StringBuilder sb = new StringBuilder();
        int repeatIndex = -1;
        int size = this._nodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = (Node)this._nodes.get(i);
            if (node.getType() == 26) {
                sb.append(likelyValue);
            } else {
                sb.append(node.getText());
            }
            if (node.getType() != 24) continue;
            repeatIndex = i;
        }
        String result = sb.toString();
        return new FormatResult(result, repeatIndex);
    }

    String getLikelyValue(Variant var) {
        String ret = null;
        int vt = var.getVt();
        if (vt == 10) {
            BigDecimal bd = (BigDecimal)var.getValue();
            if (bd.scale() > 15) {
                Variant varTmp = new Variant(bd.setScale(15, 4), 10);
                Util.reduceScale(varTmp);
                ret = varTmp.toString();
            } else {
                ret = Util.bigDecimalToPlainString(bd);
            }
            ret = ret.replace('.', CtrlFormatUtilities.getDecimalFormatSymbols().getDecimalSeparator());
        } else {
            ret = var.isDate() ? Formats.getFormat("yyyy-mm-dd").format(var).toString() : var.toString();
        }
        return ret;
    }

    @Override
    public FormatResult format4Print(Variant obj, boolean parse) {
        return FormatResult.EmptyResult;
    }

    static {
        GeneralFormat.defaultInstance._nodes = new ArrayList();
        GeneralFormat.defaultInstance._nodes.add(Node.General);
    }
}

