/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.digitalstyle;

import java.util.HashMap;
import java.util.Map;
import kd.bos.print.core.ctrl.common.digitalstyle.i18n.IMultiLanguageSay;
import kd.bos.print.core.ctrl.common.digitalstyle.i18n.chs.SimplifiedChineseSay;
import kd.bos.print.core.ctrl.common.digitalstyle.i18n.cht.TraditionalChineseSay;
import kd.bos.print.core.ctrl.common.digitalstyle.i18n.eng.EnglishSay;
import kd.bos.print.core.ctrl.common.variant.Variant;

class NumMultiLanFormat {
    private static Map LAN_STRATEGY;

    NumMultiLanFormat() {
    }

    private static synchronized Map getStrategy() {
        if (LAN_STRATEGY == null) {
            LAN_STRATEGY = new HashMap(3);
            LAN_STRATEGY.put("ENG", new EnglishSay());
            LAN_STRATEGY.put("CHS", new SimplifiedChineseSay());
            LAN_STRATEGY.put("CHT", new TraditionalChineseSay());
        }
        return LAN_STRATEGY;
    }

    public String formatNumber(Variant value, String lan) {
        IMultiLanguageSay strategy = (IMultiLanguageSay)NumMultiLanFormat.getStrategy().get(lan.toUpperCase());
        if (strategy != null) {
            return strategy.sayNumber(value);
        }
        return value.toString();
    }

    public String formatCurrency(Variant value, String lan, String currencyIsoCode) {
        IMultiLanguageSay strategy = (IMultiLanguageSay)NumMultiLanFormat.getStrategy().get(lan.toUpperCase());
        if (strategy != null) {
            return strategy.sayCurrency(value, currencyIsoCode);
        }
        return value.toString();
    }
}

