/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.digitalstyle;

import java.util.Locale;
import kd.bos.print.core.ctrl.common.digitalstyle.Format;

final class Symbols {
    private static String symbols = "Symbols";
    static final char SYMBOL_ASTERISK = '*';
    static final char SYMBOL_UNDERLINE = '_';
    static final char SYMBOL_BACKLASH = '\\';
    static final char SYMBOL_EXLMMARK = '!';
    static final char SYMBOL_SEMICOLON = ';';
    static final char SYMBOL_QUOTATIONMARK = '\"';
    static final char SYMBOL_LEFTSQUAREBKT = '[';
    static final char SYMBOL_RIGHTSQUAREBKT = ']';
    static final char SYMBOL_ZERO = '0';
    static final char SYMBOL_COMMA = ',';
    static final char SYMBOL_RADIXPOINT = '.';
    static final char SYMBOL_DIGIT = '#';
    static final char SYMBOL_QUEMARK = '?';
    static final char SYMBOL_PRECENT = '%';
    static final char SYMBOL_MINUS = '-';
    static final char SYMBOL_Y = 'y';
    static final char SYMBOL_M = 'm';
    static final char SYMBOL_MONTH = 'M';
    static final char SYMBOL_MINUTE = 'm';
    static final char SYMBOL_D = 'd';
    static final char SYMBOL_H = 'h';
    static final char SYMBOL_S = 's';
    static final char SYMBOL_24H = 'H';
    static final char SYMBOL_ALTA = '@';
    static final char SYMBOL_SLASH = '/';
    static final char SYMBOL_E = 'e';
    static final String GENERAL = "G/\u901a\u7528\u683c\u5f0f";
    static final String AM_PM = "AM/PM";
    static final String AM = "AM";
    static final String PM = "PM";
    static final String JANUARY = "January";
    static final String FEBRUARY = "February";
    static final String MARCH = "March";
    static final String APRIL = "April";
    static final String MAY = "May";
    static final String JUNE = "June";
    static final String JULY = "July";
    static final String AUGUST = "August";
    static final String SEPTEMBER = "September";
    static final String OCTOBER = "October";
    static final String NOVEMBER = "November";
    static final String DECEMBER = "December";
    static final String BLACK = "black";
    static final String BLUE = "blue";
    static final String CYAN = "cyan";
    static final String GREEN = "green";
    static final String MAGENTA = "magenta";
    static final String RED = "red";
    static final String RED1 = "\u7ea2\u8272";
    static final String WHITE = "white";
    static final String YELLOW = "yellow";

    Symbols() {
    }

    static boolean isA(char c) {
        return c == 'a';
    }

    static boolean isNumberChar(char c) {
        return c == '#' || c == '0' || c == '?';
    }

    static boolean isDecimalSeparator(char c) {
        return c == '.';
    }

    static boolean isDateTime(char c) {
        return Symbols.isDate(c) || Symbols.isTime(c);
    }

    static boolean isDate(char c) {
        return c == 'y' || c == 'M' || c == 'm' || c == 'd';
    }

    static boolean isTime(char c) {
        return c == 'H' || c == 'h' || c == 'm' || c == 's';
    }

    static boolean isGroupSeparator(char c) {
        return c == ',';
    }

    static boolean isText(char c) {
        return c == '@';
    }

    static boolean isFraction(char c) {
        return c == '/';
    }

    static boolean isScience(char c) {
        return c == 'e';
    }

    static boolean isPercent(char c) {
        return c == '%';
    }

    static String getAmpm() {
        return AM_PM;
    }

    static String getGeneral() {
        return GENERAL;
    }

    static String getMonth(int month) {
        switch (month) {
            case 1: {
                return JANUARY;
            }
            case 2: {
                return FEBRUARY;
            }
            case 3: {
                return MARCH;
            }
            case 4: {
                return APRIL;
            }
            case 5: {
                return MAY;
            }
            case 6: {
                return JUNE;
            }
            case 7: {
                return JULY;
            }
            case 8: {
                return AUGUST;
            }
            case 9: {
                return SEPTEMBER;
            }
            case 10: {
                return OCTOBER;
            }
            case 11: {
                return NOVEMBER;
            }
            case 12: {
                return DECEMBER;
            }
        }
        return "";
    }

    static String getDay(int day) {
        return Symbols.getDay(day, Format.ZH_CN);
    }

    static String getDay(int day, Locale locale) {
        switch (day) {
            case 1: {
                return "\u661f\u671f\u65e5";
            }
            case 2: {
                return "\u661f\u671f\u4e00";
            }
            case 3: {
                return "\u661f\u671f\u4e8c";
            }
            case 4: {
                return "\u661f\u671f\u4e09";
            }
            case 5: {
                return "\u661f\u671f\u56db";
            }
            case 6: {
                return "\u661f\u671f\u4e94";
            }
            case 7: {
                return "\u661f\u671f\u516d";
            }
        }
        return "";
    }
}

