/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.digitalstyle.i18n.eng;

import kd.bos.print.core.ctrl.common.digitalstyle.i18n.IMultiLanguageSay;
import kd.bos.print.core.ctrl.common.digitalstyle.i18n.IMultiLanguageSayBase;
import kd.bos.print.core.ctrl.common.digitalstyle.i18n.Util;
import kd.bos.print.core.ctrl.common.digitalstyle.i18n.eng.EnglishCurrencyCommon;
import kd.bos.print.core.ctrl.common.digitalstyle.i18n.eng.EnglishMYR;
import kd.bos.print.core.ctrl.common.digitalstyle.i18n.eng.EnglishTHB;
import kd.bos.print.core.ctrl.common.variant.Variant;

public class EnglishSay
implements IMultiLanguageSay,
IMultiLanguageSayBase {
    private static final String[] BASES = new String[]{"ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
    private static final String[] TENS = new String[]{null, null, "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
    private static final String[] UNITS = new String[]{null, "THOUSAND", "MILLION", "BILLION", "TRILLION", "ZILLION"};
    private static final String HUNDRED = "HUNDRED";
    static final char SPACE = ' ';
    static final String AND = "AND";

    @Override
    public String sayNumber(Variant value) {
        int idx0;
        StringBuilder sbSaying = new StringBuilder();
        String[] intAndDec = Util.pickIntAndDec(value.toString());
        if (intAndDec[idx0 = 0] != null) {
            String strInteger = Util.formatToString(new Variant(intAndDec[idx0]), "#,##0");
            try {
                sbSaying.append(this.sayInteger(strInteger));
            }
            catch (NumberFormatException ex) {
                return value.toString();
            }
        } else {
            sbSaying.append(BASES[idx0]);
        }
        int idx1 = 1;
        if (intAndDec[idx1] != null) {
            sbSaying.append(' ');
            sbSaying.append("POINT");
            for (int i = idx0; i < intAndDec[idx1].length(); ++i) {
                sbSaying.append(' ');
                try {
                    sbSaying.append(BASES[Integer.parseInt(String.valueOf(intAndDec[idx1].charAt(i)))]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    return value.toString();
                }
            }
        }
        return sbSaying.toString();
    }

    @Override
    public String sayCurrency(Variant value, String currencyIsoCode) {
        if ("THB".equalsIgnoreCase(currencyIsoCode)) {
            return new EnglishTHB().sayCurrency(value, currencyIsoCode, this);
        }
        if ("MYR".equalsIgnoreCase(currencyIsoCode)) {
            return new EnglishMYR().sayCurrency(value, currencyIsoCode, this);
        }
        return new EnglishCurrencyCommon().sayCurrency(value, currencyIsoCode, this);
    }

    @Override
    public String sayInteger(String strInteger) {
        if ("0".equals(strInteger)) {
            return BASES[0];
        }
        StringBuilder sbSaying = new StringBuilder();
        String[] ints = Util.splitInt(strInteger);
        int segLen = ints.length;
        for (int i = 0; i < segLen; ++i) {
            int lessHundred;
            int oneBit;
            int tenBit;
            int hundredBit = Util.rightString(ints[i], 3);
            if (hundredBit + (tenBit = Util.rightString(ints[i], 2)) + (oneBit = Util.rightString(ints[i], 1)) == 0) continue;
            if (i > 0) {
                sbSaying.append(' ');
            }
            if (hundredBit > 0) {
                sbSaying.append(BASES[hundredBit]);
                sbSaying.append(' ');
                sbSaying.append(HUNDRED);
            }
            if ((lessHundred = tenBit * 10 + oneBit) > 0) {
                if (hundredBit > 0) {
                    sbSaying.append(' ');
                    sbSaying.append(AND);
                    sbSaying.append(' ');
                } else if (i == segLen - 1 && segLen > 1) {
                    sbSaying.append(AND);
                    sbSaying.append(' ');
                }
                if (tenBit < 2) {
                    sbSaying.append(BASES[lessHundred]);
                } else {
                    sbSaying.append(TENS[tenBit]);
                    if (oneBit > 0) {
                        sbSaying.append(' ');
                        sbSaying.append(BASES[oneBit]);
                    }
                }
            }
            String unit = null;
            int idxUnit = segLen - 1 - i;
            unit = idxUnit >= UNITS.length ? "Impossiblellion" : UNITS[idxUnit];
            if (unit == null) continue;
            sbSaying.append(' ');
            sbSaying.append(unit);
        }
        return sbSaying.toString();
    }
}

