/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    public static final Log log = LogFactory.getLog(FileUtil.class);
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int BUFFER_SIZE = 32768;

    public static String normalize(String fileUrl) {
        return StringUtils.isEmpty((String)fileUrl) ? fileUrl : FilenameUtils.normalize((String)fileUrl);
    }

    public static final File createFolder(String filePath) {
        File f = new File(filePath);
        if (f.exists()) {
            return f;
        }
        return FileUtil.createFolder(filePath.split("\\" + FILE_SEPARATOR));
    }

    public static final File createFolder(String[] names) {
        String filePath = names[0];
        File f = null;
        for (int i = 1; i < names.length; ++i) {
            f = new File(filePath = filePath + FILE_SEPARATOR + names[i]);
            if (f.exists()) {
                if (!f.isFile()) continue;
                return null;
            }
            if (f.mkdir()) continue;
            log.debug(":( Create directory failed!!! " + filePath);
            return null;
        }
        return f;
    }

    public static final File createFile(String filePath) throws IOException {
        File f = new File(filePath);
        if (f.exists()) {
            return f;
        }
        int i = filePath.lastIndexOf(FILE_SEPARATOR);
        if (i == -1) {
            log.warn(":( Invalid file path!!! " + filePath);
            return null;
        }
        if (null == FileUtil.createFolder(filePath.substring(0, i))) {
            return null;
        }
        f = new File(filePath);
        if (!f.createNewFile()) {
            log.warn(":( Create file failed!!! " + filePath);
            return null;
        }
        return f;
    }

    public static File deleteFile(File file) {
        if (file.isDirectory()) {
            String[] files = file.list();
            for (int i = 0; i < files.length; ++i) {
                File f = FileUtil.deleteFile(new File(file.getPath() + FILE_SEPARATOR + files[i]));
                if (f == null) continue;
                return f;
            }
        }
        if (file.delete()) {
            return null;
        }
        return file;
    }

    public static File deleteFile(String filePath) {
        return FileUtil.deleteFile(new File(filePath));
    }

    public static boolean deleteContent(String dir) {
        return FileUtil.deleteContent(dir, null);
    }

    public static final boolean deleteContent(String dir, final String prefix) {
        try {
            File file = new File(dir);
            if (file.isDirectory()) {
                String[] files = null;
                files = StringUtil.isEmptyString(prefix) ? file.list() : file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(prefix);
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteFile(dir + FILE_SEPARATOR + files[i]);
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getExtension(String filename) {
        int i;
        if (!StringUtil.isEmptyString(filename) && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static boolean saveString2File(String fileName, String content) throws Exception {
        boolean returnValue = false;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8);){
            writer.write(content);
            writer.flush();
        }
        return returnValue;
    }

    public static void delete(File f) {
        FileUtil.delete(f, false);
    }

    private static void delete(File f, boolean inShutdown) {
        if (!f.delete()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete() && !inShutdown) {
                f.deleteOnExit();
            }
        }
    }
}

