/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.util;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.FileUtil;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.print.core.service.IFontService;

public class FontUtil {
    private static final Log log = LogFactory.getLog(FontUtil.class);
    private static Font simsunServerFont;
    private static boolean simsunInited;
    public static final String DEF_FONT_NAME = "\u601d\u6e90\u5b8b\u4f53 CN";

    public static Font getDefaultFont() {
        IFontService fontService = ExecuteService.getFontService();
        String fontName = fontService != null ? fontService.getDefaultFont().getFontName() : DEF_FONT_NAME;
        return KDFont.createFont(fontName, 0, 12.0f);
    }

    public static void setDefaultFont(Font defaultFont) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Font getServerFontSupportedChinese() {
        if (!simsunInited) {
            String prop = System.getProperty("eas.properties.dir");
            if ((prop = FileUtil.normalize(prop)) != null) {
                try (FileInputStream fileInputStream = new FileInputStream(new File(prop + "/simsun.ttc"));){
                    simsunServerFont = Font.createFont(0, fileInputStream);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                finally {
                    simsunInited = true;
                }
            } else {
                simsunInited = true;
            }
        }
        return simsunServerFont;
    }

    public static AttributedString validateFont(AttributedString str) {
        if (str != null) {
            AttributedCharacterIterator.Attribute[] fatr = new AttributedCharacterIterator.Attribute[]{TextAttribute.FONT};
            AttributedCharacterIterator acitr = str.getIterator(fatr);
            Font ft = null;
            ArrayList<Integer> al = new ArrayList<Integer>();
            char c = acitr.first();
            while (c != '\uffff') {
                if (ft == null) {
                    ft = (Font)acitr.getAttribute(TextAttribute.FONT);
                }
                if (ft != null && !ft.canDisplay(c)) {
                    al.add(acitr.getIndex());
                }
                c = acitr.next();
            }
            if (al.size() > 0 && ft != null) {
                Font nft = FontUtil.createSimSunFont(ft);
                Iterator itr = al.iterator();
                while (itr.hasNext()) {
                    int i = (Integer)itr.next();
                    str.addAttribute(TextAttribute.FONT, nft, i, i + 1);
                }
            }
        }
        return str;
    }

    public static Font createSimSunFont(Font oriFont) {
        Font defaultFont = KDFont.loadDefaultFont();
        return defaultFont.deriveFont(oriFont.getStyle(), oriFont.getSize());
    }

    public static double calcAttributeStringWith(AttributedString as, Font font, FontRenderContext frc) {
        AttributedCharacterIterator aci = as.getIterator();
        double advance = 0.0;
        int currentIndex = 0;
        aci.setIndex(currentIndex);
        int runLimit = aci.getRunLimit(TextAttribute.FONT);
        while (currentIndex != runLimit) {
            Object attribute = aci.getAttribute(TextAttribute.FONT);
            if (attribute != null) {
                Font attrFont = (Font)attribute;
                advance += attrFont.getStringBounds(aci, currentIndex, runLimit, frc).getWidth();
            } else {
                return (float)font.getStringBounds(aci, aci.getBeginIndex(), aci.getEndIndex(), frc).getWidth();
            }
            currentIndex = runLimit;
            aci.setIndex(currentIndex);
            runLimit = aci.getRunLimit(TextAttribute.FONT);
        }
        return advance;
    }

    public static Font validateFont(String source, Font font) {
        if (StringUtil.isEmptyString(source)) {
            return font;
        }
        boolean change = false;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c > '\u007f' && c < '\u0100' || font.canDisplay(c)) continue;
            change = true;
            break;
        }
        if (change) {
            HashMap<TextAttribute, String> map = new HashMap<TextAttribute, String>();
            map.put(TextAttribute.FAMILY, "source han serif cn");
            return font.deriveFont(map);
        }
        return font;
    }
}

