/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class StreamUtil {
    public static final Log log = LogFactory.getLog(StreamUtil.class);

    public static int copy(InputStream in, OutputStream out, int blockSize) throws IOException {
        int size = 0;
        byte[] block = new byte[blockSize];
        while (true) {
            int i;
            if ((i = in.read(block, 0, blockSize)) > 0) {
                out.write(block, 0, i);
                size += i;
                continue;
            }
            if (i == -1) break;
        }
        return size;
    }

    public static byte[] readInputStream(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[]{};
        byte[] perReadBuffer = new byte[32768];
        while ((read = in.read(perReadBuffer)) != -1) {
            byte[] temp = new byte[buffer.length + read];
            System.arraycopy(buffer, 0, temp, 0, buffer.length);
            System.arraycopy(perReadBuffer, 0, temp, buffer.length, read);
            buffer = temp;
        }
        return buffer;
    }

    public static final void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
    }

    public static final void closeStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
    }

    public static final void closeStream(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
    }
}

