/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.variant;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ctrl.common.variant.ExprErr;

public class SyntaxErrorException
extends Exception
implements Comparable {
    static final long serialVersionUID = 1347299259451100706L;
    public static final SyntaxErrorException BAD_QUERY = new SyntaxErrorException(128L, "#BAD QUERY");
    public static final SyntaxErrorException CALC_LAST = new SyntaxErrorException(0x200000L, "Calc Last");
    private long _errCode;
    private Object _extErrData;

    public SyntaxErrorException(long errCode) {
        this._errCode = errCode;
    }

    public SyntaxErrorException(long errCode, Object extErrData) {
        super(extErrData == null ? "" : extErrData.toString());
        this._errCode = errCode;
        this._extErrData = extErrData;
    }

    public long getErrorCode() {
        return this._errCode;
    }

    public Object getExtData() {
        return this._extErrData;
    }

    public void setExtData(Object errData) {
        this._extErrData = errData;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(ExprErr.getString(this._errCode));
        String info = this._extErrData != null ? this._extErrData.toString() : super.getMessage();
        if (!StringUtils.isEmpty((CharSequence)info)) {
            sb.append(" :");
            sb.append(info);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public boolean equals(Object obj) {
        SyntaxErrorException e;
        if (obj instanceof SyntaxErrorException && this._errCode == (e = (SyntaxErrorException)obj).getErrorCode()) {
            Object extData = e.getExtData();
            if (this._extErrData == null) {
                return extData == null;
            }
            return this._extErrData.equals(e.getExtData());
        }
        return false;
    }

    public int hashCode() {
        return (int)this._errCode & this._extErrData.hashCode();
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int cmp = -1;
        if (obj instanceof SyntaxErrorException) {
            SyntaxErrorException in = (SyntaxErrorException)obj;
            int n = this._errCode == in._errCode ? 0 : (cmp = this._errCode > in._errCode ? 1 : -1);
            if (cmp == 0) {
                cmp = this._extErrData == null ? (in._extErrData == null ? 0 : -1) : ((Comparable)this._extErrData).compareTo(in._extErrData);
            }
        }
        return cmp;
    }
}

