/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.variant;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.print.core.ctrl.common.variant.SyntaxErrorException;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.swing.util.CtrlFormatUtilities;
import org.apache.commons.lang.StringUtils;

public final class Util {
    public static final int MAX_PRECISION = 15;
    public static final int MAX_DATE_PRECISION = 7;
    public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final BigInteger TEN = BigInteger.valueOf(10L);
    public static final BigDecimal MINI_SECS_OF_DAY = BigDecimal.valueOf(86400000L);
    static final int FALSE = 0;
    static final int TRUE = 1;
    private static final Locale[] locales = new Locale[]{Locale.getDefault(), Locale.US, Locale.UK, Locale.CHINA, Locale.TAIWAN, Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.CHINESE, Locale.PRC};
    private static final int[] styles = new int[]{3, 2, 1, 0};
    private static final int QUICKPARSE = 0;
    private static final int FULLAFTERQUICK = 2;
    private static final int LOCALESNUMINQUICKPARSE = 4;
    private static final String[] weekFields = new String[]{"EEE", "EEEE"};
    private static final String[] yearFields = new String[]{"yy", "yyyy", "yyyy"};
    private static final String[] monthFields = new String[]{"MM", "MMM", "MMMM"};
    private static final String timeInAmpmFields = "K:m:s";
    private static final String timeInDayFields = "H:m:s";
    private static final String ampmFields = "aa";
    private static final String dayFields = "dd";
    private static final String defaultPattern = "EEE yy MM dd HH:mm:ss";
    private static final int[][] mix = new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 2, 0}, {2, 1, 0}, {1, 0, 2}, {2, 0, 1}};
    private static final String[] weekPatterns = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
    private static final String[] datePatterns = new String[]{"", "", "", ""};
    private static final String[] timeFields = new String[]{"K:m:s aa", "H:m:s", "aaK:m:s"};
    private static int flag = 0;
    private static Method method;
    private static final ConcurrentHashSet<String> sdfSet;

    public static Calendar getBaseDate() {
        Calendar baseDate = Calendar.getInstance();
        baseDate.set(14, 0);
        baseDate.set(1900, 0, 0, 0, 0, 0);
        return baseDate;
    }

    static Calendar addCalendar(BigDecimal bd) {
        return Util.addCalendar(Util.getBaseDate(), bd);
    }

    static long getMillis2BaseDate(double arg) {
        Calendar cal = (Calendar)Util.getBaseDate().clone();
        cal.setTimeZone(GMT_TIME_ZONE);
        int dates = (int)arg;
        double dHours = (arg - (double)dates) * 24.0;
        int hours = (int)dHours;
        double dMins = (dHours - (double)hours) * 60.0;
        int mins = (int)dMins;
        double dSecs = (dMins - (double)mins) * 60.0;
        int secs = (int)dSecs;
        double dMilis = (dSecs - (double)secs) * 1000.0;
        int milis = (int)dMilis;
        cal.add(5, dates);
        cal.add(11, hours);
        cal.add(12, mins);
        cal.add(13, secs);
        cal.add(14, milis);
        cal.setTimeZone(TimeZone.getDefault());
        return cal.getTimeInMillis();
    }

    static long getMillis2BaseDate(BigDecimal bd) {
        Calendar cal = (Calendar)Util.getBaseDate().clone();
        cal.setTimeZone(GMT_TIME_ZONE);
        int dates = bd.toBigInteger().intValue();
        BigDecimal dHours = bd.subtract(BigDecimal.valueOf(dates)).multiply(BigDecimal.valueOf(24L));
        int hours = dHours.toBigInteger().intValue();
        BigDecimal dMins = dHours.subtract(BigDecimal.valueOf(hours)).multiply(BigDecimal.valueOf(60L));
        int mins = dMins.toBigInteger().intValue();
        BigDecimal dSecs = dMins.subtract(BigDecimal.valueOf(mins)).multiply(BigDecimal.valueOf(60L));
        int secs = dSecs.toBigInteger().intValue();
        BigDecimal dMilis = dSecs.subtract(BigDecimal.valueOf(secs)).multiply(BigDecimal.valueOf(1000L));
        int milis = dMilis.toBigInteger().intValue();
        cal.add(5, dates);
        cal.add(11, hours);
        cal.add(12, mins);
        cal.add(13, secs);
        cal.add(14, milis);
        cal.setTimeZone(TimeZone.getDefault());
        return cal.getTimeInMillis();
    }

    static Calendar addCalendar(Calendar srcCal, BigDecimal bd) {
        Calendar cal = (Calendar)srcCal.clone();
        cal.setTimeZone(GMT_TIME_ZONE);
        double num = bd.doubleValue();
        int dates = (int)num;
        double dHours = (num - (double)dates) * 24.0;
        int hours = (int)dHours;
        double dMins = (dHours - (double)hours) * 60.0;
        int mins = (int)dMins;
        double dSecs = (dMins - (double)mins) * 60.0;
        int secs = (int)dSecs;
        double dMilis = (dSecs - (double)secs) * 1000.0;
        int milis = (int)dMilis;
        cal.add(5, dates);
        cal.add(11, hours);
        cal.add(12, mins);
        cal.add(13, secs);
        cal.add(14, milis);
        cal.setTimeZone(TimeZone.getDefault());
        return cal;
    }

    public static long getMillis(Calendar cal) {
        return cal.getTimeInMillis() - Util.getBaseDate().getTimeInMillis();
    }

    public static BigDecimal calendarToBigDecimal(Calendar cal) {
        long time = cal.getTimeInMillis() - Util.getBaseDate().getTimeInMillis();
        BigDecimal bd = BigDecimal.valueOf(time).divide(MINI_SECS_OF_DAY, 7, 4);
        return bd;
    }

    public static BigDecimal dateToBigDecimal(Date date) {
        long time = date.getTime() - Util.getBaseDate().getTimeInMillis();
        return BigDecimal.valueOf(time).divide(MINI_SECS_OF_DAY, 7, 4);
    }

    static int booleanToInt(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    static char booleanToChar(boolean val) {
        if (val) {
            return 'T';
        }
        return 'F';
    }

    static String booleanToString(boolean val) {
        if (val) {
            return "true";
        }
        return "false";
    }

    static String booleanToChinese(boolean val) {
        if (val) {
            return ResManager.loadKDString((String)"\u662f", (String)"Util_0", (String)"bos-print-core", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5426", (String)"Util_1", (String)"bos-print-core", (Object[])new Object[0]);
    }

    static Number stringToNumber(String str) throws SyntaxErrorException {
        BigDecimal bd;
        BigDecimal ret = null;
        try {
            if (StringUtils.isEmpty((String)str)) {
                ret = new BigDecimal(0);
            } else {
                try {
                    String integerPart;
                    DecimalFormatSymbols sym = CtrlFormatUtilities.getDecimalFormatSymbols();
                    int dotIndex = -1;
                    String decimalString = str;
                    dotIndex = decimalString.indexOf(String.valueOf(sym.getDecimalSeparator()));
                    String decimalPart = null;
                    if (dotIndex > 0) {
                        integerPart = decimalString.substring(0, dotIndex);
                        decimalPart = decimalString.substring(dotIndex + 1);
                    } else {
                        integerPart = decimalString;
                    }
                    String dot = String.valueOf(sym.getGroupingSeparator());
                    if (dot.equals(".")) {
                        dot = "\\" + dot;
                    }
                    integerPart = integerPart.replaceAll(dot, ",");
                    ret = new BigDecimal(integerPart + (decimalPart == null ? "" : "." + decimalPart));
                }
                catch (NumberFormatException pe) {
                    ret = new BigDecimal(str);
                }
            }
        }
        catch (NumberFormatException e) {
            DecimalFormatSymbols symbols = CtrlFormatUtilities.getDecimalFormatSymbols();
            char decimalSeparator = symbols.getDecimalSeparator();
            char groupingSeparator = symbols.getGroupingSeparator();
            boolean percent = false;
            int length = str.length();
            if (length > 1 && str.charAt(length - 1) == '%') {
                percent = true;
                str = str.substring(0, str.length() - 1);
            }
            int dotIndex = str.indexOf(decimalSeparator);
            StringBuilder sb = new StringBuilder(str.length());
            if (dotIndex >= 0) {
                for (int i = str.length() - 1; i > dotIndex; --i) {
                    sb.append(str.charAt(i));
                }
                sb.append(".");
            }
            if (dotIndex < 0) {
                dotIndex = str.length();
            }
            int kioIndex = dotIndex - 4;
            for (int i = dotIndex - 1; i >= 0; --i) {
                char c = str.charAt(i);
                if (i == kioIndex) {
                    if (c == groupingSeparator) {
                        kioIndex -= 4;
                        continue;
                    }
                    kioIndex -= 3;
                    sb.append(c);
                    continue;
                }
                sb.append(c);
            }
            String temp = sb.reverse().toString();
            try {
                BigDecimal bd2 = new BigDecimal(temp);
                if (percent) {
                    bd2 = bd2.divide(BigDecimal.valueOf(100.0), 16, 4);
                }
                ret = bd2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (ret != null && (bd = ret).scale() != 0 && str.indexOf(69) == 0 && str.indexOf(101) == 0) {
            ret = bd.setScale(0);
        }
        return ret;
    }

    public static boolean stringToBoolean(String val) throws SyntaxErrorException {
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        return false;
    }

    private static Date stringToDate(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getDateInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = Util.parse(df, src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getTimeInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = Util.parse(df, src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToDateTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                for (int k = 0; k < styles.length; ++k) {
                    df = DateFormat.getDateTimeInstance(styles[j], styles[k], locales[i]);
                    df.setLenient(false);
                    try {
                        ret = Util.parse(df, src);
                        break block2;
                    }
                    catch (Exception e) {
                        ret = null;
                        continue;
                    }
                }
            }
        }
        return ret;
    }

    private static Date parse(DateFormat df, String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Date result = df.parse(source, pos);
        int index = pos.getIndex();
        if (index == 0) {
            throw new ParseException("Unparseable date: \"" + source + "\"", pos.getErrorIndex());
        }
        String substring = source.substring(index);
        if (StringUtils.isNotBlank((String)substring)) {
            return null;
        }
        return result;
    }

    private static String[] getDateWeekPatterns(int dateStyle, int weekStyle) {
        String[] dates = new String[]{monthFields[dateStyle] + " " + dayFields, "dd " + monthFields[dateStyle]};
        for (int idates = 0; idates < 2; ++idates) {
            String[] fields = new String[]{weekFields[weekStyle], yearFields[dateStyle], dates[idates]};
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int n = idates * 6 + i;
                    weekPatterns[n] = weekPatterns[n] + fields[mix[i][j]];
                    if (j >= 2) continue;
                    int n2 = idates * 6 + i;
                    weekPatterns[n2] = weekPatterns[n2] + " ";
                }
            }
        }
        return weekPatterns;
    }

    private static String[] getDatePatterns(int dateStyle) {
        String[] dates = new String[]{monthFields[dateStyle] + " " + dayFields, "dd " + monthFields[dateStyle]};
        for (int idates = 0; idates < 2; ++idates) {
            String[] fields = new String[]{null, yearFields[dateStyle], dates[idates]};
            for (int i = 0; i < 2; ++i) {
                for (int j = 1; j < 3; ++j) {
                    int n = idates * 2 + i;
                    datePatterns[n] = datePatterns[n] + fields[mix[i][j]];
                    if (j >= 2) continue;
                    int n2 = idates * 2 + i;
                    datePatterns[n2] = datePatterns[n2] + " ";
                }
            }
        }
        return datePatterns;
    }

    static Date stringToDateByPattern(String src) {
        int dateStyle;
        String str = src.replace('.', ' ');
        str = str.replace('-', ' ');
        str = str.replace('/', ' ');
        str = str.replace(',', ' ');
        while (-1 != str.indexOf("  ")) {
            str = str.replaceAll("  ", " ");
        }
        boolean isIncludeTime = false;
        if (-1 != str.indexOf(58, 10)) {
            isIncludeTime = true;
        }
        Date ret = null;
        String[][] ps = new String[9][];
        for (dateStyle = 0; dateStyle < 3; ++dateStyle) {
            ps[dateStyle] = Util.getDatePatterns(dateStyle);
        }
        for (dateStyle = 0; dateStyle < 3; ++dateStyle) {
            for (int weeekStyle = 0; weeekStyle < 2; ++weeekStyle) {
                ps[dateStyle * 2 + weeekStyle + 3] = Util.getDateWeekPatterns(dateStyle, weeekStyle);
            }
        }
        ParsePosition pos = new ParsePosition(0);
        if (isIncludeTime) {
            int i;
            String[][] psTime = new String[27][];
            for (i = 0; i < 3; ++i) {
                int k;
                for (k = 0; k < 3; ++k) {
                    psTime[i * 9 + k] = new String[4];
                }
                for (k = 3; k < 9; ++k) {
                    psTime[i * 9 + k] = new String[12];
                }
            }
            for (int k = 0; k < timeFields.length; ++k) {
                for (int i2 = 0; i2 < ps.length; ++i2) {
                    for (int j = 0; j < ps[i2].length; ++j) {
                        psTime[9 * k + i2][j] = ps[i2][j] + " " + timeFields[k];
                    }
                }
            }
            for (i = 0; i < locales.length && (ret = Util.stringToDateByPattern(str, psTime, locales[i], pos)) == null; ++i) {
            }
        } else {
            for (int i = 0; i < locales.length && (ret = Util.stringToDateByPattern(str, ps, locales[i], pos)) == null; ++i) {
            }
        }
        return ret;
    }

    private static Date stringToDateByPattern(String src, String[][] patterns, Locale loc, ParsePosition pos) {
        Date ret = null;
        SimpleDateFormat sdf = new SimpleDateFormat(defaultPattern, loc);
        sdf.setLenient(false);
        ret = sdf.parse(src, pos);
        if (ret != null) {
            return ret;
        }
        int i = 0;
        int j = 0;
        block0: for (i = 0; i < patterns.length; ++i) {
            for (j = 0; j < patterns[i].length; ++j) {
                sdf.applyPattern(patterns[i][j]);
                ret = sdf.parse(src, pos);
                if (ret != null) break block0;
            }
        }
        return ret;
    }

    static Date stringToDateEx(String src) {
        DateFormatSymbols dfs = null;
        String[] weekdays = null;
        String str = src.toUpperCase();
        String token = null;
        block0: for (int i = 0; i < locales.length; ++i) {
            int k;
            dfs = new DateFormatSymbols(locales[i]);
            weekdays = dfs.getShortWeekdays();
            for (k = 1; k < weekdays.length; ++k) {
                token = weekdays[k].toUpperCase();
                if (-1 == str.indexOf(token)) continue;
                str = StringUtils.replaceOnce((String)str, (String)token, (String)"");
                str = str.trim();
                break block0;
            }
            weekdays = dfs.getWeekdays();
            for (k = 1; k < weekdays.length; ++k) {
                token = weekdays[k].toUpperCase();
                if (-1 == str.indexOf(token)) continue;
                str = StringUtils.replaceOnce((String)str, (String)token, (String)"");
                str = str.trim();
                break block0;
            }
        }
        Date ret = null;
        if (src.length() > 10) {
            ret = Util.stringToDateTime(src, 0);
            if (ret == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDate(src, 0)) == null) {
                ret = Util.stringToTime(src, 0);
            }
            if (ret == null && (ret = Util.stringToDate(src, 2)) == null) {
                ret = Util.stringToTime(src, 2);
            }
        } else {
            ret = Util.stringToDate(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToTime(src, 0)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
        }
        return ret;
    }

    static Date stringToDate(String src) {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null && javaVersion.startsWith("17")) {
            return Util.stringToDateJDK17(src);
        }
        return Util.stringToDateJDK8(src);
    }

    private static Date stringToDateJDK17(String src) {
        Date ret = null;
        if (src.length() > 10) {
            ret = Util.stringToDateInner(src, 0);
            if (ret == null) {
                ret = Util.stringToDateInner(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateInner(src, 0)) == null) {
                ret = Util.stringToDateInner(src, 0);
            }
            if (ret == null && (ret = Util.stringToDateInner(src, 2)) == null) {
                ret = Util.stringToDateInner(src, 2);
            }
        } else {
            ret = Util.stringToDateInner(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateInner(src, 0)) == null) {
                ret = Util.stringToDateInner(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateInner(src, 0)) == null) {
                ret = Util.stringToDateInner(src, 2);
            }
        }
        return ret;
    }

    private static Date stringToDateJDK8(String src) {
        Date ret = null;
        if (src.length() > 10) {
            ret = Util.stringToDateTime(src, 0);
            if (ret == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDate(src, 0)) == null) {
                ret = Util.stringToTime(src, 0);
            }
            if (ret == null && (ret = Util.stringToDate(src, 2)) == null) {
                ret = Util.stringToTime(src, 2);
            }
        } else {
            ret = Util.stringToDate(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToTime(src, 0)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
        }
        return ret;
    }

    static void add(byte left, byte right, Variant result) {
        int ret = left + right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    static void add(short left, short right, Variant result) {
        int ret = left + right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    static void add(int left, int right, Variant result) {
        long ret = (long)left + (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    static void add(long left, long right, Variant result) {
        long ret = left + right;
        if ((left ^ right) >= 0L) {
            if (left > 0L && ret < 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = 0;
                result.setObject(new BigInteger(bta), 9);
            } else if (left < 0L && ret >= 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = -1;
                result.setObject(new BigInteger(bta), 9);
            } else {
                result.setLong(ret);
            }
        } else {
            result.setLong(ret);
        }
    }

    static void add(float left, float right, Variant result) {
        float ret = left + right;
        if (ret == Float.POSITIVE_INFINITY || ret == Float.NEGATIVE_INFINITY) {
            Util.add((double)left, (double)right, result);
        } else {
            result.setFloat(ret);
        }
    }

    static void add(double left, double right, Variant result) {
        double ret = left + right;
        result.setDouble(ret);
    }

    static void subtract(byte left, byte right, Variant result) {
        int ret = left - right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    static void subtract(short left, short right, Variant result) {
        int ret = left - right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    static void subtract(int left, int right, Variant result) {
        long ret = (long)left - (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    static void subtract(long left, long right, Variant result) {
        right = -right;
        long ret = left + right;
        if ((left ^ right) >= 0L) {
            if (left > 0L && ret < 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = 0;
                result.setObject(new BigInteger(bta), 9);
            } else if (left < 0L && ret >= 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = -1;
                result.setObject(new BigInteger(bta), 9);
            } else {
                result.setLong(ret);
            }
        } else {
            result.setLong(ret);
        }
    }

    static void subtract(float left, float right, Variant result) {
        float ret = left - right;
        if (ret == Float.POSITIVE_INFINITY || ret == Float.NEGATIVE_INFINITY) {
            Util.subtract((double)left, (double)right, result);
        } else {
            result.setFloat(ret);
        }
    }

    static void subtract(double left, double right, Variant result) {
        double ret = left - right;
        result.setDouble(ret);
    }

    static void multiply(byte left, byte right, Variant result) {
        int ret = left * right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    static void multiply(short left, short right, Variant result) {
        int ret = left * right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    static void multiply(int left, int right, Variant result) {
        long ret = (long)left * (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    static void multiply(long left, long right, Variant result) {
        if (left == 1L) {
            result.setLong(right);
        } else if (right == 1L) {
            result.setLong(left);
        } else {
            double dfValue = (double)left * (double)right;
            long lValue = left * right;
            if (Math.abs(dfValue) > (double)Math.abs(lValue)) {
                result.setDouble(dfValue);
            } else {
                result.setLong(lValue);
            }
        }
    }

    static void multiply(float left, float right, Variant result) {
        float ret = left * right;
        result.setFloat(ret);
    }

    static void multiply(double left, double right, Variant result) {
        double ret = left * right;
        result.setDouble(ret);
    }

    static void divide(byte left, byte right, Variant result) {
        int ret = left / right;
        result.setByte((byte)ret);
    }

    static void divide(short left, short right, Variant result) {
        int ret = left / right;
        result.setShort((short)ret);
    }

    static void divide(int left, int right, Variant result) {
        int ret = left / right;
        result.setInt(ret);
    }

    static void divide(long left, long right, Variant result) {
        long ret = left / right;
        result.setLong(ret);
    }

    static void divide(float left, float right, Variant result) {
        float ret = left / right;
        result.setFloat(ret);
    }

    static void divide(double left, double right, Variant result) {
        double ret = left / right;
        result.setDouble(ret);
    }

    static void mod(byte left, byte right, Variant result) {
        result.setByte((byte)(left % right));
    }

    static void mod(short left, short right, Variant result) {
        result.setShort((short)(left % right));
    }

    static void mod(int left, int right, Variant result) {
        result.setInt(left % right);
    }

    static void mod(long left, long right, Variant result) {
        result.setLong(left % right);
    }

    static void mod(float left, float right, Variant result) {
        result.setFloat(left % right);
    }

    static void mod(double left, double right, Variant result) {
        result.setDouble(left % right);
    }

    static void and(byte left, byte right, Variant result) {
        result.setByte((byte)(left & right));
    }

    static void and(short left, short right, Variant result) {
        result.setShort((short)(left & right));
    }

    static void and(int left, int right, Variant result) {
        result.setInt(left & right);
    }

    static void and(long left, long right, Variant result) {
        result.setLong(left & right);
    }

    static void and(float left, float right, Variant result) {
        result.setLong((long)left & (long)right);
    }

    static void and(double left, double right, Variant result) {
        result.setLong((long)left & (long)right);
    }

    static void or(byte left, byte right, Variant result) {
        result.setByte((byte)(left | right));
    }

    static void or(short left, short right, Variant result) {
        result.setShort((short)(left | right));
    }

    static void or(int left, int right, Variant result) {
        result.setInt(left | right);
    }

    static void or(long left, long right, Variant result) {
        result.setLong(left | right);
    }

    static void or(float left, float right, Variant result) {
        result.setLong((long)left | (long)right);
    }

    static void or(double left, double right, Variant result) {
        result.setLong((long)left | (long)right);
    }

    static void xor(byte left, byte right, Variant result) {
        result.setByte((byte)(left ^ right));
    }

    static void xor(short left, short right, Variant result) {
        result.setShort((short)(left ^ right));
    }

    static void xor(int left, int right, Variant result) {
        result.setInt(left ^ right);
    }

    static void xor(long left, long right, Variant result) {
        result.setLong(left ^ right);
    }

    static void xor(float left, float right, Variant result) {
        result.setLong((long)left ^ (long)right);
    }

    static void xor(double left, double right, Variant result) {
        result.setLong((long)left ^ (long)right);
    }

    public static BigDecimal reduceScale(BigDecimal bd) {
        BigInteger intval = bd.unscaledValue();
        int ns = 0;
        int scale = bd.scale();
        if (intval.signum() != 0) {
            int i;
            String str = intval.toString();
            int len = str.length();
            int end = len - scale;
            for (i = len - 1; i >= end && str.charAt(i) == '0'; --i) {
            }
            ns = scale - (len - 1 - i);
        }
        if (ns != scale) {
            bd = bd.setScale(ns);
        }
        return bd;
    }

    public static void reduceScale(Variant var) {
        if (var.getVt() == 10) {
            BigDecimal bd = (BigDecimal)var.getValue();
            BigInteger intval = bd.unscaledValue();
            int ns = 0;
            int scale = bd.scale();
            if (intval.signum() != 0) {
                int i;
                String str = intval.toString();
                int len = str.length();
                int end = len - scale;
                for (i = len - 1; i >= end && str.charAt(i) == '0'; --i) {
                }
                ns = scale - (len - 1 - i);
            }
            if (ns != scale) {
                bd = bd.setScale(ns);
                var.setObject(bd, 10);
            }
        }
    }

    public static String bigDecimalToPlainString(BigDecimal number) {
        if (flag == 0) {
            Class<?> cls = number.getClass();
            try {
                method = cls.getMethod("toPlainString", new Class[0]);
            }
            catch (SecurityException e) {
                method = null;
            }
            catch (NoSuchMethodException e) {
                method = null;
            }
            ++flag;
        }
        if (method != null) {
            try {
                return (String)method.invoke((Object)number, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                return number.toString();
            }
            catch (IllegalAccessException e) {
                return number.toString();
            }
            catch (InvocationTargetException e) {
                return number.toString();
            }
        }
        return number.toString();
    }

    private static Date stringToDateInner(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (String pattern : sdfSet) {
                df = Util.getInstance(pattern, locales[i]);
                df.setLenient(false);
                try {
                    ret = df.parse(src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                }
            }
        }
        return ret;
    }

    private static DateFormat getInstance(String pattern, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat("", locale);
        try {
            sdf.applyPattern(pattern);
        }
        catch (Exception mre) {
            sdf.applyPattern("M/d/yy h:mm a");
        }
        return sdf;
    }

    static {
        sdfSet = new ConcurrentHashSet(30);
        sdfSet.add((Object)"yy-M-d");
        sdfSet.add((Object)"yyyy-M-d");
        sdfSet.add((Object)"yyyy/M/d");
        sdfSet.add((Object)"yyyy'\u5e74'M'\u6708'd'\u65e5'");
        sdfSet.add((Object)"yyyy'\u5e74'M'\u6708'd'\u65e5' EEEE");
        sdfSet.add((Object)"M/d/yy");
        sdfSet.add((Object)"MMM d, yyyy");
        sdfSet.add((Object)"MMMM d, yyyy");
        sdfSet.add((Object)"EEEE, MMMM d, yyyy");
        sdfSet.add((Object)"dd/MM/yy");
        sdfSet.add((Object)"dd-MMM-yyyy");
        sdfSet.add((Object)"dd MMMM yyyy");
        sdfSet.add((Object)"EEEE, d MMMM yyyy");
        sdfSet.add((Object)"ah:mm");
        sdfSet.add((Object)"H:mm:ss");
        sdfSet.add((Object)"ahh'\u65f6'mm'\u5206'ss'\u79d2'");
        sdfSet.add((Object)"ahh'\u65f6'mm'\u5206'ss'\u79d2' z");
        sdfSet.add((Object)"h:mm a");
        sdfSet.add((Object)"h:mm:ss a");
        sdfSet.add((Object)"h:mm:ss a z");
        sdfSet.add((Object)"HH:mm");
        sdfSet.add((Object)"HH:mm:ss");
        sdfSet.add((Object)"HH:mm:ss z");
        sdfSet.add((Object)"HH:mm:ss 'o''clock' z");
        sdfSet.add((Object)"a h:mm");
        sdfSet.add((Object)"a hh:mm:ss");
        sdfSet.add((Object)"ahh'\u6642'mm'\u5206'ss'\u79d2'");
    }
}

