/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.variant;

import java.math.BigDecimal;
import kd.bos.print.core.ctrl.common.variant.ExprErr;
import kd.bos.print.core.ctrl.common.variant.SyntaxErrorException;
import kd.bos.print.core.ctrl.common.variant.VarBase;
import kd.bos.print.core.ctrl.common.variant.Variant;

class VarBigDecimal
extends VarBase {
    VarBigDecimal() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 11: {
                    Variant vleft = new Variant();
                    Variant vright = new Variant();
                    if (left.isNumeric(vleft) && right.isNumeric(vright)) {
                        result.setVariant(vleft.add(vright));
                        break;
                    }
                    result.setObject(left.toString().concat((String)right.getValue()), 11);
                    break;
                }
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, this.getMsgDescription());
                    break;
                }
                default: {
                    result.setObject(((BigDecimal)left.getValue()).add(right.toBigDecimal()), 10);
                }
            }
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, this.getMsgDescription());
                    return;
                }
            }
            BigDecimal r = right.toBigDecimal();
            if (r.signum() == 0) {
                ExprErr.goError(2L, null);
            }
            BigDecimal dividend = (BigDecimal)left.getValue();
            BigDecimal divisor = right.toBigDecimal();
            result.setObject(dividend.divide(divisor, 16, 4), 10);
            return;
        }
    }
}

