/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.variant;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.print.core.ctrl.common.variant.ExprErr;
import kd.bos.print.core.ctrl.common.variant.SyntaxErrorException;
import kd.bos.print.core.ctrl.common.variant.Util;
import kd.bos.print.core.ctrl.common.variant.VarBase;
import kd.bos.print.core.ctrl.common.variant.Variant;

class VarBigInteger
extends VarBase {
    VarBigInteger() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 5: {
                    Util.add(((BigInteger)left.getValue()).floatValue(), ((Float)right.getValue()).floatValue(), result);
                    return;
                }
                case 6: {
                    Util.add(((BigInteger)left.getValue()).doubleValue(), (Double)right.getValue(), result);
                    return;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).add((BigInteger)left.getValue()), 9);
                    return;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).add(new BigDecimal((BigInteger)left.getValue())), 10);
                    return;
                }
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, this.getMsgDescription());
                    return;
                }
            }
            result.setObject(((BigInteger)left.getValue()).add(right.toBigInteger()), 9);
            return;
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 5: {
                    Util.divide(((BigInteger)left.getValue()).floatValue(), ((Float)right.getValue()).floatValue(), result);
                    return;
                }
                case 6: {
                    Util.divide(((BigInteger)left.getValue()).doubleValue(), (Double)right.getValue(), result);
                    return;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).divide((BigInteger)left.getValue()), 9);
                    return;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).divide(new BigDecimal((BigInteger)left.getValue()), 4), 10);
                    return;
                }
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, this.getMsgDescription());
                    return;
                }
            }
            result.setObject(((BigInteger)left.getValue()).divide(right.toBigInteger()), 9);
            return;
        }
    }
}

