/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.variant;

import kd.bos.print.core.ctrl.common.variant.ExprErr;
import kd.bos.print.core.ctrl.common.variant.SyntaxErrorException;
import kd.bos.print.core.ctrl.common.variant.Util;
import kd.bos.print.core.ctrl.common.variant.VarBase;
import kd.bos.print.core.ctrl.common.variant.Variant;

class VarBoolean
extends VarBase {
    VarBoolean() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            if (right.getVt() == 8) {
                boolean rightval = (Boolean)right.getValue();
                result.setInt(leftval + Util.booleanToInt(rightval));
            } else {
                Variant temp = new Variant();
                temp.setInt(leftval);
                temp.add(right, result);
            }
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        int leftval = Util.booleanToInt((Boolean)left.getValue());
        if (right.getVt() < 512) {
            if (right.getVt() == 8) {
                int rightval = Util.booleanToInt((Boolean)right.getValue());
                if (rightval != 0) {
                    result.setInt(leftval / rightval);
                } else {
                    ExprErr.goError(2L, null);
                }
            } else {
                Variant temp = new Variant();
                temp.setInt(leftval);
                temp.divide(right, result);
            }
        }
    }
}

