/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.variant;

import java.math.BigDecimal;
import java.util.Calendar;
import kd.bos.print.core.ctrl.common.variant.ExprErr;
import kd.bos.print.core.ctrl.common.variant.SyntaxErrorException;
import kd.bos.print.core.ctrl.common.variant.Util;
import kd.bos.print.core.ctrl.common.variant.VarBase;
import kd.bos.print.core.ctrl.common.variant.Variant;

class VarCalendar
extends VarBase {
    VarCalendar() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = (Calendar)left.getValue();
        result.setObject(Util.addCalendar(cal, right.toBigDecimal()));
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double rightval = right.doubleValue();
        if (rightval == 0.0) {
            ExprErr.goError(2L, null);
        }
        BigDecimal days = left.toBigDecimal().divide(right.toBigDecimal(), 7, 4);
        long leftval = Util.getMillis2BaseDate(days);
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }
}

