/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.common.variant;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class WeakHashSet
implements Map {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private WeakEntry[] table;
    private int sizeField;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();
    private AtomicInteger modCount = new AtomicInteger();
    volatile transient Set keySet = null;
    volatile transient Collection values = null;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    public WeakHashSet(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = new WeakEntry[capacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public WeakHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakHashSet() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new WeakEntry[16];
    }

    public WeakHashSet(Map t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(t);
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private void expungeStaleEntries() {
        Reference r;
        block0: while ((r = this.queue.poll()) != null) {
            WeakEntry prev;
            WeakEntry e = (WeakEntry)r;
            int h = e.hash;
            int i = WeakHashSet.indexFor(h, this.table.length);
            WeakEntry p = prev = this.table[i];
            while (p != null) {
                WeakEntry next = p.nextOne;
                if (p == e) {
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.nextOne = next;
                    }
                    e.nextOne = null;
                    --this.sizeField;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    private WeakEntry[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.sizeField == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.sizeField;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public Object get(Object key) {
        Object k = WeakHashSet.maskNull(key);
        int h = WeakHashSet.hash(k);
        WeakEntry[] tab = this.getTable();
        int index = WeakHashSet.indexFor(h, tab.length);
        WeakEntry e = tab[index];
        while (e != null) {
            Object kGet;
            if (e.hash == h && WeakHashSet.eq(k, kGet = e.get())) {
                return kGet;
            }
            e = e.nextOne;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    WeakEntry getEntry(Object key) {
        Object k = WeakHashSet.maskNull(key);
        int h = WeakHashSet.hash(k);
        WeakEntry[] tab = this.getTable();
        int index = WeakHashSet.indexFor(h, tab.length);
        WeakEntry e = tab[index];
        while (!(e == null || e.hash == h && WeakHashSet.eq(k, e.get()))) {
            e = e.nextOne;
        }
        return e;
    }

    public Object add(Object key) {
        return key;
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    void resize(int newCapacity) {
        WeakEntry[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        WeakEntry[] newTable = new WeakEntry[newCapacity];
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.sizeField >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(WeakEntry[] src, WeakEntry[] dest) {
        for (int j = 0; j < src.length; ++j) {
            WeakEntry e = src[j];
            src[j] = null;
            while (e != null) {
                WeakEntry next = e.nextOne;
                Object key = e.get();
                if (key == null) {
                    e.nextOne = null;
                    --this.sizeField;
                } else {
                    int i = WeakHashSet.indexFor(e.hash, dest.length);
                    e.nextOne = dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    public void putAll(Map m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        WeakEntry prev;
        Object k = WeakHashSet.maskNull(key);
        int h = WeakHashSet.hash(k);
        WeakEntry[] tab = this.getTable();
        int i = WeakHashSet.indexFor(h, tab.length);
        WeakEntry e = prev = tab[i];
        while (e != null) {
            Object kGet;
            WeakEntry next = e.nextOne;
            if (h == e.hash && WeakHashSet.eq(k, kGet = e.get())) {
                this.modCount.incrementAndGet();
                --this.sizeField;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.nextOne = next;
                }
                return kGet;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    WeakEntry removeMapping(Object o) {
        WeakEntry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        WeakEntry[] tab = this.getTable();
        Map.Entry entry = (Map.Entry)o;
        Object k = WeakHashSet.maskNull(entry.getKey());
        int h = WeakHashSet.hash(k);
        int i = WeakHashSet.indexFor(h, tab.length);
        WeakEntry e = prev = tab[i];
        while (e != null) {
            WeakEntry next = e.nextOne;
            if (h == e.hash && e.equals(entry)) {
                this.modCount.incrementAndGet();
                --this.sizeField;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.nextOne = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        this.modCount.incrementAndGet();
        WeakEntry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.sizeField = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    static class SimpleEntry
    implements Map.Entry {
        Object key;

        public SimpleEntry(Object key, Object value) {
            this.key = key;
        }

        public SimpleEntry(Map.Entry e) {
            this.key = e.getKey();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return null;
        }

        public Object setValue(Object value) {
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey());
        }

        @Override
        public int hashCode() {
            return this.key == null ? 0 : this.key.hashCode();
        }

        public String toString() {
            return this.key.toString();
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            WeakEntry candidate = WeakHashSet.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return WeakHashSet.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return WeakHashSet.this.size();
        }

        @Override
        public void clear() {
            WeakHashSet.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray(a);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return WeakHashSet.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakHashSet.this.containsValue(o);
        }

        @Override
        public void clear() {
            WeakHashSet.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return WeakHashSet.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakHashSet.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (WeakHashSet.this.containsKey(o)) {
                WeakHashSet.this.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakHashSet.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextEntry().getValue();
        }
    }

    private abstract class HashIterator
    implements Iterator {
        int index;
        WeakEntry entry = null;
        WeakEntry lastReturned = null;
        AtomicInteger expectedModCount = WeakHashSet.access$300(WeakHashSet.this);
        Object nextKey = null;
        Object currentKey = null;

        HashIterator() {
            this.index = WeakHashSet.this.size() != 0 ? WeakHashSet.this.table.length : 0;
        }

        @Override
        public boolean hasNext() {
            WeakEntry[] t = WeakHashSet.this.table;
            while (this.nextKey == null) {
                WeakEntry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.nextOne;
            }
            return true;
        }

        protected WeakEntry nextEntry() {
            if (WeakHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.nextOne;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakHashSet.this.remove(this.currentKey);
            this.expectedModCount = WeakHashSet.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    public static class WeakEntry
    extends WeakReference
    implements Map.Entry {
        private final int hash;
        private WeakEntry nextOne;

        WeakEntry(Object key, ReferenceQueue queue, int hash, WeakEntry next) {
            super(key, queue);
            this.hash = hash;
            this.nextOne = next;
        }

        public Object getKey() {
            return WeakHashSet.unmaskNull(this.get());
        }

        public Object getValue() {
            return null;
        }

        public Object setValue(Object newValue) {
            return newValue;
        }

        @Override
        public boolean equals(Object o) {
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2);
        }

        @Override
        public int hashCode() {
            Object k = this.getKey();
            return k == null ? 0 : k.hashCode();
        }

        public String toString() {
            return this.getKey().toString();
        }
    }
}

