/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.formatter;

import kd.bos.print.core.ctrl.kdf.formatter.FormatException;

public class FormatType {
    private static final String DEFAULT_PLACE = " ";
    private static final String DEFAULT_DATETIME_PATTERN = "yyyy-M-d";
    private static final int DEFAULT_WIDTH = 0;
    private static final int DEFAULT_SCALE = 2;
    private int width;
    private int scale;
    private Align align = Align.RIGHT;
    private SymbolDisplayModal symbolModal = SymbolDisplayModal.MINUS;
    private String currencySymbol;
    private String placeChar = " ";
    private Type type;
    private String pattern;

    public static FormatType paserFormatType(String source) throws FormatException {
        String sub;
        FormatType formatType = new FormatType();
        formatType.setPlaceCharacter(DEFAULT_PLACE);
        formatType.setScale(2);
        if (source.charAt(0) != '%' || source.charAt(1) == '%') {
            throw new FormatException();
        }
        int pos = 1;
        if (source.charAt(pos) == 'L' || source.charAt(pos) == 'l') {
            formatType.setAlign(Align.LEFT);
            ++pos;
        } else if (source.charAt(pos) == 'C' || source.charAt(pos) == 'c') {
            formatType.setAlign(Align.CENTER);
            ++pos;
        } else if (source.charAt(pos) == 'R' || source.charAt(pos) == 'r') {
            formatType.setAlign(Align.RIGHT);
            ++pos;
        }
        if (source.charAt(pos) == '+') {
            formatType.setDislaySymbol(SymbolDisplayModal.PLUS);
            ++pos;
        } else if (source.charAt(pos) == '_') {
            formatType.setDislaySymbol(SymbolDisplayModal.NONE);
            ++pos;
        } else if (source.charAt(pos) == '-') {
            formatType.setDislaySymbol(SymbolDisplayModal.MINUS);
            ++pos;
        }
        int leftPlacePos = -1;
        int rightPlacePos = -1;
        Position placePosition = new Position('[', ']');
        if (!placePosition.paser(source, pos)) {
            throw new FormatException();
        }
        leftPlacePos = placePosition.getLeftPos();
        rightPlacePos = placePosition.getRightPos();
        if (leftPlacePos > pos) {
            throw new FormatException();
        }
        if (leftPlacePos > 0) {
            String place = placePosition.getTransString(source);
            formatType.setPlaceCharacter(place);
        }
        placePosition = null;
        String pattern = null;
        int leftPatternPos = -1;
        int rightPatternPos = -1;
        Position patternPosition = new Position('{', '}');
        int start = rightPlacePos == -1 ? pos : rightPlacePos + 1;
        if (!patternPosition.paser(source, start)) {
            throw new FormatException();
        }
        leftPatternPos = patternPosition.getLeftPos();
        rightPatternPos = patternPosition.getRightPos();
        if (leftPatternPos > start) {
            throw new FormatException();
        }
        if (leftPatternPos > 0) {
            pattern = patternPosition.getSubString(source);
        }
        patternPosition = null;
        boolean scaleIsChanged = false;
        int width = 0;
        int scale = 2;
        if (rightPatternPos > 0) {
            start = ++rightPatternPos;
        }
        if ((sub = source.substring(start, source.length() - 1)).length() > 0) {
            try {
                int dotPos = sub.indexOf(46);
                if (dotPos > 0) {
                    width = Integer.parseInt(sub.substring(0, dotPos));
                    scale = Integer.parseInt(sub.substring(dotPos + 1));
                    scaleIsChanged = true;
                } else if (dotPos == 0) {
                    scale = Integer.parseInt(sub.substring(dotPos + 1));
                    scaleIsChanged = true;
                } else {
                    width = Integer.parseInt(sub);
                }
            }
            catch (NumberFormatException nfe) {
                throw new FormatException();
            }
        }
        formatType.setWidth(width);
        formatType.setScale(scale);
        char chrType = source.charAt(source.length() - 1);
        switch (chrType) {
            case 's': {
                formatType.setType(Type.GENERAL);
                if (scaleIsChanged) break;
                formatType.setScale(0);
                break;
            }
            case 'd': {
                formatType.setType(Type.NUMBER);
                if (formatType.getScale() > 0) {
                    if (!scaleIsChanged) {
                        formatType.setScale(0);
                    }
                    StringBuilder sb = new StringBuilder(formatType.getScale());
                    for (int idx = 0; idx < formatType.getScale(); ++idx) {
                        sb.append('0');
                    }
                    formatType.setPattern(sb.toString());
                    break;
                }
                formatType.setPattern("###");
                break;
            }
            case 'f': {
                formatType.setType(Type.NUMBER);
                if (formatType.getScale() > 0) {
                    StringBuilder sb = new StringBuilder(formatType.getScale()).append("##0.");
                    for (int idx = 0; idx < formatType.getScale(); ++idx) {
                        sb.append('0');
                    }
                    formatType.setPattern(sb.toString());
                    break;
                }
                formatType.setPattern("##0.##");
                break;
            }
            case 'n': {
                formatType.setType(Type.NUMBER);
                if (formatType.getScale() > 0) {
                    StringBuilder sb = new StringBuilder(formatType.getScale()).append("#,##0.");
                    for (int idx = 0; idx < formatType.getScale(); ++idx) {
                        sb.append('0');
                    }
                    formatType.setPattern(sb.toString());
                    break;
                }
                formatType.setPattern("#,##0.##");
                break;
            }
            case 'x': {
                formatType.setType(Type.HEX);
                break;
            }
            case 'X': {
                formatType.setType(Type.BIG_HEX);
                break;
            }
            case 'o': {
                formatType.setType(Type.OCTAL);
                break;
            }
            case 'b': {
                formatType.setType(Type.BINARY);
                break;
            }
            case 'e': {
                formatType.setType(Type.SCIENTIFIC);
                break;
            }
            case 'p': {
                formatType.setType(Type.RATE);
                formatType.setPattern(source);
                break;
            }
            case 'g': {
                formatType.setType(Type.CUSTOM);
                formatType.setPattern(source);
                break;
            }
            case 't': {
                formatType.setType(Type.DATETIME);
                if (pattern != null) break;
                formatType.setPattern(DEFAULT_DATETIME_PATTERN);
                break;
            }
            default: {
                formatType.setType(Type.CUSTOM);
                formatType.setPattern(source);
            }
        }
        if (pattern != null && pattern.length() > 0) {
            formatType.setPattern(pattern);
        }
        return formatType;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public Align getAlign() {
        return this.align;
    }

    public void setDislaySymbol(SymbolDisplayModal modal) {
        this.symbolModal = modal;
    }

    public SymbolDisplayModal getDisplaySymol() {
        return this.symbolModal;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String symbol) {
        this.currencySymbol = symbol;
    }

    public String getPlaceCharacter() {
        return this.placeChar;
    }

    public void setPlaceCharacter(String holder) {
        if (holder == null || holder.length() == 0) {
            holder = DEFAULT_PLACE;
        }
        this.placeChar = holder;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('%');
        sb.append(this.align.toString()).append(this.symbolModal.toString());
        char[] chrSrc = this.placeChar.toCharArray();
        sb.append('[');
        for (int i = 0; i < chrSrc.length; ++i) {
            sb.append('!').append(chrSrc[i]);
        }
        sb.append(']');
        sb.append('{').append(this.pattern).append('}').append(this.getWidth()).append('.').append(this.getScale()).append(this.type.toString());
        return sb.toString();
    }

    static class SymbolDisplayModal {
        private static final int INT_PLUS = 1;
        private static final int INT_NONE = 0;
        private static final int INT_MINUS = -1;
        private int modal;
        public static final SymbolDisplayModal PLUS = new SymbolDisplayModal(1);
        public static final SymbolDisplayModal NONE = new SymbolDisplayModal(0);
        public static final SymbolDisplayModal MINUS = new SymbolDisplayModal(-1);

        private SymbolDisplayModal(int modal) {
            this.modal = modal;
        }

        public String toString() {
            String result = null;
            switch (this.modal) {
                case 1: {
                    result = "+";
                    break;
                }
                case 0: {
                    result = "_";
                    break;
                }
                case -1: {
                    result = "-";
                    break;
                }
            }
            return result;
        }
    }

    static class Align {
        private static final int INT_LEFT = -1;
        private static final int INT_CENTER = 0;
        private static final int INT_RIGHT = 1;
        private int align;
        public static final Align LEFT = new Align(-1);
        public static final Align CENTER = new Align(0);
        public static final Align RIGHT = new Align(1);

        private Align(int align) {
            this.align = align;
        }

        public String toString() {
            String result = null;
            switch (this.align) {
                case -1: {
                    result = "l";
                    break;
                }
                case 0: {
                    result = "c";
                    break;
                }
                case 1: {
                    result = "r";
                    break;
                }
            }
            return result;
        }
    }

    public static class Type {
        private static final int INT_GENERAL = 0;
        private static final int INT_NUMBER = 1;
        private static final int INT_CURRENCY = 2;
        private static final int INT_DATETIME = 3;
        private static final int INT_RATE = 4;
        private static final int INT_FRACTION = 5;
        private static final int INT_SCIENTIFIC = 6;
        private static final int INT_CUSTOM = 7;
        private static final int INT_HEX = 8;
        private static final int INT_BIG_HEX = 9;
        private static final int INT_OCTAL = 10;
        private static final int INT_BINARY = 11;
        private int typeField;
        public static final Type GENERAL = new Type(0);
        public static final Type NUMBER = new Type(1);
        public static final Type CURRENCY = new Type(2);
        public static final Type DATETIME = new Type(3);
        public static final Type RATE = new Type(4);
        public static final Type FRACTION = new Type(5);
        public static final Type SCIENTIFIC = new Type(6);
        public static final Type CUSTOM = new Type(7);
        public static final Type HEX = new Type(8);
        public static final Type BIG_HEX = new Type(9);
        public static final Type OCTAL = new Type(10);
        public static final Type BINARY = new Type(11);

        private Type(int type) {
            this.typeField = type;
        }

        public String toString() {
            String result = super.toString();
            switch (this.typeField) {
                case 0: {
                    result = "s";
                    break;
                }
                case 1: {
                    result = "f";
                    break;
                }
                case 2: {
                    result = "f";
                    break;
                }
                case 3: {
                    result = "t";
                    break;
                }
                case 4: {
                    result = "p";
                    break;
                }
                case 5: {
                    result = "r";
                    break;
                }
                case 6: {
                    result = "e";
                    break;
                }
                case 7: {
                    result = "g";
                    break;
                }
                case 8: {
                    result = "x";
                    break;
                }
                case 9: {
                    result = "X";
                    break;
                }
                case 10: {
                    result = "o";
                    break;
                }
                case 11: {
                    result = "b";
                    break;
                }
            }
            return result;
        }
    }

    static class Position {
        private static final String NULL_STRING = "";
        private char begin;
        private char end;
        private char trans;
        private int leftPos = -1;
        private int rightPos = -1;

        public int getLeftPos() {
            return this.leftPos;
        }

        public int getRightPos() {
            return this.rightPos;
        }

        Position(char begin, char end) {
            this(begin, end, '!');
        }

        Position(char begin, char end, char trans) {
            this.begin = begin;
            this.end = end;
            this.trans = trans;
        }

        boolean paser(String source, int start) {
            int pos = start;
            this.leftPos = -1;
            int tmp = source.indexOf(this.begin, pos);
            while (tmp >= 0) {
                this.leftPos = tmp;
                if (tmp == 0 || source.charAt(tmp - 1) != this.trans) break;
                tmp = source.indexOf(this.begin, tmp + 1);
            }
            this.rightPos = -1;
            tmp = source.indexOf(this.end, pos);
            while (tmp > 0) {
                this.rightPos = tmp;
                if (tmp == 0 || source.charAt(tmp - 1) != this.trans) break;
                tmp = source.indexOf(this.end, tmp + 1);
            }
            return (this.leftPos != -1 || this.rightPos < 0) && this.leftPos <= this.rightPos;
        }

        String getSubString(String source) {
            int start = this.getLeftPos() + 1;
            int end = this.getRightPos();
            if (start >= 0 && end >= 0 && start < end) {
                return source.substring(start, end);
            }
            return NULL_STRING;
        }

        String getTransString(String source) {
            int start = this.getLeftPos() + 1;
            int end = this.getRightPos();
            if (start >= 0 && end >= 0 && start < end) {
                char[] chrSrc = source.substring(start, end).toCharArray();
                StringBuilder sb = new StringBuilder(chrSrc.length);
                boolean isTrans = false;
                for (int i = 0; i < chrSrc.length; ++i) {
                    if (isTrans || chrSrc[i] != this.trans) {
                        sb.append(chrSrc[i]);
                        isTrans = false;
                        continue;
                    }
                    isTrans = true;
                }
                return sb.toString();
            }
            return NULL_STRING;
        }
    }
}

