/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.headfootdesigner;

import java.io.Serializable;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;

public class HeadFootRow
implements Serializable {
    private static final long serialVersionUID = 1255340217252535483L;
    private String text;
    private String originText;
    private StyleAttributes sa;

    public HeadFootRow() {
        this("");
    }

    public HeadFootRow(String text) {
        this(text, Styles.getDefaultSA());
    }

    public HeadFootRow(String text, StyleAttributes sa) {
        this.text = text;
        this.originText = null;
        this.sa = sa;
    }

    public HeadFootRow(HeadFootRow row) {
        this.text = row.text;
        this.originText = row.originText;
        this.sa = Styles.getSA(row.getSA() == null ? Styles.getDefaultSSA() : row.getSA());
    }

    public StyleAttributes getSA() {
        return this.sa;
    }

    public String getText() {
        return this.text;
    }

    public void setSA(StyleAttributes sa) {
        this.sa = sa;
    }

    public void setText(String string) {
        this.text = string;
        this.originText = null;
    }

    public String toString() {
        return this.getOriginText();
    }

    public int hashCode() {
        return this.text.hashCode() ^ this.sa.hashCode();
    }

    public boolean equals(Object o) {
        HeadFootRow r;
        return o instanceof HeadFootRow && (r = (HeadFootRow)o).getText().equals(this.getText()) && r.getSA().equals(this.getSA());
    }

    public void setOriginText(String originText) {
        this.originText = originText;
    }

    public String getOriginText() {
        if (StringUtil.isEmptyString(this.originText)) {
            return this.getText();
        }
        return this.originText;
    }
}

