/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class BMPReader {
    private static final Log log = LogFactory.getLog(BMPReader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image loadBitMap(String fileName) {
        try (FileInputStream inputStream = new FileInputStream(fileName);){
            Image image = BMPReader.loadBitMap(inputStream);
            return image;
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public static Image loadBitMap(byte[] data) {
        return BMPReader.loadBitMap(new ByteArrayInputStream(data));
    }

    public static Image loadBitMap(InputStream is) {
        try {
            boolean isTopDownType;
            Image image = null;
            int bflen = 14;
            byte[] bf = new byte[bflen];
            is.read(bf, 0, bflen);
            int bilen = 40;
            byte[] bi = new byte[bilen];
            is.read(bi, 0, bilen);
            int nwidth = (bi[7] & 0xFF) << 24 | (bi[6] & 0xFF) << 16 | (bi[5] & 0xFF) << 8 | bi[4] & 0xFF;
            int nheight = (bi[11] & 0xFF) << 24 | (bi[10] & 0xFF) << 16 | (bi[9] & 0xFF) << 8 | bi[8] & 0xFF;
            int nbitcount = (bi[15] & 0xFF) << 8 | bi[14] & 0xFF;
            int ncompression = bi[19] << 24 | bi[18] << 16 | bi[17] << 8 | bi[16];
            int nsizeimage = (bi[23] & 0xFF) << 24 | (bi[22] & 0xFF) << 16 | (bi[21] & 0xFF) << 8 | bi[20] & 0xFF;
            int nclrused = (bi[35] & 0xFF) << 24 | (bi[34] & 0xFF) << 16 | (bi[33] & 0xFF) << 8 | bi[32] & 0xFF;
            boolean bl = isTopDownType = (nheight >> 31 & 1) == 1;
            if (ncompression == 0) {
                if (nbitcount == 32) {
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    if (nsizeimage == 0) {
                        nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                        nsizeimage *= nheight;
                    }
                    int npad = nsizeimage / nheight - nwidth * 4;
                    int[] ndata = new int[nheight * nwidth];
                    byte[] brgb = new byte[(nwidth * 4 + npad) * nheight];
                    is.read(brgb, 0, (nwidth * 4 + npad) * nheight);
                    int nindex = 0;
                    if (isTopDownType) {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                ndata[nwidth * j + i] = 0xFF000000 | (brgb[nindex + 2] & 0xFF) << 16 | (brgb[nindex + 1] & 0xFF) << 8 | brgb[nindex] & 0xFF;
                                nindex += 4;
                            }
                            nindex += npad;
                        }
                    } else {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (brgb[nindex + 2] & 0xFF) << 16 | (brgb[nindex + 1] & 0xFF) << 8 | brgb[nindex] & 0xFF;
                                nindex += 4;
                            }
                            nindex += npad;
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth));
                } else if (nbitcount == 24) {
                    int npad;
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    if (nsizeimage == 0) {
                        nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                        nsizeimage *= nheight;
                    }
                    if ((npad = nsizeimage / nheight - nwidth * 3) == 4) {
                        npad = 0;
                    }
                    int[] ndata = new int[nheight * nwidth];
                    byte[] brgb = new byte[(nwidth * 3 + npad) * nheight];
                    is.read(brgb, 0, (nwidth * 3 + npad) * nheight);
                    int nindex = 0;
                    if (isTopDownType) {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                ndata[nwidth * j + i] = 0xFF000000 | (brgb[nindex + 2] & 0xFF) << 16 | (brgb[nindex + 1] & 0xFF) << 8 | brgb[nindex] & 0xFF;
                                nindex += 3;
                            }
                            nindex += npad;
                        }
                    } else {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (brgb[nindex + 2] & 0xFF) << 16 | (brgb[nindex + 1] & 0xFF) << 8 | brgb[nindex] & 0xFF;
                                nindex += 3;
                            }
                            nindex += npad;
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth));
                } else if (nbitcount == 16) {
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    if (nsizeimage == 0) {
                        nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                        nsizeimage *= nheight;
                    }
                    int npad16 = nsizeimage / nheight - nwidth * 2;
                    int[] ndata16 = new int[nwidth * nheight];
                    byte[] bdata = new byte[(nwidth * 2 + npad16) * nheight];
                    is.read(bdata, 0, (nwidth * 2 + npad16) * nheight);
                    int nindex16 = 0;
                    if (isTopDownType) {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                ndata16[nwidth * j + i] = 0xFF000000 | (bdata[nindex16] & 0x1F) * 8 | ((bdata[nindex16 + 1] & 3) << 3 | (bdata[nindex16] & 0xE0) >> 5) * 8 << 8 | (bdata[nindex16 + 1] & 0x7C) * 8 >> 2 << 16;
                                nindex16 += 2;
                            }
                            nindex16 += npad16;
                        }
                    } else {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                ndata16[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (bdata[nindex16] & 0x1F) * 8 | ((bdata[nindex16 + 1] & 3) << 3 | (bdata[nindex16] & 0xE0) >> 5) * 8 << 8 | (bdata[nindex16 + 1] & 0x7C) * 8 >> 2 << 16;
                                nindex16 += 2;
                            }
                            nindex16 += npad16;
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata16, 0, nwidth));
                } else if (nbitcount == 8) {
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    int nNumColors = 0;
                    nNumColors = nclrused > 0 ? nclrused : 256;
                    if (nsizeimage == 0) {
                        nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                        nsizeimage *= nheight;
                    }
                    int[] npalette = new int[nNumColors];
                    byte[] bpalette = new byte[nNumColors * 4];
                    is.read(bpalette, 0, nNumColors * 4);
                    int nindex8 = 0;
                    for (int n = 0; n < nNumColors; ++n) {
                        npalette[n] = 0xFF000000 | (bpalette[nindex8 + 2] & 0xFF) << 16 | (bpalette[nindex8 + 1] & 0xFF) << 8 | bpalette[nindex8] & 0xFF;
                        nindex8 += 4;
                    }
                    int npad8 = nsizeimage / nheight - nwidth;
                    int[] ndata8 = new int[nwidth * nheight];
                    byte[] bdata = new byte[(nwidth + npad8) * nheight];
                    is.read(bdata, 0, (nwidth + npad8) * nheight);
                    nindex8 = 0;
                    if (isTopDownType) {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                ndata8[nwidth * j + i] = npalette[bdata[nindex8] & 0xFF];
                                ++nindex8;
                            }
                            nindex8 += npad8;
                        }
                    } else {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                ndata8[nwidth * (nheight - j - 1) + i] = npalette[bdata[nindex8] & 0xFF];
                                ++nindex8;
                            }
                            nindex8 += npad8;
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata8, 0, nwidth));
                } else if (nbitcount == 4) {
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    if (nsizeimage == 0) {
                        nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                        nsizeimage *= nheight;
                    }
                    int nNumColors = 0;
                    nNumColors = nclrused > 0 ? nclrused : 16;
                    int[] npalette = new int[nNumColors];
                    byte[] bpalette = new byte[nNumColors * 4];
                    is.read(bpalette, 0, nNumColors * 4);
                    int nindex4 = 0;
                    for (int n = 0; n < nNumColors; ++n) {
                        npalette[n] = 0xFF000000 | (bpalette[nindex4 + 2] & 0xFF) << 16 | (bpalette[nindex4 + 1] & 0xFF) << 8 | bpalette[nindex4] & 0xFF;
                        nindex4 += 4;
                    }
                    int npad4 = nsizeimage * 2 / nheight - nwidth;
                    int[] ndata4 = new int[nwidth * nheight];
                    byte[] bdata = new byte[(nwidth + npad4) / 2 * nheight];
                    is.read(bdata, 0, (nwidth + npad4) / 2 * nheight);
                    nindex4 = 0;
                    if (isTopDownType) {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                int idx = nindex4 / 2;
                                int bit = nindex4 % 2;
                                int color = (bdata[idx] & 0xFF) >> (1 - bit) * 4 & 0xF;
                                ndata4[nwidth * j + i] = npalette[color];
                                ++nindex4;
                            }
                            nindex4 += npad4;
                        }
                    } else {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                int idx = nindex4 / 2;
                                int bit = nindex4 % 2;
                                int color = (bdata[idx] & 0xFF) >> (1 - bit) * 4 & 0xF;
                                ndata4[nwidth * (nheight - j - 1) + i] = npalette[color];
                                ++nindex4;
                            }
                            nindex4 += npad4;
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata4, 0, nwidth));
                } else if (nbitcount == 1) {
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    if (nsizeimage == 0) {
                        nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                        nsizeimage *= nheight;
                    }
                    int nNumColors = 0;
                    nNumColors = nclrused > 0 ? nclrused : 2;
                    int[] npalette = new int[nNumColors];
                    byte[] bpalette = new byte[nNumColors * 4];
                    is.read(bpalette, 0, nNumColors * 4);
                    int nindex2 = 0;
                    for (int n = 0; n < nNumColors; ++n) {
                        npalette[n] = 0xFF000000 | (bpalette[nindex2 + 2] & 0xFF) << 16 | (bpalette[nindex2 + 1] & 0xFF) << 8 | bpalette[nindex2] & 0xFF;
                        nindex2 += 4;
                    }
                    int npad2 = nsizeimage * 8 / nheight - nwidth;
                    int[] ndata2 = new int[nwidth * nheight];
                    byte[] bdata = new byte[(nwidth + npad2) / 8 * nheight];
                    is.read(bdata, 0, (nwidth + npad2) / 8 * nheight);
                    nindex2 = 0;
                    if (isTopDownType) {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                int idx = nindex2 / 8;
                                int bit = nindex2 % 8;
                                int color = (bdata[idx] & 0xFF) << bit >> 7 & 1;
                                ndata2[nwidth * j + i] = npalette[color];
                                ++nindex2;
                            }
                            nindex2 += npad2;
                        }
                    } else {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                int idx = nindex2 / 8;
                                int bit = nindex2 % 8;
                                int color = (bdata[idx] & 0xFF) << bit >> 7 & 1;
                                ndata2[nwidth * (nheight - j - 1) + i] = npalette[color];
                                ++nindex2;
                            }
                            nindex2 += npad2;
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata2, 0, nwidth));
                } else {
                    log.debug("color bit type [" + nbitcount + "] not supported ...");
                }
            } else if (ncompression == 1) {
                if (nsizeimage == 0) {
                    log.debug("invalid size info in commpression type <BI_RLE8> ...");
                } else if (nbitcount == 8) {
                    int[] nswapdata8;
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    int nNumColors = 0;
                    nNumColors = nclrused > 0 ? nclrused : 256;
                    int[] npalette = new int[nNumColors];
                    byte[] bpalette = new byte[nNumColors * 4];
                    is.read(bpalette, 0, nNumColors * 4);
                    int nindex8 = 0;
                    for (int n = 0; n < nNumColors; ++n) {
                        npalette[n] = 0xFF000000 | (bpalette[nindex8 + 2] & 0xFF) << 16 | (bpalette[nindex8 + 1] & 0xFF) << 8 | bpalette[nindex8] & 0xFF;
                        nindex8 += 4;
                    }
                    int[] ndata8 = new int[nwidth * nheight];
                    byte[] bdata = new byte[nsizeimage];
                    is.read(bdata, 0, nsizeimage);
                    int x = 0;
                    int idx = 0;
                    block30: for (int y = 0; y < nheight; ++y) {
                        x = 0;
                        while (true) {
                            int j;
                            int count;
                            if (bdata[idx] == 0) {
                                if ((bdata[idx + 1] & 0xFF) == 0) {
                                    idx += 2;
                                    continue block30;
                                }
                                if ((bdata[idx + 1] & 0xFF) == 1) {
                                    y = nheight;
                                    continue block30;
                                }
                                if ((bdata[idx + 1] & 0xFF) == 2) {
                                    x += bdata[idx + 2] & 0xFF;
                                    if ((y += bdata[(idx += 4) + 3] & 0xFF) < nheight) continue;
                                    continue block30;
                                }
                                count = bdata[idx + 1] & 0xFF;
                                for (j = 0; j < count && x < nwidth; ++j) {
                                    ndata8[y * nwidth + x++] = npalette[bdata[idx + 2 + j] & 0xFF];
                                }
                                idx += count % 2 == 0 ? count + 2 : count + 3;
                                continue;
                            }
                            count = bdata[idx] & 0xFF;
                            for (j = 0; j < count && x < nwidth; ++j) {
                                ndata8[y * nwidth + x++] = npalette[bdata[idx + 1] & 0xFF];
                            }
                            idx += 2;
                        }
                    }
                    if (isTopDownType) {
                        nswapdata8 = ndata8;
                    } else {
                        nswapdata8 = new int[ndata8.length];
                        for (int i = 0; i < nheight; ++i) {
                            System.arraycopy(ndata8, i * nwidth, nswapdata8, (nheight - i - 1) * nwidth, nwidth);
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, nswapdata8, 0, nwidth));
                } else {
                    log.debug("color bit type [" + nbitcount + "] not match commpression type <BI_RLE8> ...");
                }
            } else if (ncompression == 2) {
                if (nsizeimage == 0) {
                    log.debug("invalid size info in commpression type <BI_RLE4> ...");
                } else if (nbitcount == 4) {
                    int[] nswapdata4;
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    int nNumColors = 0;
                    nNumColors = nclrused > 0 ? nclrused : 16;
                    int[] npalette = new int[nNumColors];
                    byte[] bpalette = new byte[nNumColors * 4];
                    is.read(bpalette, 0, nNumColors * 4);
                    int nindex4 = 0;
                    for (int n = 0; n < nNumColors; ++n) {
                        npalette[n] = 0xFF000000 | (bpalette[nindex4 + 2] & 0xFF) << 16 | (bpalette[nindex4 + 1] & 0xFF) << 8 | bpalette[nindex4] & 0xFF;
                        nindex4 += 4;
                    }
                    int[] ndata4 = new int[nwidth * nheight];
                    byte[] bdata = new byte[nsizeimage];
                    is.read(bdata, 0, nsizeimage);
                    int x = 0;
                    int idx = 0;
                    block36: for (int y = 0; y < nheight; ++y) {
                        x = 0;
                        while (true) {
                            int count;
                            if (bdata[idx] == 0) {
                                if ((bdata[idx + 1] & 0xFF) == 0) {
                                    idx += 2;
                                    continue block36;
                                }
                                if ((bdata[idx + 1] & 0xFF) == 1) {
                                    y = nheight;
                                    continue block36;
                                }
                                if ((bdata[idx + 1] & 0xFF) == 2) {
                                    x += bdata[idx + 2] & 0xFF;
                                    if ((y += bdata[(idx += 4) + 3] & 0xFF) < nheight) continue;
                                    continue block36;
                                }
                                count = bdata[idx + 1] & 0xFF;
                                for (int j = 0; j < count && x < nwidth; ++j) {
                                    int color = j % 2 == 0 ? (bdata[idx + 2 + j / 2] & 0xF0) >> 4 : bdata[idx + 2 + j / 2] & 0xF;
                                    ndata4[y * nwidth + x++] = npalette[color];
                                }
                                idx += (count + 3) / 4 * 2 + 2;
                                continue;
                            }
                            count = bdata[idx] & 0xFF;
                            int color0 = (bdata[idx + 1] & 0xF0) >> 4;
                            int color1 = bdata[idx + 1] & 0xF;
                            for (int j = 0; j < count && x < nwidth; ++j) {
                                ndata4[y * nwidth + x++] = npalette[j % 2 == 0 ? color0 : color1];
                            }
                            idx += 2;
                        }
                    }
                    if (isTopDownType) {
                        nswapdata4 = ndata4;
                    } else {
                        nswapdata4 = new int[ndata4.length];
                        for (int i = 0; i < nheight; ++i) {
                            System.arraycopy(ndata4, i * nwidth, nswapdata4, (nheight - i - 1) * nwidth, nwidth);
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, nswapdata4, 0, nwidth));
                } else {
                    log.debug("color bit type [" + nbitcount + "] not match commpression type <BI_RLE4> ...");
                }
            } else if (ncompression == 3) {
                if (nsizeimage == 0) {
                    log.debug("invalid size info in commpression type <BI_BITFIELDS> ...");
                } else if (nbitcount == 16) {
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    if (nsizeimage == 0) {
                        nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                        nsizeimage *= nheight;
                    }
                    byte[] mask = new byte[12];
                    is.read(mask, 0, 12);
                    int rMask = ((mask[3] & 0xFF) << 24 | (mask[2] & 0xFF) << 16 | (mask[1] & 0xFF) << 8 | mask[0] & 0xFF) & 0xFFFF;
                    int gMask = ((mask[7] & 0xFF) << 24 | (mask[6] & 0xFF) << 16 | (mask[5] & 0xFF) << 8 | mask[4] & 0xFF) & 0xFFFF;
                    int bMask = ((mask[11] & 0xFF) << 24 | (mask[10] & 0xFF) << 16 | (mask[9] & 0xFF) << 8 | mask[8] & 0xFF) & 0xFFFF;
                    int rOffset = BMPReader.getDWORDr1Offset(rMask);
                    int gOffset = BMPReader.getDWORDr1Offset(gMask);
                    int bOffset = BMPReader.getDWORDr1Offset(bMask);
                    int rOffset2 = BMPReader.getDWORDr0Offset(rMask, rOffset);
                    int gOffset2 = BMPReader.getDWORDr0Offset(gMask, gOffset);
                    int bOffset2 = BMPReader.getDWORDr0Offset(bMask, bOffset);
                    int rLen = rOffset2 - rOffset;
                    int gLen = gOffset2 - gOffset;
                    int bLen = bOffset2 - bOffset;
                    int npad16 = nsizeimage / nheight - nwidth * 2;
                    int[] ndata16 = new int[nwidth * nheight];
                    byte[] bdata = new byte[(nwidth * 2 + npad16) * nheight];
                    is.read(bdata, 0, (nwidth * 2 + npad16) * nheight);
                    int nindex16 = 0;
                    if (isTopDownType) {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                int color = (bdata[nindex16 + 1] & 0xFF) << 8 | bdata[nindex16] & 0xFF;
                                ndata16[nwidth * j + i] = 0xFF000000 | (color & rMask) >> rOffset << 8 - rLen << 16 | (color & gMask) >> gOffset << 8 - gLen << 8 | (color & bMask) >> bOffset << 8 - bLen;
                                nindex16 += 2;
                            }
                            nindex16 += npad16;
                        }
                    } else {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                int color = (bdata[nindex16 + 1] & 0xFF) << 8 | bdata[nindex16] & 0xFF;
                                ndata16[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (color & rMask) >> rOffset << 8 - rLen << 16 | (color & gMask) >> gOffset << 8 - gLen << 8 | (color & bMask) >> bOffset << 8 - bLen;
                                nindex16 += 2;
                            }
                            nindex16 += npad16;
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata16, 0, nwidth));
                } else if (nbitcount == 32) {
                    if (isTopDownType) {
                        nheight = -nheight;
                    }
                    if (nsizeimage == 0) {
                        nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                        nsizeimage *= nheight;
                    }
                    byte[] mask = new byte[12];
                    is.read(mask, 0, 12);
                    int rMask = ((mask[3] & 0xFF) << 24 | (mask[2] & 0xFF) << 16 | (mask[1] & 0xFF) << 8 | mask[0] & 0xFF) & 0xFFFFFFFF;
                    int gMask = ((mask[7] & 0xFF) << 24 | (mask[6] & 0xFF) << 16 | (mask[5] & 0xFF) << 8 | mask[4] & 0xFF) & 0xFFFFFFFF;
                    int bMask = ((mask[11] & 0xFF) << 24 | (mask[10] & 0xFF) << 16 | (mask[9] & 0xFF) << 8 | mask[8] & 0xFF) & 0xFFFFFFFF;
                    int npad = nsizeimage / nheight - nwidth * 4;
                    int[] ndata = new int[nheight * nwidth];
                    byte[] bdata = new byte[(nwidth * 4 + npad) * nheight];
                    is.read(bdata, 0, (nwidth * 4 + npad) * nheight);
                    int nindex16 = 0;
                    if (isTopDownType) {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                int color = (bdata[nindex16 + 3] & 0xFF) << 24 | (bdata[nindex16 + 2] & 0xFF) << 16 | (bdata[nindex16 + 1] & 0xFF) << 8 | bdata[nindex16] & 0xFF;
                                ndata[nwidth * j + i] = 0xFF000000 | (color & rMask) >> 8 | (color & gMask) >> 8 | (color & bMask) >> 8;
                                nindex16 += 4;
                            }
                            nindex16 += npad;
                        }
                    } else {
                        for (int j = 0; j < nheight; ++j) {
                            for (int i = 0; i < nwidth; ++i) {
                                int color = (bdata[nindex16 + 3] & 0xFF) << 24 | (bdata[nindex16 + 2] & 0xFF) << 16 | (bdata[nindex16 + 1] & 0xFF) << 8 | bdata[nindex16] & 0xFF;
                                ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (color & rMask) >> 8 | (color & gMask) >> 8 | (color & bMask) >> 8;
                                nindex16 += 4;
                            }
                            nindex16 += npad;
                        }
                    }
                    image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth));
                } else {
                    log.debug("color bit type [" + nbitcount + "] not match commpression type <BI_BITFIELDS> ...");
                }
            } else {
                log.debug("commpression type [" + ncompression + "] not supported ...");
            }
            is.close();
            return image;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private static int getDWORDr1Offset(int src) {
        for (int i = 0; i < 31; ++i) {
            if ((1 << i & src) == 0) continue;
            return i;
        }
        return -1;
    }

    private static int getDWORDr0Offset(int src, int start) {
        for (int i = start; i < 31; ++i) {
            if ((1 << i & src) != 0) continue;
            return i;
        }
        return -1;
    }
}

