/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render;

final class BorderRenderMath {
    public static final int A_SIDE_COLOR_1 = 1;
    public static final int A_SIDE_COLOR_2 = 2;
    public static final int A_SIDE_COLOR_3 = 4;
    public static final int A_SIDE_COLOR_4 = 8;
    public static final int A_SIDE_COLOR_5 = 16;
    public static final int A_SIDE_COLOR_6 = 32;
    public static final int A_SIDE_COLOR_7 = 64;
    public static final int A_SIDE_COLOR_8 = 128;
    public static final int B_SIDE_COLOR_1 = 256;
    public static final int B_SIDE_COLOR_2 = 512;
    public static final int B_SIDE_COLOR_3 = 1024;
    public static final int B_SIDE_COLOR_4 = 2048;
    public static final int B_SIDE_COLOR_5 = 4096;
    public static final int B_SIDE_COLOR_6 = 8192;
    public static final int B_SIDE_COLOR_7 = 16384;
    public static final int B_SIDE_COLOR_8 = 32768;
    public static final int CENTER_COLOR = 0x1000000;
    public static final int BASE_TYPE = 0x10000000;
    public static final int NO_COLOR = 0;
    public static final int A_LENGTH_1 = 65536;
    public static final int A_LENGTH_2 = 131072;
    public static final int A_LENGTH_3 = 196608;
    public static final int A_LENGTH_4 = 262144;
    public static final int A_LENGTH_5 = 327680;
    public static final int A_LENGTH_6 = 393216;
    public static final int A_LENGTH_7 = 458752;
    public static final int A_LENGTH_8 = 524288;
    public static final int B_LENGTH_1 = 0x100000;
    public static final int B_LENGTH_2 = 0x200000;
    public static final int B_LENGTH_3 = 0x300000;
    public static final int B_LENGTH_4 = 0x400000;
    public static final int B_LENGTH_5 = 0x500000;
    public static final int B_LENGTH_6 = 0x600000;
    public static final int B_LENGTH_7 = 0x700000;
    public static final int B_LENGTH_8 = 0x800000;

    private BorderRenderMath() {
    }

    public static int createBityType(int aside, int alen, int bside, int blen, int center) {
        int base = 0;
        if (alen == 0 && blen == 0) {
            base = 0x10000000;
        }
        return aside | bside | alen | blen | center | base;
    }

    public static int creatBitType(int aside, int bside, int center) {
        int aCopy = aside &= 0xFF;
        int alen = 0;
        if (aCopy == 0) {
            alen = 0;
        } else {
            alen = 1;
            while ((aCopy >>= 1) != 0) {
                ++alen;
            }
            alen <<= 16;
        }
        int bCopy = (bside &= 0xFF00) >> 8;
        int blen = 0;
        if (bCopy == 0) {
            blen = 0;
        } else {
            blen = 1;
            while ((bCopy >>= 1) != 0) {
                ++blen;
            }
            blen <<= 20;
        }
        return BorderRenderMath.createBityType(aside, alen, bside, blen, center);
    }

    public static int getWeightA(int bitType) {
        return bitType >> 15 & 7;
    }

    public static int getWeightB(int bitType) {
        return bitType >> 18 & 7;
    }

    public static int calPartFactor(int diagonal, int near, int far) {
        if (diagonal != 0) {
            return diagonal;
        }
        if (near != 0) {
            return near;
        }
        if (far != 0) {
            return far | 8;
        }
        return 0;
    }

    public static int calFactor(int f1, int f2, int f3, int f4) {
        return f1 & 0xF | f2 << 4 & 0xF0 | f3 << 8 & 0xF00 | f4 << 12 & 0xF000;
    }

    public static int getFactor1(int factor) {
        return factor & 7;
    }

    public static int getFactor2(int factor) {
        return (factor & 0x70) >> 4;
    }

    public static int getFactor3(int factor) {
        return (factor & 0x700) >> 8;
    }

    public static int getFactor4(int factor) {
        return (factor & 0x7000) >> 12;
    }

    public static boolean isRise1(int factor) {
        return (factor & 8) > 0;
    }

    public static boolean isRise2(int factor) {
        return (factor & 0x80) > 0;
    }

    public static boolean isRise3(int factor) {
        return (factor & 0x800) > 0;
    }

    public static boolean isRise4(int factor) {
        return (factor & 0x8000) > 0;
    }
}

