/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ctrl.kdf.util.render.filter.AlphaFilter;
import kd.bos.print.core.ctrl.kdf.util.render.filter.IFilter;

public class ImageRender {
    protected Graphics2D graphics2D;
    protected Color xorColor;
    protected AffineTransform transform;
    protected int alpha = 100;
    protected ImageObserver imgObserver;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    private String getErrMsgNonG2d() {
        return ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u76ee\u6807\u753b\u5e03\uff0c\u4f7f\u7528setG2d()\u65b9\u6cd5\u663e\u5f0f\u8bbe\u7f6e\u3002", (String)"ImageRender_0", (String)"bos-print-core", (Object[])new Object[0]);
    }

    private String getErrMsgNonPoint() {
        return ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u7ed8\u5236\u8d77\u70b9\u3002", (String)"ImageRender_1", (String)"bos-print-core", (Object[])new Object[0]);
    }

    public ImageRender() {
    }

    public ImageRender(Graphics2D g2d, ImageObserver observer) {
        this.graphics2D = g2d;
        this.imgObserver = observer;
    }

    public ImageRender(Graphics2D g2d, AffineTransform aTransform) {
        this.graphics2D = g2d;
        this.transform = aTransform;
    }

    public ImageRender(Graphics2D g2d, ImageObserver observer, AffineTransform aTransform) {
        this.graphics2D = g2d;
        this.imgObserver = observer;
        this.transform = aTransform;
    }

    public void draw(Point pos, Image image) {
        this.draw(pos, image, null);
    }

    public void draw(Point pos, Image image, IFilter filter) {
        if (this.graphics2D == null) {
            throw new IllegalArgumentException(this.getErrMsgNonG2d());
        }
        if (pos == null) {
            throw new IllegalArgumentException(this.getErrMsgNonPoint());
        }
        if (image != null) {
            AffineTransform transTemp = null;
            if (this.alpha != 100) {
                AlphaFilter alphaFilter = new AlphaFilter(this.alpha);
                image = alphaFilter.filter(image);
            }
            if (filter != null) {
                image = filter.filter(image);
            }
            if (this.transform != null) {
                transTemp = this.graphics2D.getTransform();
                this.graphics2D.setTransform(this.transform);
            }
            this.graphics2D.drawImage(image, pos.x, pos.y, this.imgObserver);
            if (transTemp != null) {
                this.graphics2D.setTransform(transTemp);
            }
        }
    }

    public void draw(Point pos, byte[] bits) {
        this.draw(pos, this.toolkit.createImage(bits));
    }

    public void draw(Point pos, byte[] bits, IFilter filter) {
        this.draw(pos, this.toolkit.createImage(bits), filter);
    }

    public void draw(Point pos, ImageProducer source) {
        this.draw(pos, this.toolkit.createImage(source));
    }

    public void draw(Point pos, ImageProducer source, IFilter filter) {
        this.draw(pos, this.toolkit.createImage(source), filter);
    }

    public Graphics2D getGraphics2D() {
        return this.graphics2D;
    }

    public void setGraphics2D(Graphics2D g2d) {
        this.graphics2D = g2d;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public void setRotate(double value, int x, int y) {
        AffineTransform trans = new AffineTransform();
        trans.rotate(value, x, y);
        if (this.transform == null) {
            this.transform = trans;
        } else {
            this.transform.concatenate(trans);
        }
    }

    public void setScaleRate(double value) {
        AffineTransform trans = new AffineTransform();
        trans.scale(value, value);
        if (this.transform == null) {
            this.transform = trans;
        } else {
            this.transform.concatenate(trans);
        }
    }

    public void setAlpha(int alpha) {
        if (alpha >= 0 && alpha <= 100) {
            this.alpha = alpha;
        } else {
            alpha = 0 - alpha;
            this.alpha = alpha % 100;
        }
    }

    public void setImgOvserver(ImageObserver imgOvserver) {
        this.imgObserver = imgOvserver;
    }

    public ImageObserver getImgObserver() {
        return this.imgObserver;
    }
}

