/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render;

import java.awt.Graphics;
import java.awt.Shape;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.render.AbstractBasicRender;
import kd.bos.print.core.ctrl.kdf.util.render.SimpleTextRender;
import kd.bos.print.core.ctrl.kdf.util.render.TextRender;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.execute.ExecuteWorkFactory;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;

public class NoteTextRender
extends AbstractBasicRender {
    protected TextRender complexRender;
    protected SimpleTextRender simpleRender;

    public static NoteTextRender shareInstance() {
        return ExecuteWorkFactory.get().getNoteTextRender();
    }

    TextRender getComplexRender() {
        if (this.complexRender == null) {
            this.complexRender = new TextRender();
        }
        this.complexRender.setBlackWhite(this.isBlackWhite());
        return this.complexRender;
    }

    SimpleTextRender getSimpleRender() {
        if (this.simpleRender == null) {
            this.simpleRender = new SimpleTextRender();
            this.simpleRender.setKeepClip(false);
        }
        this.simpleRender.setBlackWhite(this.isBlackWhite());
        return this.simpleRender;
    }

    boolean isSimpleStyle(Style style) {
        return !style.isWrapText() && !style.isShrinkText() && style.getRotation() == 0 && !style.isClip() && !style.isStrikeThrough() && !style.isUnderline();
    }

    public void setIsClipString(boolean isClipString) {
        this.getSimpleRender().setIsClipString(isClipString);
    }

    public void setKeepClip(boolean b) {
        this.getSimpleRender().setKeepClip(b);
    }

    @Override
    public void draw(Graphics g, Shape clip, Object object, Style style) {
        if (null == object) {
            return;
        }
        if (object instanceof LineWrapParam) {
            String text = ((LineWrapParam)object).getText();
            if (StringUtil.isEmptyString(text)) {
                return;
            }
            if (this.isSimpleStyle(style)) {
                this.getSimpleRender().draw(g, clip, text, style);
            } else {
                this.getComplexRender().draw(g, clip, text, style, (LineWrapParam)object);
            }
        } else {
            String text = this.getText(String.valueOf(object));
            if (StringUtil.isEmptyString(text)) {
                return;
            }
            if (this.isSimpleStyle(style)) {
                this.getSimpleRender().draw(g, clip, text, style);
            } else {
                this.getComplexRender().draw(g, clip, text, style);
            }
        }
    }

    public String getText(Object text) {
        return text == null ? null : text.toString();
    }
}

