/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.FontUtil;
import kd.bos.print.core.ctrl.kdf.util.render.TextDetail;
import kd.bos.print.core.ctrl.kdf.util.render.formatparser.HtmlFormatParser;
import kd.bos.print.core.ctrl.kdf.util.render.formatparser.IParser;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.execute.ExecuteWorkFactory;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;

public class TextRender {
    private static final Log log = LogFactory.getLog(TextRender.class);
    public static final int INDENTSIZE = 28;
    private String source;
    private IParser parser;
    private TextDetail cell = new TextDetail();
    private boolean flagSimple = true;
    private boolean flagStyle = true;
    private Style cellStyle;
    protected boolean isBlackWhite = false;

    public static synchronized TextRender sharedInstance() {
        return ExecuteWorkFactory.get().getTextRender();
    }

    public TextRender() {
        this.parser = new HtmlFormatParser();
        this.cellStyle = Styles.getDefaultStyle();
    }

    public TextRender(String source, Style cellStyle) {
        this();
        this.source = source;
        if (cellStyle == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u683c\u5f0f\u96c6\u4e0d\u80fd\u4e3anull\u3002", (String)"TextRender_0", (String)"bos-print-core", (Object[])new Object[0]));
        }
        this.cellStyle = cellStyle;
    }

    public void setBlackWhite(boolean isBlackWhite) {
        this.isBlackWhite = isBlackWhite;
    }

    public boolean isBlackWhite() {
        return this.isBlackWhite;
    }

    public TextRender(String source, Style cellStyle, IParser parser) {
        this(source, cellStyle);
        this.parser = parser;
    }

    public void draw(Graphics g, Shape clip) {
        TextRender.draw(this, g, clip, null);
    }

    public void draw(Graphics g, Shape clip, LineWrapParam lineWrapParam) {
        TextRender.draw(this, g, clip, lineWrapParam);
    }

    private AttributedString parseStyleToAttributes() {
        if (this.source == null || this.source.length() < 1) {
            return null;
        }
        AttributedString as = new AttributedString(this.source);
        as.addAttribute(TextAttribute.FONT, this.cellStyle.getFont());
        Color fontColor = this.cellStyle.getFontColor();
        if (!this.isBlackWhite() || fontColor.getBlue() == fontColor.getRed() && fontColor.getBlue() == fontColor.getGreen()) {
            as.addAttribute(TextAttribute.FOREGROUND, fontColor);
        } else {
            as.addAttribute(TextAttribute.FOREGROUND, Color.BLACK);
        }
        if (this.cellStyle.isUnderline()) {
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.cellStyle.isStrikeThrough()) {
            as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return as;
    }

    public void draw(Graphics g, Shape clip, String source) {
        this.setSource(source);
        this.draw(g, clip);
    }

    public void draw(Graphics g, Shape clip, String source, Style cellStyle) {
        this.draw(g, clip, source, cellStyle, (LineWrapParam)null);
    }

    public void draw(Graphics g, Shape clip, String source, Style cellStyle, LineWrapParam lineWrapParam) {
        this.setSource(source);
        if (null != cellStyle) {
            this.setCellStyle(cellStyle);
            if (Styles.HorizontalAlignment.LEFT.equals(cellStyle.getHorizontalAlign())) {
                Rectangle rect = clip.getBounds();
                rect.x += 28 * cellStyle.getIndentation();
                clip = rect;
            }
            this.draw(g, clip, lineWrapParam);
        }
    }

    public void draw(Graphics g, Shape clip, String source, Style cellStyle, IParser parser) {
        this.setSource(source);
        this.setParser(parser);
        this.setCellStyle(cellStyle);
        this.draw(g, clip);
    }

    public IParser getParser() {
        return this.parser;
    }

    public String getSource() {
        return this.source;
    }

    public void setParser(IParser parser) {
        this.parser = parser;
    }

    public Style getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(Style style) {
        if (style == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u4f20\u5165\u7684Style\u53c2\u6570\u4e0d\u80fd\u4e3anull\u3002", (String)"TextRender_1", (String)"bos-print-core", (Object[])new Object[0]));
        }
        this.cellStyle = style;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public boolean isFlagSimple() {
        return this.flagSimple;
    }

    public void setFlagSimple(boolean b) {
        this.flagSimple = b;
    }

    public boolean isFlagStyle() {
        return this.flagStyle;
    }

    public void setFlagStyle(boolean flagStyle) {
        this.flagStyle = flagStyle;
    }

    private static synchronized void draw(TextRender render, Graphics g, Shape clip, LineWrapParam lineWrapParam) {
        if (render.isFlagSimple()) {
            if (null == render.source || render.source.trim().length() == 0) {
                return;
            }
            if (render.isFlagStyle()) {
                AttributedString as = render.parseStyleToAttributes();
                render.cell.setText(FontUtil.validateFont(as));
            } else {
                render.cell.setSource(render.source);
            }
        } else {
            AttributedString as = render.parser.parse(render.source, render.getCellStyle());
            if (null == as) {
                return;
            }
            render.cell.setText(as);
        }
        render.cell.setCellStyle(render.cellStyle);
        render.cell.draw((Graphics2D)g, clip, lineWrapParam);
    }
}

