/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.filter;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import kd.bos.print.core.ctrl.kdf.util.render.filter.IFilter;

public class AlphaFilter
implements IFilter {
    private int alpha = 100;

    public AlphaFilter(int alpha) {
        this.alpha = alpha;
    }

    @Override
    public Image filter(Image sourceImage) {
        if (this.alpha != 100) {
            sourceImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(sourceImage.getSource(), new ImageAlphaFilter(this.alpha / 100 * 256)));
        }
        return sourceImage;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (alpha >= 0 && alpha <= 100) {
            this.alpha = alpha;
        } else {
            alpha = 0 - alpha;
            this.alpha = alpha % 100;
        }
    }

    static class ImageAlphaFilter
    extends RGBImageFilter {
        private int iAlpha;

        public ImageAlphaFilter() {
            this.canFilterIndexColorModel = true;
            this.iAlpha = 255;
        }

        public ImageAlphaFilter(int alpha) {
            this.canFilterIndexColorModel = true;
            if (alpha < 0) {
                alpha *= -1;
            }
            this.iAlpha = alpha % 256;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            return rgb & 0xFFFFFF | this.iAlpha << 24;
        }
    }
}

