/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import kd.bos.print.core.ctrl.common.util.FontUtil;
import kd.bos.print.core.ctrl.kdf.util.render.layout.CellTextArea;
import kd.bos.print.core.ctrl.kdf.util.render.layout.ITextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureTextRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.TextRenderParam;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;

public abstract class AbstractTruncRender
implements ITextRender {
    protected CellTextArea textArea;
    protected double clipWidth;
    protected double clipHeight;
    protected double clipX;
    protected double clipY;
    protected double ascent;
    protected double descent;
    protected double advance;
    protected Style style;
    protected AttributedString as;
    protected boolean anchor;
    protected String linkUrl;

    @Override
    public void drawText(TextRenderParam renderParam) {
        Graphics2D g2d = renderParam.getG2d();
        String text = renderParam.getText();
        Rectangle clip = renderParam.getClip();
        Style style = renderParam.getStyle();
        boolean isBlackWhite = renderParam.isBlackWhite();
        if (style == null || null == text || text.trim().length() == 0) {
            return;
        }
        LineWrapParam param = renderParam.getLineWrapParam();
        this.style = style;
        if (Styles.HorizontalAlignment.LEFT.equals(style.getHorizontalAlign())) {
            Rectangle rect = clip.getBounds();
            rect.x += 28 * style.getIndentation();
            clip = rect;
        }
        FontRenderContext frc = g2d.getFontRenderContext();
        this.clipWidth = clip.getBounds2D().getWidth();
        this.clipHeight = clip.getBounds2D().getHeight();
        this.clipX = clip.getBounds2D().getMinX();
        this.clipY = clip.getBounds2D().getMinY();
        this.anchor = renderParam.isAnchor();
        this.linkUrl = renderParam.getLinkUrl();
        this.textArea = new CellTextArea(clip, style);
        this.textArea.setRotate(style.getRotation());
        this.as = FontUtil.validateFont(this.parseStyleToAttributes(text, style, isBlackWhite));
        SureTextRow tl = new SureTextRow(this.as, style.getFont(), frc, style, 0.0f);
        tl.setAnchor(this.anchor);
        tl.setLinkUrl(this.linkUrl);
        this.ascent = tl.getAscent();
        this.descent = tl.getDescent();
        this.advance = tl.getAdvance();
        this.buildTextArea(frc, param, renderParam.getWidgetWidth());
        this.textArea.draw(g2d);
    }

    private void buildTextArea(FontRenderContext frc, LineWrapParam param, int widgetWidth) {
        if (this.style.isShrinkText()) {
            this.drawShrink(frc);
        } else if (!this.style.isClip()) {
            this.clipWidth = widgetWidth;
            this.drawNoClip(frc);
        } else {
            this.drawNoShrink(frc, param);
        }
        if (this.textArea.getRows().size() == 0) {
            return;
        }
        this.applyHAlign();
        this.applyVAlign();
    }

    private void drawShrink(FontRenderContext frc) {
        double baseLineLength = this.getBaseLineLength();
        double rate = 1.0;
        if (baseLineLength < this.advance) {
            rate = baseLineLength / this.advance;
        }
        SureRow tl = this.createShrinkRow(frc);
        this.textArea.addRow(tl);
        this.textArea.setShrinkRate(rate);
    }

    private void drawNoClip(FontRenderContext frc) {
        SureRow tl = this.createShrinkRow(frc);
        this.textArea.addRow(tl);
    }

    protected AttributedString parseStyleToAttributes(String text, Style style, boolean isBlackWhite) {
        if (text == null || text.length() < 1) {
            return null;
        }
        AttributedString as = new AttributedString(text);
        as.addAttribute(TextAttribute.FONT, style.getFont());
        Color fontColor = style.getFontColor();
        if (!isBlackWhite || fontColor.getBlue() == fontColor.getRed() && fontColor.getBlue() == fontColor.getGreen()) {
            as.addAttribute(TextAttribute.FOREGROUND, fontColor);
        } else {
            as.addAttribute(TextAttribute.FOREGROUND, Color.BLACK);
        }
        if (style.isUnderline()) {
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (style.isStrikeThrough()) {
            as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return as;
    }

    protected abstract SureRow createShrinkRow(FontRenderContext var1);

    protected abstract void drawNoShrink(FontRenderContext var1, LineWrapParam var2);

    protected abstract void applyHAlign();

    protected abstract void applyVAlign();

    protected abstract double getBaseLineLength();

    protected abstract double getClipLineLength();
}

