/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import kd.bos.print.core.ctrl.common.util.FontUtil;
import kd.bos.print.core.ctrl.kdf.util.render.layout.ITextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.DrawLineParam;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.TextRenderParam;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.util.Util;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.print.core.execute.render.common.AdjustHeightInfo;
import kd.bos.print.core.execute.render.common.AdjustHeightRenderUtil;
import kd.bos.print.core.execute.render.common.linewrap.process.AdjustWrapProcess;

public class AdjustTextRender
implements ITextRender {
    @Override
    public void drawText(TextRenderParam renderParam) {
        float unUseHeight;
        float textHeight = renderParam.getTextHeight();
        Style style = renderParam.getStyle();
        Rect paddingRect = style.getPadding();
        String text = renderParam.getText();
        Rectangle clip = renderParam.getClip();
        Graphics2D g2d = renderParam.getG2d();
        float[] flexOffset = renderParam.getFlexOffset();
        float offsetY = 0.0f;
        if (textHeight <= 0.0f) {
            int calHeight = clip.height - 2;
            int calWidth = clip.width;
            AdjustHeightInfo adjustHeightInfo = AdjustTextRender.adjustHeight(text, style, calHeight, calHeight, calWidth);
            unUseHeight = (float)(clip.getHeight() - (double)adjustHeightInfo.getTextHeight());
            text = adjustHeightInfo.getUsedText();
        } else {
            unUseHeight = (float)(clip.getHeight() - (double)Util.lom2Pixel((int)textHeight));
        }
        if (unUseHeight > 0.0f) {
            offsetY = style.getVerticalAlign() == Styles.VerticalAlignment.TOP ? 0.0f : (style.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE ? unUseHeight / 2.0f : unUseHeight);
        }
        if (g2d == null) {
            return;
        }
        Font font = this.createFont(style, style.getKDFont().getSize2D());
        if (font == null) {
            font = style.getFont();
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Graphics2D g = (Graphics2D)g2d.create(style.getPadding().getLeft(), style.getPadding().getTop(), clip.width, clip.height + fontMetrics.getAscent());
        g.setColor(style.getFontColor());
        Font font2 = this.createFont(style, style.getKDFont().getSize2D());
        g.setFont(font2);
        LineMetrics lineMetrics = font.getLineMetrics(text, g.getFontRenderContext());
        String[] arr = text.split("\n");
        float top = (AdjustWrapProcess.getLineHeight(lineMetrics, style) - AdjustWrapProcess.getLineHeight(lineMetrics)) / 2.0f;
        float y = lineMetrics.getAscent() + offsetY + top;
        for (int i = 0; i < arr.length; ++i) {
            DrawLineParam param;
            float xOffset = 0.0f;
            if (flexOffset != null && i < flexOffset.length) {
                xOffset = flexOffset[i];
            }
            if (arr[i].length() > 0) {
                AttributedString as = new AttributedString(arr[i]);
                as.addAttribute(TextAttribute.FONT, style.getFont());
                as = FontUtil.validateFont(as);
                float textWidth = (float)FontUtil.calcAttributeStringWith(as, font, g.getFontRenderContext());
                float x = this.getX(arr[i], style, textWidth, clip.width, xOffset);
                param = new DrawLineParam(g, as, x, y, xOffset, style);
            } else {
                float textWidth = (float)fontMetrics.getStringBounds(arr[i], g).getWidth();
                float x = this.getX(arr[i], style, textWidth, clip.width, xOffset);
                param = new DrawLineParam(g, arr[i], x, y, xOffset, style);
            }
            param.setAnchor(renderParam.isAnchor());
            param.setLinkUrl(renderParam.getLinkUrl());
            ITextRender.drawLineText(param);
            y += AdjustWrapProcess.getLineHeight(lineMetrics, style);
        }
    }

    private Font createFont(Style style, float fontSize) {
        int boldAndItalic = 0;
        boldAndItalic += style.isBold() ? 1 : 0;
        return KDFont.loadFontFromJAR(style.getFontName(), boldAndItalic += style.isItalic() ? 2 : 0, fontSize);
    }

    private float getX(String drawText, Style style, float textWidth, int width, float flexOffset) {
        float x = 2.0f;
        int charNumber = drawText.length();
        int wordSpace = Util.pound2Pixel((int)style.getWordspacing());
        Styles.HorizontalAlignment align = style.getHorizontalAlign();
        if (align == Styles.HorizontalAlignment.CENTER) {
            x = ((float)width - textWidth - (float)((charNumber - 1) * wordSpace)) / 2.0f - flexOffset * (float)drawText.length() / 2.0f;
        } else if (align == Styles.HorizontalAlignment.RIGHT) {
            x = (float)width - textWidth - (float)((charNumber - 1) * wordSpace) - flexOffset * (float)drawText.length();
        }
        if (align == Styles.HorizontalAlignment.LEFT || align == Styles.HorizontalAlignment.JUSTIFY || x < 0.0f) {
            x = 0.0f;
        }
        return x;
    }

    private static AdjustHeightInfo adjustHeight(String text, Style style, int minH, int maxH, int width) {
        AdjustHeightInfo result = AdjustHeightRenderUtil.adjustCal(text, style, minH, maxH, width, 0);
        Rect padding = style.getPadding();
        int top = padding.getTop();
        int bottom = padding.getBottom();
        result.setUsedHeight(result.getUsedHeight() + (top += style.getBorderLineStyle(Styles.Position.TOP).getWidth()) + (bottom += style.getBorderLineStyle(Styles.Position.BOTTOM).getWidth()));
        return result;
    }
}

