/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import com.lowagie.text.pdf.PdfGraphics2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Line2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.kdf.util.render.layout.AdjustTextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.ShrinkTextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.TruncRotationTextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.TruncTextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.DrawLineParam;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.TextRenderParam;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.reportone.r1.common.designercore.util.Util;
import kd.bos.print.core.ctrl.reportone.r1.print.common.IAdjustHeightRenderSupport;

public interface ITextRender {
    public static final Log logger = LogFactory.getLog(ITextRender.class);

    public static ITextRender createRender(Object targetObj, Style style) {
        if (targetObj instanceof IAdjustHeightRenderSupport && ((IAdjustHeightRenderSupport)targetObj).isUseAdjustHeightRender()) {
            return new AdjustTextRender();
        }
        if (style.isShrinkText()) {
            return new ShrinkTextRender();
        }
        if (style.getRotation() == 0) {
            return new TruncTextRender();
        }
        return new TruncRotationTextRender();
    }

    public void drawText(TextRenderParam var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLineText(DrawLineParam param) {
        Color color;
        Graphics2D g = param.getG();
        if (param.isAnchor()) {
            HashMap<PdfGraphics2D.HyperLinkKey, String> map = new HashMap<PdfGraphics2D.HyperLinkKey, String>(1);
            map.put(PdfGraphics2D.HyperLinkKey.KEY_INSTANCE, param.getLinkUrl());
            g.addRenderingHints(map);
        }
        AttributedString drawAtrText = param.getDrawAtrText();
        AttributedCharacterIterator aci = drawAtrText.getIterator();
        float x = param.getX();
        float y = param.getY();
        float flexOffset = param.getFlexOffset();
        Style style = param.getStyle();
        Font font = (Font)aci.getAttribute(TextAttribute.FONT);
        if (font == null) {
            font = style.getFont();
        }
        if ((color = (Color)aci.getAttribute(TextAttribute.FOREGROUND)) == null) {
            color = style.getFontColor();
        }
        g.setColor(color);
        g.setFont(font);
        int wordSpace = Util.pound2Pixel((int)style.getWordspacing());
        int[] wordsSpace = new int[]{wordSpace, 0};
        boolean underline = style.isUnderline();
        boolean strikeThrough = style.isStrikeThrough();
        float preX = x;
        for (int i = 0; i < aci.getEndIndex(); ++i) {
            char nowChar = aci.current();
            x += flexOffset;
            Font ft = (Font)aci.getAttribute(TextAttribute.FONT);
            if (ft != null) {
                font = ft;
                g.setFont(font);
            }
            if (underline && '\n' != nowChar) {
                AttributedString attributedString = new AttributedString(String.valueOf(nowChar));
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                attributedString.addAttribute(TextAttribute.FONT, font);
                g.drawString(attributedString.getIterator(), x, y);
            } else {
                g.drawString(String.valueOf(nowChar), x, y);
            }
            x += (float)(g.getFontMetrics().getStringBounds(String.valueOf(nowChar), g).getWidth() + (double)wordsSpace[0]);
            aci.next();
        }
        if (strikeThrough && aci.getEndIndex() != 0 && (aci.getEndIndex() != 1 || '\n' != aci.first())) {
            Stroke saveStroke = g.getStroke();
            try {
                LineMetrics lineMetrics = font.getLineMetrics(aci, aci.getBeginIndex(), aci.getEndIndex(), g.getFontRenderContext());
                float strikeY = y + lineMetrics.getStrikethroughOffset();
                g.setStroke(new BasicStroke(lineMetrics.getStrikethroughThickness()));
                g.draw(new Line2D.Float(preX, strikeY, x, strikeY));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            finally {
                g.setStroke(saveStroke);
            }
        }
    }
}

