/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import com.lowagie.text.pdf.PdfGraphics2D;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.util.FontUtil;
import kd.bos.print.core.ctrl.kdf.util.render.layout.ITextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.StandardUnderline;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.TextRenderParam;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;
import kd.bos.print.core.execute.render.common.linewrap.process.AdjustWrapProcess;
import kd.bos.print.core.execute.render.common.linewrap.process.ShrinkWrapProcess;
import kd.bos.print.core.model.ui.view.StyleRender;

public class ShrinkTextRender
implements ITextRender {
    private static final Log log = LogFactory.getLog(ShrinkTextRender.class);

    @Override
    public void drawText(TextRenderParam renderParam) {
        Rectangle clip = renderParam.getClip();
        LineWrapParam param = renderParam.getLineWrapParam();
        Style style = renderParam.getStyle();
        Graphics2D g2d = renderParam.getG2d();
        if (renderParam.isAnchor()) {
            HashMap<PdfGraphics2D.HyperLinkKey, String> map = new HashMap<PdfGraphics2D.HyperLinkKey, String>(1);
            map.put(PdfGraphics2D.HyperLinkKey.KEY_INSTANCE, renderParam.getLinkUrl());
            g2d.addRenderingHints(map);
        }
        String text = renderParam.getText();
        if (clip.width <= 0 || clip.height <= 0) {
            return;
        }
        int oriHeight = clip.height;
        boolean wordFlex = false;
        if (param != null) {
            if (param.getRule() == LineWrapRule.NoWrap) {
                clip.width = StyleRender.getContentBounds((int)param.getMinW(), (int)0, (Style)style).width;
            }
            wordFlex = param.isWordFlex();
        }
        DrawingInfo info = this.thickAdjust(g2d, text, clip.width, clip.height, style);
        LineWrapRule rule = param == null ? null : param.getRule();
        int yOffset = this.thinAdjust(g2d, clip, info, style, rule, oriHeight, wordFlex);
        this.drawing(g2d, clip, info, style, yOffset, rule, wordFlex);
    }

    public DrawingInfo thickAdjust(Graphics2D g2d, String text, int width, int height, Style style) {
        float lineHeight;
        float wordSpacing = style.getWordspacing();
        float lineSpacing = style.getLinespacing();
        float fontSize = ShrinkTextRender.getOriSize(style);
        while (true) {
            float rate;
            if (fontSize <= 0.0f) {
                return DrawingInfo.create(text, 0, 0.0f, 0.0f, 0.0f);
            }
            Font font = ShrinkTextRender.createFont(style, fontSize);
            float avgCharWidth = ShrinkTextRender.estimateAvgCharWidth(text, font, wordSpacing);
            if ((float)width < avgCharWidth) {
                rate = (float)width / avgCharWidth;
                log.debug("\u5bbd\u5ea6\u592a\u5c0f\uff0c\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + (fontSize *= rate));
                continue;
            }
            lineHeight = ShrinkTextRender.calculateLineHeight(text, font, style, g2d);
            if ((float)height < lineHeight) {
                rate = (float)height / lineHeight;
                log.debug("\u9ad8\u5ea6\u592a\u5c0f\uff0c\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + (fontSize *= rate));
                continue;
            }
            float lineCount = (float)height / lineHeight;
            int acceptedCharCount = (int)((float)width / avgCharWidth * lineCount);
            if (acceptedCharCount >= text.length()) break;
            fontSize = (float)((double)fontSize * Math.sqrt((float)acceptedCharCount / (float)text.length()));
            log.debug("\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + fontSize);
        }
        return DrawingInfo.create(text, fontSize, lineHeight, wordSpacing, lineSpacing);
    }

    public int thinAdjust(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style) {
        return this.thinAdjust(g2d, rect, info, style, LineWrapRule.ChunkLine, rect.height, false);
    }

    private int thinAdjust(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style, LineWrapRule rule, int oriHeight, boolean wordFlex) {
        String text = info.getText();
        CalculateExtend ce = new CalculateExtend(g2d);
        int testTimes = 0;
        boolean toTry = true;
        while (toTry) {
            log.debug("\u8bd5\u63a2\u7b2c" + ++testTimes + "\u6b21\uff0c\u5b57\u53f7\uff1a" + info.getFontSizeF());
            Font font = ShrinkTextRender.createFont(style, info.getFontSizeF());
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            LineMetrics lm = font.getLineMetrics(text, g2d.getFontRenderContext());
            ce.setOnceMore(false);
            ShrinkTextRender.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ce, font, rule, wordFlex);
            toTry = ce.isOnceMore();
        }
        int offsetY = style.getVerticalAlign() == Styles.VerticalAlignment.TOP ? 0 : (style.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE ? (oriHeight - ce.getUsedHeight()) / 2 - 1 : oriHeight - ce.getUsedHeight() - 2);
        return offsetY;
    }

    private void drawing(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style, int yOffset, LineWrapRule rule, boolean wordFlex) {
        String text = info.getText();
        Graphics2D newGraphics = (Graphics2D)g2d.create(rect.x, rect.y + yOffset, rect.width, rect.height > yOffset ? rect.height - yOffset : yOffset);
        newGraphics.setFont(ShrinkTextRender.createFont(style, info.getFontSizeF()));
        newGraphics.setColor(style.getFontColor());
        DrawingExtend ext = new DrawingExtend(newGraphics);
        Font font = ShrinkTextRender.createFont(style, info.getFontSizeF());
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        LineMetrics lm = font.getLineMetrics(text, 0, 1, g2d.getFontRenderContext());
        try {
            ShrinkTextRender.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ext, font, rule, wordFlex);
        }
        catch (Exception e) {
            log.warn("\u5728ComplexTextRender\u4e2d\u7ed8\u5236\u5b57\u7b26" + text + "   " + e);
        }
    }

    private static void throughStringAtRect(String text, DrawingInfo info, Style style, int width, int height, FontMetrics fontMetrics, LineMetrics lineMetrics, IThroughStringAtRect ext, Font font, LineWrapRule rule, boolean wordFlex) {
        float y;
        ShrinkWrapProcess shrinkWrapProcess = new ShrinkWrapProcess(new LineWrapParam.Builder(text, rule).font(font).minW(width).maxW(width).build());
        ShrinkWrapProcess.ShrinkWrapInfo shrinkWrapInfo = (ShrinkWrapProcess.ShrinkWrapInfo)shrinkWrapProcess.process(wordFlex);
        text = shrinkWrapInfo.getText();
        int j = 0;
        float[] flexOffsets = shrinkWrapInfo.getFlexOffset();
        float top = (AdjustWrapProcess.getLineHeight(lineMetrics, style) - AdjustWrapProcess.getLineHeight(lineMetrics)) / 2.0f;
        float startY = y = lineMetrics.getAscent() + top;
        float flexOffset = 0.0f;
        if (flexOffsets != null && flexOffsets.length > 0) {
            flexOffset += flexOffsets[0];
        }
        float offsetX = ShrinkTextRender.calculateOffsetX(text, 0, info, fontMetrics, font, width, style.getHorizontalAlign(), flexOffset);
        float x = 0.0f;
        float sumWidth = 0.0f;
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            float tempX;
            int charWidth;
            char aChar = text.charAt(i);
            int nextRowStart = i;
            if (!font.canDisplay(aChar)) {
                Font simSunFont = FontUtil.createSimSunFont(font);
                FontMetrics simSunFontFm = Toolkit.getDefaultToolkit().getFontMetrics(simSunFont);
                charWidth = simSunFontFm.charWidth(aChar);
            } else {
                charWidth = fontMetrics.charWidth(aChar);
            }
            if (aChar == '\n') {
                tempX = x + (float)charWidth;
                ++nextRowStart;
            } else {
                tempX = x + (float)charWidth;
            }
            sumWidth += (float)charWidth;
            if (tempX > (float)width || aChar == '\n') {
                boolean noWrapScale = sumWidth > (float)width && rule == LineWrapRule.NoWrap;
                float tempFlex = 0.0f;
                if (flexOffsets != null && ++j < flexOffsets.length) {
                    flexOffset = tempFlex = flexOffsets[j];
                }
                offsetX = ShrinkTextRender.calculateOffsetX(text, nextRowStart, info, fontMetrics, font, width, style.getHorizontalAlign(), tempFlex);
                x = 0.0f;
                tempX = charWidth;
                if ((y += info.getLineHeight()) + lineMetrics.getDescent() > (float)height || tempX > (float)width || noWrapScale) {
                    ext.dealOutSideRect(text, info, style, height, i);
                    return;
                }
            }
            ext.dealAChar(x + offsetX, y, aChar, charWidth);
            if (ext instanceof DrawingExtend && style.isUnderline() && '\n' != aChar) {
                float ulOffset = lineMetrics.getUnderlineOffset();
                float ulThickness = lineMetrics.getUnderlineThickness();
                StandardUnderline.DefaultUnderline.drawUnderline(ext.getGraphics2D(), ulThickness, x + offsetX, x + offsetX + (float)charWidth, y + ulOffset);
            }
            if ('\n' != aChar) {
                ShrinkTextRender.drawStrike(style, lineMetrics, ext, x + offsetX, charWidth, y);
            }
            if (charWidth <= 0) continue;
            x = tempX + info.getWordSpacing() + flexOffset;
        }
        if (y == startY) {
            float bom = (AdjustWrapProcess.getLineHeight(lineMetrics, style) - AdjustWrapProcess.getLineHeight(lineMetrics)) / 2.0f;
            y += bom;
        }
        ext.dealThroughEnd(text, info, style, height, y, lineMetrics);
    }

    private static float getOriSize(Style style) {
        return style.getKDFont().getSize2D();
    }

    private static float calculateLineHeight(String text, Font font, Style style, Graphics2D g2d) {
        LineMetrics lm = font.getLineMetrics(text, 0, 1, g2d.getFontRenderContext());
        return AdjustWrapProcess.getLineHeight(lm, style);
    }

    private static Font createFont(Style style, float fontSize) {
        int boldAndItalic = 0;
        boldAndItalic += style.isBold() ? 1 : 0;
        return KDFont.loadFontFromJAR(style.getFontName(), boldAndItalic += style.isItalic() ? 2 : 0, fontSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawStrike(Style style, LineMetrics lineMetrics, IThroughStringAtRect ext, float x, int textWidth, float y) {
        if (ext instanceof DrawingExtend && style.isStrikeThrough()) {
            Graphics2D g2d = ext.getGraphics2D();
            Stroke saveStroke = g2d.getStroke();
            try {
                float strikeY = y + lineMetrics.getStrikethroughOffset();
                g2d.setStroke(new BasicStroke(lineMetrics.getStrikethroughThickness()));
                g2d.draw(new Line2D.Float(x, strikeY, x + (float)textWidth, strikeY));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            finally {
                g2d.setStroke(saveStroke);
            }
        }
    }

    private static float estimateAvgCharWidth(String text, Font font, float wordSpacing) {
        if (text == null) {
            return 0.0f;
        }
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        float width = fm.stringWidth(text);
        return width / (float)text.length() + wordSpacing;
    }

    private static float calculateOffsetX(String text, int startIdx, DrawingInfo info, FontMetrics fontMetrics, Font font, int width, Styles.HorizontalAlignment horizontalAlignment, float flexOffset) {
        int lineCharIndex;
        if (horizontalAlignment == Styles.HorizontalAlignment.LEFT || horizontalAlignment == Styles.HorizontalAlignment.JUSTIFY) {
            return 0.0f;
        }
        float lineWidth = 0.0f;
        int charCount = text.length();
        for (lineCharIndex = startIdx; lineCharIndex < charCount; ++lineCharIndex) {
            int charWidth;
            char aChar = text.charAt(lineCharIndex);
            if (!font.canDisplay(aChar)) {
                Font simSunFont = FontUtil.createSimSunFont(font);
                FontMetrics simSunFontFm = Toolkit.getDefaultToolkit().getFontMetrics(simSunFont);
                charWidth = simSunFontFm.charWidth(aChar);
            } else {
                charWidth = fontMetrics.charWidth(aChar);
            }
            float addWidth = 0.0f;
            if (lineWidth > 0.0f && charWidth > 0) {
                addWidth = info.getWordSpacing();
            }
            if (lineWidth + (addWidth += (float)charWidth) > (float)width || aChar == '\n') break;
            lineWidth += addWidth;
        }
        float offsetX = horizontalAlignment == Styles.HorizontalAlignment.CENTER ? ((float)width - lineWidth) / 2.0f - (float)(lineCharIndex - startIdx - 1) * flexOffset / 2.0f : (float)width - lineWidth - (float)(lineCharIndex - startIdx - 1) * flexOffset;
        return offsetX;
    }

    private static class DrawingExtend
    implements IThroughStringAtRect {
        private Graphics2D g2d;

        public DrawingExtend(Graphics2D g) {
            this.g2d = g;
        }

        @Override
        public Graphics2D getGraphics2D() {
            return this.g2d;
        }

        @Override
        public void dealAChar(float x, float y, char aChar, int charWidth) {
            if (charWidth > 0) {
                Font oriFont = this.g2d.getFont();
                if (!oriFont.canDisplay(aChar)) {
                    this.g2d.setFont(FontUtil.createSimSunFont(oriFont));
                }
                this.g2d.drawString(String.valueOf(aChar), x, y);
                this.g2d.setFont(oriFont);
            }
        }

        @Override
        public void dealOutSideRect(String text, DrawingInfo info, Style style, int height, int throughingTextIdx) {
        }

        @Override
        public void dealThroughEnd(String text, DrawingInfo info, Style style, int height, float yEnd, LineMetrics lm) {
        }
    }

    private static class CalculateExtend
    implements IThroughStringAtRect {
        private boolean onceMore;
        private Graphics2D g2d;
        private float cacheFitSize = -1.0f;
        private float cacheMinTooBigSize = Float.MAX_VALUE;
        private int cacheFitYEnd = 0;

        public CalculateExtend(Graphics2D g) {
            this.g2d = g;
        }

        @Override
        public Graphics2D getGraphics2D() {
            return this.g2d;
        }

        public void setOnceMore(boolean is) {
            this.onceMore = is;
        }

        public boolean isOnceMore() {
            return this.onceMore;
        }

        public int getUsedHeight() {
            return this.cacheFitYEnd;
        }

        @Override
        public void dealOutSideRect(String text, DrawingInfo info, Style style, int height, int throughingTextIdx) {
            if (Float.compare(info.getFontSizeF(), this.cacheMinTooBigSize) < 0) {
                this.cacheMinTooBigSize = info.getFontSizeF();
            }
            float newSize = (float)((double)info.getFontSizeF() * Math.sqrt((float)throughingTextIdx / (float)text.length()));
            info.updateFontSize(newSize, style, height, this.g2d);
            if (Float.compare(newSize, this.cacheFitSize) > 0 && Float.compare(newSize, this.cacheMinTooBigSize) < 0) {
                this.onceMore = true;
                log.debug("\u7a7a\u95f4\u4e0d\u591f\uff0c\u5c0f\u5c0f\u5c0f\u5230" + newSize);
            } else {
                log.debug("\u7a7a\u95f4\u4e0d\u591f\uff0c\u4f46\u6ca1\u5fc5\u8981\u518d\u5c0f\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize);
            }
        }

        @Override
        public void dealAChar(float x, float y, char aChar, int charWidth) {
        }

        @Override
        public void dealThroughEnd(String text, DrawingInfo info, Style style, int height, float yEnd, LineMetrics lm) {
            float y = yEnd + lm.getDescent();
            if (Float.compare(info.getFontSizeF(), this.cacheFitSize) > 0) {
                log.debug("\u7f13\u5b58\u5408\u9002\u5b57\u53f7\u53ca\u7ed8\u5236\u72b6\u6001: " + this.cacheFitSize + " => " + info.getFontSizeF());
                this.cacheFitSize = info.getFontSizeF();
                this.cacheFitYEnd = (int)y + 1;
            }
            if (info.getFontSizeF() > 0.0f && Float.compare(info.getFontSizeF(), ShrinkTextRender.getOriSize(style)) < 0) {
                float spaceUsedRate = y / (float)height;
                log.debug("\u7a7a\u95f4\u5360\u7528\u7387\uff1a" + spaceUsedRate);
                if ((double)spaceUsedRate < 0.9) {
                    float newSize = (float)((double)info.getFontSizeF() * Math.sqrt(1.0f / spaceUsedRate) + 0.5);
                    if (Float.compare(newSize, this.cacheFitSize) <= 0) {
                        log.debug("\u6ca1\u5fc5\u8981\u518d\u5927\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize);
                    } else if (Float.compare(newSize, ShrinkTextRender.getOriSize(style)) <= 0) {
                        if (Float.compare(newSize, this.cacheMinTooBigSize) >= 0) {
                            log.debug("\u5df2\u77e5\u6700\u5c0f\u7684\u592a\u5927\u5b57\u53f7" + this.cacheMinTooBigSize + "\u3002\u6ca1\u5fc5\u8981\u518d\u5927\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize);
                        } else {
                            info.updateFontSize(newSize, style, height, this.g2d);
                            this.onceMore = true;
                            log.debug("\u5927\u5927\u5927\u5230" + newSize);
                        }
                    } else {
                        log.debug("\u65b0\u5b57\u53f7" + newSize + "\u4e0d\u80fd\u5927\u4e8e\u539f\u59cb\u5b57\u53f7" + ShrinkTextRender.getOriSize(style));
                    }
                }
            }
        }
    }

    private static interface IThroughStringAtRect {
        public void dealAChar(float var1, float var2, char var3, int var4);

        public void dealOutSideRect(String var1, DrawingInfo var2, Style var3, int var4, int var5);

        public void dealThroughEnd(String var1, DrawingInfo var2, Style var3, int var4, float var5, LineMetrics var6);

        public Graphics2D getGraphics2D();
    }

    public static class DrawingInfo {
        private String text;
        private float fontSize;
        private float lineHeight;
        private float wordSpacing;
        private float lineSpacing;

        private DrawingInfo(String text) {
            this.text = text;
        }

        @Deprecated
        public static DrawingInfo create(String text, int fontSize, float lineHeight, float wordSpacing, float lineSpacing) {
            return DrawingInfo.create(text, (float)fontSize, lineHeight, wordSpacing, lineSpacing);
        }

        public static DrawingInfo create(String text, float fontSize, float lineHeight, float wordSpacing, float lineSpacing) {
            DrawingInfo info = new DrawingInfo(text);
            info.fontSize = fontSize;
            info.lineHeight = lineHeight;
            info.wordSpacing = wordSpacing;
            info.lineSpacing = lineSpacing;
            return info;
        }

        public final String getText() {
            return this.text;
        }

        public final float getLineHeight() {
            return this.lineHeight;
        }

        @Deprecated
        public final int getFontSize() {
            return (int)this.fontSize;
        }

        public final float getFontSizeF() {
            return this.fontSize;
        }

        public final float getWordSpacing() {
            return this.wordSpacing;
        }

        public final float getLineSpacing() {
            return this.lineSpacing;
        }

        @Deprecated
        public final void updateFontSize(int fontSize, Style style, int rectHeight, Graphics2D g2d) {
            this.updateFontSize((float)fontSize, style, rectHeight, g2d);
        }

        public final void updateFontSize(float fontSize, Style style, int rectHeight, Graphics2D g2d) {
            this.fontSize = fontSize;
            this.lineHeight = ShrinkTextRender.calculateLineHeight(this.text, ShrinkTextRender.createFont(style, fontSize), style, g2d);
        }
    }
}

