/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.print.core.ctrl.kdf.util.render.layout.StandardUnderline;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureRow;
import kd.bos.print.core.execute.render.common.linewrap.ITextMeasurer;

public final class SureTextLayout
extends SureRow {
    private TextLayout text;
    private AttributedString attributedString;
    private float flexOffset = 0.0f;
    private int length;
    private float textWidth;

    public SureTextLayout(AttributedString as, TextLayout text, Point2D.Double point) {
        this.attributedString = as;
        this.text = text;
        this.point = point;
    }

    public SureTextLayout(AttributedString as, TextLayout text, int x, int y) {
        this.attributedString = as;
        this.text = text;
        this.point = new Point2D.Double(x, y);
    }

    public SureTextLayout(AttributedString as, TextLayout text) {
        this(as, text, 0, 0);
    }

    public SureTextLayout(AttributedString as, TextLayout text, ITextMeasurer measurer, float flexOffset, int length) {
        this(as, text, 0, 0);
        this.flexOffset = flexOffset;
        this.length = length;
    }

    public SureTextLayout(AttributedString as, TextLayout text, ITextMeasurer measurer, float flexOffset, float textWidth, int length) {
        this(as, text, measurer, flexOffset, length);
        this.textWidth = textWidth;
    }

    public TextLayout getText() {
        return this.text;
    }

    @Override
    public double getAdvance() {
        return this.textWidth;
    }

    @Override
    public double getDescent() {
        return this.getText().getDescent();
    }

    @Override
    public double getAscent() {
        return this.getText().getAscent();
    }

    @Override
    public void draw(Graphics2D g2d) {
        if (this.attributedString == null) {
            this.getText().draw(g2d, (float)this.getPoint().x, (float)this.getPoint().y);
        } else {
            StringBuilder sb = new StringBuilder();
            AttributedCharacterIterator aci = this.attributedString.getIterator();
            Font ft = (Font)aci.getAttribute(TextAttribute.FONT);
            Color pt = (Color)aci.getAttribute(TextAttribute.FOREGROUND);
            boolean strikethrough = aci.getAttribute(TextAttribute.STRIKETHROUGH) == TextAttribute.STRIKETHROUGH_ON;
            boolean underLine = aci.getAttribute(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON;
            Font ftOld = g2d.getFont();
            Paint ptOld = g2d.getPaint();
            if (ft != null) {
                g2d.setFont(ft);
            }
            if (pt != null) {
                g2d.setColor(pt);
            }
            float x = (float)this.getPoint().x;
            float y = (float)this.getPoint().y;
            for (int i = 0; i < aci.getEndIndex(); ++i) {
                x += this.flexOffset;
                char current = aci.current();
                sb.append(current);
                Font font = (Font)aci.getAttribute(TextAttribute.FONT);
                if (font != null) {
                    g2d.setFont(font);
                    ft = font;
                }
                g2d.drawString(String.valueOf(current), x, y);
                x += (float)g2d.getFontMetrics().getStringBounds(String.valueOf(current), g2d).getWidth();
                aci.next();
            }
            String str = sb.toString();
            if (strikethrough || underLine) {
                float x1 = (float)this.getPoint().x;
                float x2 = x;
                if (ft == null) {
                    throw new KDException(new ErrorCode("print-exception", ResManager.loadKDString((String)"\u5b57\u4f53\u4e3a\u7a7a\u3002", (String)"SureTextLayout_0", (String)"bos-print-core", (Object[])new Object[0])), new Object[0]);
                }
                LineMetrics lineMetrics = ft.getLineMetrics(str, g2d.getFontRenderContext());
                if (strikethrough) {
                    Stroke saveStroke = g2d.getStroke();
                    float strikeY = y + lineMetrics.getStrikethroughOffset();
                    g2d.setStroke(new BasicStroke(lineMetrics.getStrikethroughThickness()));
                    g2d.draw(new Line2D.Float(x1, strikeY, x2, strikeY));
                    g2d.setStroke(saveStroke);
                }
                if (underLine) {
                    float ulOffset = lineMetrics.getUnderlineOffset();
                    float ulThickness = lineMetrics.getUnderlineThickness();
                    StandardUnderline.DefaultUnderline.drawUnderline(g2d, ulThickness, x1, x2, y + ulOffset);
                }
            }
            g2d.setFont(ftOld);
            g2d.setPaint(ptOld);
        }
    }

    public float getFlexOffset() {
        return this.flexOffset;
    }

    public int getLength() {
        return this.length;
    }
}

