/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import kd.bos.print.core.ctrl.common.util.FontUtil;
import kd.bos.print.core.ctrl.kdf.util.render.layout.ITextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.DrawLineParam;
import kd.bos.print.core.ctrl.kdf.util.style.Style;

public class SureTextRow
extends SureRow {
    private final AttributedString attributeSource;
    private final Font font;
    private final LineMetrics metrics;
    private final FontRenderContext frc;
    private final Style style;
    private final float flexOffset;
    private boolean anchor;
    private String linkUrl;

    public SureTextRow(AttributedString attributeSource, Font font, FontRenderContext frc, Style style, float flexOffset) {
        this.attributeSource = attributeSource;
        super.setX(0.0);
        super.setY(0.0);
        this.font = font;
        this.frc = frc;
        AttributedCharacterIterator aci = attributeSource.getIterator();
        this.metrics = font.getLineMetrics(aci, aci.getBeginIndex(), aci.getEndIndex(), frc);
        this.style = style;
        this.flexOffset = flexOffset;
    }

    @Override
    public double getAdvance() {
        return FontUtil.calcAttributeStringWith(this.attributeSource, this.font, this.frc);
    }

    @Override
    public double getDescent() {
        return this.metrics.getDescent();
    }

    @Override
    public double getAscent() {
        return this.metrics.getAscent();
    }

    public double getHeight() {
        return this.metrics.getHeight();
    }

    public void setAnchor(boolean anchor) {
        this.anchor = anchor;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    @Override
    public void draw(Graphics2D g2d) {
        DrawLineParam param = new DrawLineParam(g2d, this.attributeSource, (float)this.point.x, (float)this.point.y, this.flexOffset, this.style);
        param.setAnchor(this.anchor);
        param.setLinkUrl(this.linkUrl);
        ITextRender.drawLineText(param);
    }
}

