/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ctrl.kdf.util.render.layout.IRowBreaker;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureTextLine;

public final class TextLineBreaker
implements IRowBreaker {
    private long pos;
    private float lineLength;
    private String source;
    private Font font;
    private FontRenderContext frc;
    private float wholeLength;
    private long charCount;
    private char[] chars;

    private String getNoRequire() {
        return ResManager.loadKDString((String)"\"\u4e0d\u5408\u8981\u6c42\u3002", (String)"TextLineBreaker_0", (String)"bos-print-core", (Object[])new Object[0]);
    }

    public TextLineBreaker(String source, Font font, FontRenderContext frc) {
        this(source, font, frc, 100);
    }

    public TextLineBreaker(String source, Font font, FontRenderContext frc, int lineLength) {
        this.frc = frc;
        this.source = source;
        this.pos = 0L;
        this.lineLength = lineLength;
        this.font = font;
        this.charCount = this.source.length();
        this.chars = this.source.toCharArray();
        this.wholeLength = (float)font.getStringBounds(this.source, this.frc).getWidth();
    }

    @Override
    public long getPos() {
        return this.pos;
    }

    @Override
    public void setLineLength(float length) {
        if (!(length > 0.0f)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u884c\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0\uff0c\u800c\u8f93\u5165\u7684%s\u3002", (String)"TextLineBreaker_1", (String)"bos-print-core", (Object[])new Object[0]), length + this.getNoRequire()));
        }
        this.lineLength = length;
    }

    @Override
    public SureRow nextRow(float length) {
        int endIndex;
        if (length < 0.0f) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u884c\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e0\uff0c\u800c\u8f93\u5165\u7684%s\u3002", (String)"TextLineBreaker_2", (String)"bos-print-core", (Object[])new Object[0]), length + this.getNoRequire()));
        }
        int rowCharNum = (int)((float)this.charCount * length / this.wholeLength);
        if (rowCharNum < 1) {
            rowCharNum = 1;
        }
        if ((endIndex = (int)(this.pos + (long)rowCharNum)) > this.source.length()) {
            endIndex = this.source.length();
        }
        if (this.isInWord(endIndex)) {
            endIndex = this.getPreWordBreak(endIndex);
        }
        endIndex = this.checkForWrap(endIndex);
        String strResult = this.source.substring((int)this.pos, endIndex);
        this.pos = endIndex;
        return new SureTextLine(strResult, this.font, this.frc);
    }

    public String nextRowString() {
        int rowCharNum = (int)this.charCount;
        int endIndex = (int)(this.pos + (long)rowCharNum);
        if (endIndex > this.source.length()) {
            endIndex = this.source.length();
        }
        if (this.isInWord(endIndex)) {
            endIndex = this.getPreWordBreak(endIndex);
        }
        endIndex = this.checkForWrap(endIndex);
        String strResult = this.source.substring((int)this.pos, endIndex);
        this.pos = endIndex;
        return strResult;
    }

    public String nextRowString(double length) {
        int endIndex;
        if (length < 0.0) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u884c\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e0\uff0c\u800c\u8f93\u5165\u7684%s\u3002", (String)"TextLineBreaker_2", (String)"bos-print-core", (Object[])new Object[0]), length + this.getNoRequire()));
        }
        int rowCharNum = (int)((double)this.charCount * length / (double)this.wholeLength);
        if (rowCharNum < 1) {
            rowCharNum = 1;
        }
        if ((endIndex = (int)(this.pos + (long)rowCharNum)) > this.source.length()) {
            endIndex = this.source.length();
        }
        if (this.isInWord(endIndex)) {
            endIndex = this.getPreWordBreak(endIndex);
        }
        endIndex = this.checkForWrap(endIndex);
        String strResult = this.source.substring((int)this.pos, endIndex);
        this.pos = endIndex;
        return strResult;
    }

    private int getPreWordBreak(int fromIndex) {
        int i = fromIndex - 1;
        while ((long)i > this.getPos()) {
            if (!this.isInWord(i)) {
                return i;
            }
            --i;
        }
        return fromIndex;
    }

    private int checkForWrap(int endIndex) {
        for (int i = (int)this.pos; i < endIndex; ++i) {
            if (this.chars[i] != '\n') continue;
            return i + 1;
        }
        return endIndex;
    }

    private boolean isInWord(int index) {
        if (index <= 0 || index >= this.source.length()) {
            return false;
        }
        char c = this.chars[index];
        if (c < '0' || c > '9' && c < '@' || c > 'z') {
            return false;
        }
        c = this.chars[index - 1];
        return c >= '0' && (c <= '9' || c >= '@') && c <= 'z';
    }

    @Override
    public SureRow nextRow() {
        return this.nextRow(this.lineLength);
    }

    @Override
    public boolean hasNext() {
        return this.pos < (long)this.source.length();
    }
}

