/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import java.awt.font.FontRenderContext;
import kd.bos.print.core.ctrl.kdf.util.render.layout.AbstractTruncRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.ISureRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureTextRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.TruncTextBreaker;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;

public class TruncRotationTextRender
extends AbstractTruncRender {
    @Override
    protected SureRow createShrinkRow(FontRenderContext frc) {
        int rotation = this.style.getRotation();
        double angel = Math.abs(rotation);
        angel = Math.PI * angel / 180.0;
        double bx = this.clipX;
        double by = this.clipY;
        if (this.style.getRotation() < 0) {
            by += this.clipHeight;
            by -= this.descent * Math.cos(angel);
            bx += this.ascent * Math.sin(angel);
        } else {
            bx += this.descent * Math.sin(angel);
            by += this.ascent * Math.cos(angel);
        }
        SureTextRow tl = new SureTextRow(this.as, this.style.getFont(), frc, this.style, 0.0f);
        tl.setAnchor(this.anchor);
        tl.setLinkUrl(this.linkUrl);
        tl.setX((float)bx);
        tl.setY((float)by);
        return tl;
    }

    @Override
    protected void drawNoShrink(FontRenderContext frc, LineWrapParam param) {
        TruncTextBreaker lbm = new TruncTextBreaker(this.as, frc, param);
        lbm.setStyle(this.style);
        lbm.setAnchor(this.anchor);
        lbm.setLinkUrl(this.linkUrl);
        int rotation = this.style.getRotation();
        double lineLong = this.getClipLineLength();
        double baseLength = this.getBaseLineLength();
        double angel = Math.abs(rotation);
        angel = Math.PI * angel / 180.0;
        ISureRow tlast = null;
        double bx = -1.0;
        double by = -1.0;
        double lx = -1.0;
        double ly = -1.0;
        if (rotation >= 0) {
            if (angel > Math.atan(this.clipHeight / this.clipWidth)) {
                bx = this.clipX + this.clipWidth - Math.sqrt(lineLong * lineLong - this.clipHeight * this.clipHeight);
                by = this.clipY;
                while (lbm.hasNext()) {
                    SureRow tl = lbm.nextRow((int)baseLength);
                    if (tl == null) continue;
                    if (tlast != null) {
                        bx = lx - ((tlast.getDescent() + tl.getAscent()) * (double)this.style.getLineSpaceB() + (double)this.style.getLinespacing()) / Math.sin(angel);
                        by = ly;
                    } else {
                        if ((bx -= tl.getAscent() * Math.sin(angel)) < this.clipX + tl.getDescent() * Math.sin(angel)) {
                            bx = this.clipX + tl.getDescent() * Math.sin(angel);
                        }
                        by += tl.getAscent() * Math.cos(angel);
                    }
                    tl.setX(bx);
                    tl.setY(by);
                    this.textArea.addRow(tl);
                    lx = bx;
                    ly = by;
                    tlast = tl;
                }
            } else {
                bx = this.clipX;
                by = this.clipY;
                while (lbm.hasNext()) {
                    SureRow tl = lbm.nextRow((int)baseLength);
                    if (tlast != null) {
                        bx = lx;
                        by = ly + ((tl.getAscent() + tlast.getDescent()) * (double)this.style.getLineSpaceB() + (double)this.style.getLinespacing()) * Math.cos(angel);
                    } else {
                        bx += tl.getDescent() * Math.sin(angel);
                        by += tl.getAscent() * Math.cos(angel);
                    }
                    tl.setX(bx);
                    tl.setY(by);
                    this.textArea.addRow(tl);
                    lx = bx;
                    ly = by;
                    tlast = tl;
                    tl = null;
                }
            }
        } else if (angel >= Math.atan(this.clipHeight / this.clipWidth)) {
            bx = this.clipX;
            by = this.clipY + this.clipHeight;
            while (lbm.hasNext()) {
                SureRow tl = lbm.nextRow((int)baseLength);
                if (tlast != null) {
                    bx = lx + ((tl.getAscent() + tlast.getDescent()) * (double)this.style.getLineSpaceB() + (double)this.style.getLinespacing()) / Math.sin(angel);
                    by = ly;
                } else {
                    bx += tl.getAscent() * Math.sin(angel);
                    by -= tl.getDescent() * Math.cos(angel);
                }
                tl.setX(bx);
                tl.setY(by);
                this.textArea.addRow(tl);
                lx = bx;
                ly = by;
                tlast = tl;
                tl = null;
            }
        } else {
            bx = this.clipX;
            by = this.clipY + Math.sqrt(lineLong * lineLong - this.clipWidth * this.clipWidth);
            while (lbm.hasNext()) {
                SureRow tl = lbm.nextRow((int)baseLength);
                if (tlast != null) {
                    by = ly + ((tl.getAscent() + tlast.getDescent()) * (double)this.style.getLineSpaceB() + (double)this.style.getLinespacing()) / Math.cos(angel);
                } else {
                    bx += tl.getAscent() * Math.sin(angel);
                    if ((by += tl.getAscent() * Math.cos(angel)) > this.clipY + this.clipHeight - tl.getDescent() * Math.cos(angel)) {
                        by = this.clipY + this.clipHeight - tl.getDescent() * Math.cos(angel);
                    }
                }
                tl.setX(bx);
                tl.setY(by);
                this.textArea.addRow(tl);
                lx = bx;
                ly = by;
                tlast = tl;
                tl = null;
            }
        }
    }

    @Override
    protected void applyHAlign() {
        block7: {
            double maxX;
            Styles.HorizontalAlignment hAlign;
            double rectAngel;
            double angel;
            block6: {
                angel = Math.PI * (double)this.style.getRotation() / 180.0;
                rectAngel = Math.atan(this.clipHeight / this.clipWidth);
                hAlign = this.style.getHorizontalAlign();
                if (hAlign == Styles.HorizontalAlignment.LEFT) {
                    return;
                }
                double minX = this.textArea.getMinX();
                maxX = this.textArea.getMaxX();
                double textWidth = maxX - minX;
                if (textWidth > this.clipWidth) {
                    return;
                }
                if (hAlign != Styles.HorizontalAlignment.CENTER) break block6;
                this.textArea.moveAllX((this.clipX + this.clipWidth - maxX - minX + this.clipX) / 2.0, hAlign);
                if (!(Math.abs(angel) < rectAngel)) break block7;
                for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                    double maxLineX = this.textArea.getLineMaxX(i);
                    double minLineX = this.textArea.getLineMinX(i);
                    this.textArea.moveLineX(i, (this.clipX + this.clipWidth - maxLineX - minLineX + this.clipX) / 2.0, hAlign);
                }
                break block7;
            }
            if (hAlign == Styles.HorizontalAlignment.RIGHT) {
                this.textArea.moveAllX(this.clipX + this.clipWidth - maxX, hAlign);
                if (Math.abs(angel) < rectAngel) {
                    for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                        double maxLineX = this.textArea.getLineMaxX(i);
                        this.textArea.moveLineX(i, this.clipX + this.clipWidth - maxLineX, hAlign);
                    }
                }
            }
        }
    }

    @Override
    protected void applyVAlign() {
        block7: {
            double maxY;
            Styles.VerticalAlignment vAlign;
            double rectAngel;
            double angel;
            block8: {
                double minY;
                block6: {
                    angel = Math.PI * (double)this.style.getRotation() / 180.0;
                    rectAngel = Math.atan(this.clipHeight / this.clipWidth);
                    vAlign = this.style.getVerticalAlign();
                    minY = this.textArea.getMinY();
                    maxY = this.textArea.getMaxY();
                    double textHeight = maxY - minY;
                    if (textHeight > this.clipHeight) {
                        vAlign = Styles.VerticalAlignment.TOP;
                    }
                    if (vAlign != Styles.VerticalAlignment.TOP) break block6;
                    this.textArea.moveAllY(this.clipY - minY);
                    if (!(Math.abs(angel) > rectAngel)) break block7;
                    for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                        double minLineY = this.textArea.getLineMinY(i);
                        this.textArea.moveLineY(i, this.clipY - minLineY);
                    }
                    break block7;
                }
                if (vAlign != Styles.VerticalAlignment.MIDDLE) break block8;
                this.textArea.moveAllY((this.clipY + this.clipHeight - maxY - minY + this.clipY) / 2.0);
                if (!(Math.abs(angel) > rectAngel)) break block7;
                for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                    double maxLineY = this.textArea.getLineMaxY(i);
                    double minLineY = this.textArea.getLineMinY(i);
                    this.textArea.moveLineY(i, (this.clipY + this.clipHeight - maxLineY - minLineY + this.clipY) / 2.0);
                }
                break block7;
            }
            if (vAlign == Styles.VerticalAlignment.BOTTOM) {
                this.textArea.moveAllY(this.clipY + this.clipHeight - maxY);
                if (Math.abs(angel) > rectAngel) {
                    for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                        double maxLineY = this.textArea.getLineMaxY(i);
                        this.textArea.moveLineY(i, this.clipY + this.clipHeight - maxLineY);
                    }
                }
            }
        }
    }

    @Override
    protected double getBaseLineLength() {
        if (!this.style.isWrapText() && !this.style.isShrinkText()) {
            return this.advance + 100.0;
        }
        int rotation = this.style.getRotation();
        double length = this.getClipLineLength();
        double angel = Math.abs(rotation);
        double rectAngel = Math.atan(this.clipHeight / this.clipWidth);
        length = (angel = Math.PI * angel / 180.0) > rectAngel ? (length -= (this.ascent + this.descent) / Math.tan(angel)) : (length -= (this.ascent + this.ascent) * Math.tan(angel));
        if (length <= 0.0) {
            length = this.getClipLineLength();
        }
        return length;
    }

    @Override
    protected double getClipLineLength() {
        double angel = Math.abs(this.style.getRotation());
        double length = Math.tan(angel = Math.PI * angel / 180.0) < this.clipHeight / this.clipWidth ? this.clipWidth / Math.cos(angel) : this.clipHeight / Math.sin(angel);
        return length;
    }
}

