/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import java.awt.font.FontRenderContext;
import java.text.AttributedString;
import java.util.Iterator;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureTextRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.TextLayoutBreaker;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.process.TruncWrapProcess;

public class TruncTextBreaker
extends TextLayoutBreaker {
    private final LineWrapParam param;
    private TruncWrapProcess process;
    private Iterator<TruncWrapProcess.TruncWrapInfo> wrapInfoIter;
    private Style style;
    private boolean anchor;
    private String linkUrl;

    public TruncTextBreaker(AttributedString text, FontRenderContext frc, LineWrapParam param) {
        super(text, frc);
        this.param = param;
    }

    @Override
    public SureRow nextRow(float length) {
        if (this.wrapInfoIter == null) {
            this.process = new TruncWrapProcess(this.param);
            this.wrapInfoIter = ((TruncWrapProcess.TruncWrapInfo)this.process.process(this.param.isWordFlex())).iterator();
        }
        TruncWrapProcess.TruncWrapInfo wrapInfo = this.wrapInfoIter.next();
        float flexOffset = wrapInfo.getFlexOffset();
        int endIndex = wrapInfo.getSplitPosition();
        if (endIndex <= this.pos) {
            endIndex = this.pos + 1;
        }
        AttributedString as = new AttributedString(this.text.getIterator(), this.pos, endIndex);
        this.pos = endIndex;
        SureTextRow result = new SureTextRow(as, this.param.getStyle().getFont(), this.frc, this.style, flexOffset);
        result.setAnchor(this.anchor);
        result.setLinkUrl(this.linkUrl);
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.wrapInfoIter != null ? this.wrapInfoIter.hasNext() : super.hasNext();
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setAnchor(boolean anchor) {
        this.anchor = anchor;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }
}

