/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.layout;

import java.awt.font.FontRenderContext;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.kdf.util.render.layout.AbstractTruncRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.SureTextRow;
import kd.bos.print.core.ctrl.kdf.util.render.layout.TruncTextBreaker;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.model.PrintTplVersion;

public class TruncTextRender
extends AbstractTruncRender {
    @Override
    protected void applyHAlign() {
        block5: {
            double maxX;
            Styles.HorizontalAlignment hAlign;
            block4: {
                hAlign = this.style.getHorizontalAlign();
                if (hAlign == Styles.HorizontalAlignment.LEFT) {
                    return;
                }
                double minX = this.textArea.getMinX();
                maxX = this.textArea.getMaxX();
                double textWidth = maxX - minX;
                if (textWidth > this.clipWidth) {
                    return;
                }
                if (hAlign != Styles.HorizontalAlignment.CENTER) break block4;
                this.textArea.moveAllX((this.clipX + this.clipWidth - maxX - minX + this.clipX) / 2.0, hAlign);
                for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                    double maxLineX = this.textArea.getLineMaxX(i);
                    double minLineX = this.textArea.getLineMinX(i);
                    this.textArea.moveLineX(i, (this.clipX + this.clipWidth - maxLineX - minLineX + this.clipX) / 2.0, hAlign);
                }
                break block5;
            }
            if (hAlign != Styles.HorizontalAlignment.RIGHT) break block5;
            this.textArea.moveAllX(this.clipX + this.clipWidth - maxX, hAlign);
            for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                double maxLineX = this.textArea.getLineMaxX(i);
                this.textArea.moveLineX(i, this.clipX + this.clipWidth - maxLineX, hAlign);
            }
        }
    }

    @Override
    protected void applyVAlign() {
        Styles.VerticalAlignment vAlign = this.style.getVerticalAlign();
        double minY = this.textArea.getMinY();
        double maxY = this.textArea.getMaxY();
        double textHeight = maxY - minY;
        String tplVer = ExecuteContext.get().getTplVer();
        if (textHeight > this.clipHeight && tplVer != null && tplVer.compareTo(PrintTplVersion.V_6_0_2.getTplVer()) >= 0) {
            vAlign = Styles.VerticalAlignment.TOP;
        }
        if (vAlign == Styles.VerticalAlignment.TOP) {
            this.textArea.moveAllY(this.clipY - minY);
        } else if (vAlign == Styles.VerticalAlignment.MIDDLE) {
            this.textArea.moveAllY((this.clipY + this.clipHeight - maxY - minY + this.clipY) / 2.0);
        } else if (vAlign == Styles.VerticalAlignment.BOTTOM) {
            this.textArea.moveAllY(this.clipY + this.clipHeight - maxY);
        }
    }

    @Override
    protected SureRow createShrinkRow(FontRenderContext frc) {
        SureTextRow tl = new SureTextRow(this.as, this.style.getFont(), frc, this.style, 0.0f);
        tl.setX((float)this.clipX);
        tl.setY((double)((float)this.clipY) + this.ascent);
        tl.setAnchor(this.anchor);
        tl.setLinkUrl(this.linkUrl);
        return tl;
    }

    @Override
    protected double getBaseLineLength() {
        if (!this.style.isWrapText() && !this.style.isShrinkText()) {
            return this.advance + 100.0;
        }
        return this.getClipLineLength();
    }

    @Override
    protected double getClipLineLength() {
        return this.clipWidth;
    }

    @Override
    protected void drawNoShrink(FontRenderContext frc, LineWrapParam param) {
        TruncTextBreaker lbm = new TruncTextBreaker(this.as, frc, param);
        lbm.setStyle(this.style);
        lbm.setAnchor(this.anchor);
        lbm.setLinkUrl(this.linkUrl);
        int baseLength = (int)this.getBaseLineLength();
        float lineSpacing = this.style.getLinespacing();
        float lineHeightB = this.style.getLineSpaceB();
        boolean firstRow = true;
        double currentY = this.clipY;
        double prevY = this.clipY;
        while (lbm.hasNext()) {
            SureRow tl = lbm.nextRow(baseLength);
            currentY = firstRow ? (currentY += tl.getAscent() + (tl.getAscent() + tl.getDescent()) * (double)(lineHeightB - 1.0f) / 2.0) : prevY + ((tl.getAscent() + tl.getDescent()) * (double)lineHeightB + (double)lineSpacing);
            tl.setX(this.clipX);
            tl.setY(currentY);
            this.textArea.addRow(tl);
            prevY = currentY;
            firstRow = false;
        }
    }
}

