/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.r1print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import kd.bos.print.core.ctrl.kdf.util.render.NoteTextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.ITextRender;
import kd.bos.print.core.ctrl.kdf.util.render.layout.param.TextRenderParam;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.DivideModel;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.ICurrencySupport;
import kd.bos.print.core.ctrl.kdf.util.render.r1print.IDivideCharacterSupport;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.execute.ExecuteWorkFactory;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapRule;

public class DivideCharacterRenderer {
    private int charNums = 0;
    private boolean isDrawCharBorderField = true;

    public static DivideCharacterRenderer shareInstance() {
        return ExecuteWorkFactory.get().getDivideCharacterRenderer();
    }

    public static DivideCharacterRenderer shareInstance(int dividedCharNums, boolean drawBorder) {
        DivideCharacterRenderer renderer = DivideCharacterRenderer.shareInstance();
        renderer.setDividedCharNums(dividedCharNums);
        renderer.setDrawCharBorder(drawBorder);
        return renderer;
    }

    public boolean isDivided() {
        return this.charNums > 0;
    }

    public void setDividedCharNums(int nums) {
        this.charNums = nums;
    }

    public int getDividedCharNums() {
        return this.charNums;
    }

    public void setDrawCharBorder(boolean isDrawBorder) {
        this.isDrawCharBorderField = isDrawBorder;
    }

    public boolean isDrawCharBorder() {
        return this.isDrawCharBorderField;
    }

    public void draw(Graphics g, Rectangle rect, String text, Style style, Object targetObj) {
        int docIdx;
        NoteTextRender ctr = NoteTextRender.shareInstance();
        if (!this.isDivided()) {
            ctr.draw(g, rect, text, style);
            return;
        }
        if (targetObj instanceof ICurrencySupport && text.length() > 0 && !text.endsWith(" ") && this.isNumber(text.charAt(text.length() - 1)) && ((ICurrencySupport)targetObj).isCurrencyColumnSupport() && (docIdx = text.indexOf(46)) != -1) {
            String integer = text.substring(0, docIdx);
            String decimal = text.substring(docIdx + 1);
            text = integer + decimal;
        }
        int textLength = text.length();
        int divideNums = this.getDividedCharNums();
        int startCell = 0;
        int startCharIndex = 0;
        int decimalLineIndex = -1;
        if (style.getHorizontalAlign() == Styles.HorizontalAlignment.LEFT) {
            startCell = 0;
            if (divideNums >= textLength) {
                decimalLineIndex = textLength - 2;
            }
        } else if (style.getHorizontalAlign() == Styles.HorizontalAlignment.RIGHT) {
            startCell = divideNums - textLength;
            decimalLineIndex = divideNums - 2;
        } else {
            startCell = (divideNums - textLength) / 2;
            if (divideNums > textLength) {
                decimalLineIndex = divideNums - startCell - 3;
            } else if (divideNums == textLength) {
                decimalLineIndex = divideNums - 2;
            }
        }
        boolean isLeftOutSide = false;
        if (startCell < 0) {
            startCharIndex = -startCell;
            startCell = 0;
            if (targetObj instanceof ICurrencySupport && ((ICurrencySupport)targetObj).isCurrencyColumnSupport()) {
                isLeftOutSide = false;
                for (int i = 0; i < startCharIndex; ++i) {
                    if (!this.isNumber(text.charAt(i))) continue;
                    isLeftOutSide = true;
                    break;
                }
            } else {
                isLeftOutSide = true;
            }
        }
        StyleAttributes sa = Styles.getSA(style);
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        Style charStyle = Styles.getStyle(sa);
        Graphics2D gg = (Graphics2D)g;
        int charIndex = startCharIndex;
        float cellWidth = (float)(rect.width + 1) / (float)divideNums;
        DivideModel model = ((IDivideCharacterSupport)targetObj).getDivideModel();
        for (int i = 0; i < divideNums; ++i) {
            Rectangle charRect = new Rectangle(rect);
            double x = rect.getX() + (double)(cellWidth * (float)i);
            charRect.x = (int)x;
            charRect.width = (int)cellWidth + 1;
            if (model.isShowLine() && i > 0) {
                Line2D.Double line = new Line2D.Double(x, rect.y - 2, x, rect.y + rect.height + 1);
                this.drawLine(gg, i, decimalLineIndex, model, line);
            }
            if (i < startCell || charIndex >= textLength) continue;
            String aChar = String.valueOf(text.charAt(charIndex++));
            if (i == startCell && isLeftOutSide || i == divideNums - 1 && charIndex < textLength) {
                aChar = "...";
            }
            LineWrapParam param = new LineWrapParam.Builder(aChar, LineWrapRule.ForceLine).style(charStyle).minW(charRect.width).maxW(charRect.width).build();
            TextRenderParam renderParam = new TextRenderParam((Graphics2D)g, aChar, charRect, param, charStyle, false);
            ITextRender.createRender(targetObj, charStyle).drawText(renderParam);
        }
    }

    private void drawLine(Graphics2D g2, int nowIndex, int decimalIndex, DivideModel model, Line2D.Double line) {
        StyleAttributes ssa = model.getSSA();
        Color tempColor = g2.getColor();
        Stroke stroke = g2.getStroke();
        int which = (decimalIndex - nowIndex) % 3;
        if (decimalIndex > nowIndex && which == 0) {
            g2.setStroke(model.getThousandStroke());
            g2.setColor(ssa.getBorderColor(model.showThousandLine()));
            g2.draw(line);
            g2.setColor(tempColor);
            g2.setStroke(stroke);
            return;
        }
        if (decimalIndex == nowIndex) {
            g2.setStroke(model.getDecimalStroke());
            g2.setColor(ssa.getBorderColor(model.showDecimalLine()));
            g2.draw(line);
            g2.setColor(tempColor);
            g2.setStroke(stroke);
            return;
        }
        g2.setStroke(model.getOtherStroke());
        g2.setColor(ssa.getBorderColor(model.showOtherLine()));
        g2.draw(line);
        g2.setColor(tempColor);
        g2.setStroke(stroke);
    }

    private boolean isNumber(char c) {
        return '0' <= c && c <= '9';
    }
}

