/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.render.r1print;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.PenStyle;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;

public class DivideModel {
    private StyleAttributes _diVideModified;
    private boolean _isShowLine = false;
    private static float pixePerLom = (float)KDToolkit.getCurrentDpi() / 254.3f;

    public boolean isShowLine() {
        return this._isShowLine;
    }

    public void setShowLine(boolean isShowLine) {
        this._isShowLine = isShowLine;
    }

    public Styles.Position showThousandLine() {
        return Styles.Position.LEFT;
    }

    public Stroke getThousandStroke() {
        return this.getStroke(Styles.Position.LEFT);
    }

    public Styles.Position showDecimalLine() {
        return Styles.Position.RIGHT;
    }

    public Stroke getDecimalStroke() {
        return this.getStroke(Styles.Position.RIGHT);
    }

    public Styles.Position showOtherLine() {
        return Styles.Position.TOP;
    }

    public Stroke getOtherStroke() {
        return this.getStroke(Styles.Position.TOP);
    }

    public StyleAttributes getSSA() {
        if (this._diVideModified == null) {
            this._diVideModified = Styles.getEmptySA();
            this._diVideModified.setBorder(this.showThousandLine(), Styles.getDefaultSSA());
            this._diVideModified.setBorderLineStyle(this.showThousandLine(), LineStyle.DOUBLE_LINE_A);
            this._diVideModified.setBorder(this.showDecimalLine(), Styles.getDefaultSSA());
            this._diVideModified.setBorderLineStyle(this.showDecimalLine(), LineStyle.DOUBLE_LINE_A);
            this._diVideModified.setBorder(this.showOtherLine(), Styles.getDefaultSSA());
        }
        return this._diVideModified;
    }

    public void setLinesStyle(Styles.Position position, PenStyle penStyle, LineStyle lineStyle, Color color) {
        this.getSSA().setBorderLineStyle(position, lineStyle);
        this.getSSA().setBorderPenStyle(position, penStyle);
        this.getSSA().setBorderColor(position, color);
    }

    public void upDataDivideLine(StyleAttributes ssa) {
        this.getSSA().setBorder(ssa);
    }

    private float getLineWidth(LineStyle penStyle) {
        if (penStyle == LineStyle.DOUBLE_LINE_A || penStyle == LineStyle.DOUBLE_LINE_B) {
            return 2.0f * pixePerLom;
        }
        if (penStyle == LineStyle.TRIGRAM_SOLID_LINE) {
            return 3.0f * pixePerLom;
        }
        if (penStyle == LineStyle.WIDTH4) {
            return 4.0f * pixePerLom;
        }
        if (penStyle == LineStyle.WIDTH5) {
            return 5.0f * pixePerLom;
        }
        if (penStyle == LineStyle.WIDTH6) {
            return 6.0f * pixePerLom;
        }
        if (penStyle == LineStyle.WIDTH7) {
            return 7.0f * pixePerLom;
        }
        if (penStyle == LineStyle.WIDTH8) {
            return 8.0f * pixePerLom;
        }
        if (penStyle == LineStyle.WIDTH9) {
            return 9.0f * pixePerLom;
        }
        if (penStyle == LineStyle.WIDTH10) {
            return 10.0f * pixePerLom;
        }
        return pixePerLom;
    }

    private Stroke getStroke(Styles.Position position) {
        float[] dash = this.getSSA().getBorderPenStyle(position).getDash();
        if (dash == null || dash.length == 0) {
            return new BasicStroke(this.getLineWidth(this.getSSA().getBorderLineStyle(position)));
        }
        return new BasicStroke(this.getLineWidth(this.getSSA().getBorderLineStyle(position)), 0, 0, 10.0f, dash, 0.0f);
    }
}

