/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.style;

import java.util.HashMap;

public class LineStyle {
    private static final HashMap<String, LineStyle> _lines = new HashMap();
    private static final int OFFSETB = 7;
    private static final int OFFSETC = 14;
    private static final int OFFSETAL = 15;
    private static final int OFFSETBL = 18;
    public static final LineStyle TRIGRAM_HOLLOW_LINE = LineStyle.createLineStyle("TrigramHollow", LineStyle.createBitType(1, 1, 0), true);
    public static final LineStyle TRIGRAM_SOLID_LINE = LineStyle.createLineStyle("TrigramSolid", LineStyle.createBitType(1, 1, 1), true);
    public static final LineStyle DOUBLE_LINE_A = LineStyle.createLineStyle("DoubleA", LineStyle.createBitType(1, 0, 1), true);
    public static final LineStyle DOUBLE_LINE_B = LineStyle.createLineStyle("DoubleB", LineStyle.createBitType(0, 1, 1), true);
    public static final LineStyle SINGLE_LINE = LineStyle.createLineStyle("Single", LineStyle.createBitType(0, 0, 1), true);
    public static final LineStyle SINGLE_LINE_HALF = LineStyle.createLineStyle("Single0.5", LineStyle.createBitType(0, 0, 1), true);
    public static final LineStyle NULL_LINE = LineStyle.createLineStyle("NullLine", LineStyle.createBitType(0, 0, 0), true);
    public static final LineStyle WIDTH4 = LineStyle.createLineStyle("Width4", LineStyle.createBitType(3, 1, 1), true);
    public static final LineStyle WIDTH5 = LineStyle.createLineStyle("Width5", LineStyle.createBitType(3, 3, 1), true);
    public static final LineStyle WIDTH6 = LineStyle.createLineStyle("Width6", LineStyle.createBitType(7, 3, 1), true);
    public static final LineStyle WIDTH7 = LineStyle.createLineStyle("Width7", LineStyle.createBitType(7, 7, 1), true);
    public static final LineStyle WIDTH8 = LineStyle.createLineStyle("Width8", LineStyle.createBitType(15, 7, 1), true);
    public static final LineStyle WIDTH9 = LineStyle.createLineStyle("Width9", LineStyle.createBitType(15, 15, 1), true);
    public static final LineStyle WIDTH10 = LineStyle.createLineStyle("Width10", LineStyle.createBitType(31, 15, 1), true);
    private static final LineStyle[] aWidthLS = new LineStyle[]{NULL_LINE, SINGLE_LINE_HALF, DOUBLE_LINE_A, TRIGRAM_SOLID_LINE, WIDTH4, WIDTH5, WIDTH6, WIDTH7, WIDTH8, WIDTH9, WIDTH10};
    private String _name;
    private int _bits;
    private boolean _isSystem;

    public static LineStyle createLineStyle(String name, int bits, boolean isSystem) {
        if (_lines.containsKey(name)) {
            return _lines.get(name);
        }
        LineStyle ls = new LineStyle(name, bits, isSystem);
        _lines.put(name.toLowerCase(), ls);
        return ls;
    }

    public static LineStyle getLineStyle(String name) {
        return _lines.get(name.toLowerCase());
    }

    public static LineStyle getLineStyle(int width) {
        return (width = Math.abs(width)) > 10 ? WIDTH10 : aWidthLS[width];
    }

    public static LineStyle getLineStyleByBits(int bits) {
        for (int i = aWidthLS.length - 1; i >= 0; --i) {
            if (aWidthLS[i].getBits() != bits) continue;
            return aWidthLS[i];
        }
        if (DOUBLE_LINE_B.getBits() == bits) {
            return DOUBLE_LINE_B;
        }
        if (TRIGRAM_HOLLOW_LINE.getBits() == bits) {
            return TRIGRAM_HOLLOW_LINE;
        }
        return null;
    }

    public static boolean isNull(LineStyle ls) {
        return ls == null || ls == NULL_LINE;
    }

    public static int createBitType(int aside, int bside, int center) {
        int alen = 0;
        int blen = 0;
        int copy = aside &= 0x7F;
        if (copy != 0) {
            alen = 1;
            while ((copy >>= 1) != 0) {
                ++alen;
            }
        }
        if ((copy = (bside &= 0x7F)) != 0) {
            blen = 1;
            while ((copy >>= 1) != 0) {
                ++blen;
            }
        }
        return blen << 18 | alen << 15 | (center &= 1) << 14 | bside << 7 | aside;
    }

    private LineStyle(String name, int bits, boolean isSystem) {
        this._name = name;
        this._bits = bits;
        this._isSystem = isSystem;
    }

    public String toString() {
        return this._name;
    }

    public int getBits() {
        return this._bits;
    }

    public boolean isSystem() {
        return this._isSystem;
    }

    public String getName() {
        return this._name;
    }

    public int getWeightA() {
        return this._bits >> 15 & 7;
    }

    public int getWeightB() {
        return this._bits >> 18 & 7;
    }

    public boolean isBaseBorder() {
        return this._bits == 16384;
    }

    public boolean isNullBorder() {
        return this._bits == 0;
    }

    public boolean getBit(boolean isA, int index) {
        int side = isA ? this._bits & 0x7F : this._bits >> 7 & 0x7F;
        return (side & 1 << (index &= 7)) > 0;
    }

    public boolean isFillCenterLine() {
        return (this._bits & 0x4000) != 0;
    }

    public int getWidth() {
        int width = this.getWeightA() + this.getWeightB();
        if (width == 0) {
            if (this.isFillCenterLine()) {
                width = 1;
            }
        } else {
            ++width;
        }
        return width;
    }

    public LineStyle getReverseStyle() {
        int copyBits = this._bits;
        int aside = copyBits & 0x7F;
        int bside = copyBits >> 7 & 0x7F;
        int center = copyBits >> 14 & 1;
        return LineStyle.createLineStyle(this._name, LineStyle.createBitType(bside, aside, center), this._isSystem);
    }
}

