/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.style;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PenStyle {
    private static final HashMap _pens = new HashMap();
    public static final PenStyle PS_SOLID = PenStyle.createPenStyle("Solid", new float[0], true);
    public static final PenStyle PS_CONTINUOUS = PenStyle.createPenStyle("Continuous", new float[]{1.0f}, true);
    public static final PenStyle PS_DOT = PenStyle.createPenStyle("Dotted", new float[]{2.0f}, true);
    public static final PenStyle PS_DASHDOTDOT = PenStyle.createPenStyle("DashDotDot", new float[]{3.0f, 3.0f, 9.0f, 3.0f, 3.0f, 3.0f}, true);
    public static final PenStyle PS_DASHDOT = PenStyle.createPenStyle("DashDot", new float[]{3.0f, 3.0f, 9.0f, 3.0f}, true);
    public static final PenStyle PS_DASH = PenStyle.createPenStyle("Dashed", new float[]{3.0f, 1.0f}, true);
    private String _name;
    private float[] _dash;
    private boolean _isSystem;
    private Map<Float, Stroke> strokeCache;
    private Stroke _baseStroke;

    public static PenStyle createPenStyle(String name, float[] dash, boolean isSystem) {
        PenStyle ps;
        Iterator i = _pens.entrySet().iterator();
        while (i.hasNext()) {
            ps = (PenStyle)i.next().getValue();
            if (!PenStyle.equals(ps.getDash(), dash)) continue;
            return ps;
        }
        if (name == null) {
            name = "custom";
        }
        if (_pens.containsKey(name)) {
            int i2 = 0;
            String tmpName = name + i2;
            while (_pens.containsKey(tmpName)) {
                tmpName = name + ++i2;
            }
            name = tmpName;
        }
        ps = new PenStyle(name, dash, isSystem);
        _pens.put(name.toLowerCase(), ps);
        return ps;
    }

    private static boolean equals(float[] a, float[] a2) {
        if (a.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static PenStyle getPenStyle(String name) {
        return (PenStyle)_pens.get(name.toLowerCase());
    }

    public PenStyle(String name, float[] dash, boolean isSystem) {
        this._name = name;
        this._dash = dash;
        this._isSystem = isSystem;
        this.strokeCache = new HashMap<Float, Stroke>();
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public float[] getDash() {
        return this._dash;
    }

    public String getDashString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._dash.length; ++i) {
            sb.append(this._dash[i]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public boolean isSystem() {
        return this._isSystem;
    }

    public Stroke getStroke(float width) {
        if (this.strokeCache.containsKey(Float.valueOf(width))) {
            return this.strokeCache.get(Float.valueOf(width));
        }
        BasicStroke stroke = this == PS_SOLID || this._dash == null || this._dash.length == 0 ? new BasicStroke(width) : new BasicStroke(width, 0, 0, 10.0f, this._dash, 0.0f);
        this.strokeCache.put(Float.valueOf(width), stroke);
        return stroke;
    }

    public Stroke getBaseStroke() {
        if (this._baseStroke == null) {
            this._baseStroke = this == PS_SOLID || this._dash == null || this._dash.length == 0 ? new BasicStroke() : new BasicStroke(1.0f, 0, 0, 10.0f, this._dash, 0.0f);
        }
        return this._baseStroke;
    }
}

