/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.style;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Pattern;
import kd.bos.print.core.ctrl.kdf.util.style.PenStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;

public class ShareStyleAttributes {
    public static final Unknown UNKOWN_VALUE = new Unknown();
    protected static int _index;
    public static final int START;
    public static final int FONT_NAME;
    public static final int FONT_SIZE;
    public static final int FONT_COLOR;
    public static final int FONT_BOLD;
    public static final int FONT_WEIGHT;
    public static final int FONT_ITALIC;
    public static final int FONT_UNDERLINE;
    public static final int FONT_STRIKETHROUGH;
    public static final int BACKGROUND_COLOR;
    public static final int PATTERN;
    public static final int PATTERN_COLOR;
    public static final int NUMBER_FORMAT;
    public static final int PROTECTION_LOCKED;
    public static final int PROTECTION_HIDDED;
    public static final int HORIZONTAL_ALIGN;
    public static final int VERTICAL_ALIGN;
    public static final int WRAP_TEXT;
    public static final int SHRINK_TEXT;
    public static final int ROTATION;
    public static final int LINE_SPACING;
    public static final int LINE_SPACING_TYPE;
    public static final int WORD_SPACING;
    public static final int PADDING;
    public static final int AUTO_CLIP;
    public static final int BEFORE_BORDER;
    public static final int BORDER_START;
    public static final int BORDER_LEFT_LINESTYLE;
    public static final int BORDER_LEFT_PENSTYLE;
    public static final int BORDER_LEFT_COLOR;
    public static final int BORDER_TOP_LINESTYLE;
    public static final int BORDER_TOP_PENSTYLE;
    public static final int BORDER_TOP_COLOR;
    public static final int BORDER_RIGHT_LINESTYLE;
    public static final int BORDER_RIGHT_PENSTYLE;
    public static final int BORDER_RIGHT_COLOR;
    public static final int BORDER_BOTTOM_LINESTYLE;
    public static final int BORDER_BOTTOM_PENSTYLE;
    public static final int BORDER_BOTTOM_COLOR;
    public static final int BORDER_DIAGONALLEFT_LINESTYLE;
    public static final int BORDER_DIAGONALLEFT_PENSTYLE;
    public static final int BORDER_DIAGONALLEFT_COLOR;
    public static final int BORDER_DIAGONALRIGHT_LINESTYLE;
    public static final int BORDER_DIAGONALRIGHT_PENSTYLE;
    public static final int BORDER_DIAGONALRIGHT_COLOR;
    public static final int AUTO_INDENTATION;
    public static final int ATTRS_COUNT;
    protected static final long _bitsAll;
    protected static final long _topBorderBits;
    protected static final long _leftBorderBits;
    protected static final long _bottomBorderBits;
    protected static final long _rightBorderBits;
    protected static final long _dleftBorderBits;
    protected static final long _drightBorderBits;
    protected static final long _allLineStyleBits;
    protected static final long _allBorderBits;
    protected static final long _outerBorderBits;
    protected static final long _fontBits;
    protected static final long _interiorBits;
    protected static final long _alignmentBits;
    protected static final long _protectionBits;
    private static final HashMap _name2Index;
    private static final String[] _attrNames;
    protected Object[] _attrs = new Object[ATTRS_COUNT];
    protected long _attrsBits;
    protected long _dirtyBits;
    private int _uid;
    protected int _hashCode = -1;

    private static void buildName(String name, int index) {
        Integer idx = index;
        _name2Index.put(name, idx);
        ShareStyleAttributes._attrNames[index] = name;
    }

    public static String getAttributeName(int index) {
        return index >= ATTRS_COUNT ? "" : _attrNames[index];
    }

    public static long bits(int index) {
        return 1L << index;
    }

    public static long getBitsExceptOuterBorder() {
        return _bitsAll & ((_topBorderBits | _leftBorderBits | _bottomBorderBits | _rightBorderBits) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long getAllLineStyleBits() {
        return _allLineStyleBits;
    }

    public static long getAllBits() {
        return _bitsAll;
    }

    public static long getAllBits(int count) {
        return Long.MAX_VALUE >> 64 - count - 1;
    }

    public static int getIndexCount(long bits) {
        int index = 0;
        while (bits != 0L) {
            ++index;
            bits >>= 1;
        }
        return index;
    }

    public static long getAllBorderBits() {
        return _allBorderBits;
    }

    public static long getOuterBorderBits() {
        return _outerBorderBits;
    }

    public static long getAllInnerBorderBits() {
        return ShareStyleAttributes.getBorderBits(Styles.Position.INNER_H) | ShareStyleAttributes.getBorderBits(Styles.Position.INNER_V);
    }

    public static long getBorderBits(Styles.Position pos) {
        long borderBits = 0L;
        switch (pos.getIndex()) {
            case 2: {
                borderBits = _rightBorderBits;
                break;
            }
            case 3: {
                borderBits = _bottomBorderBits;
                break;
            }
            case 0: {
                borderBits = _leftBorderBits;
                break;
            }
            case 1: {
                borderBits = _topBorderBits;
                break;
            }
            case 4: {
                borderBits = _dleftBorderBits;
                break;
            }
            default: {
                borderBits = _drightBorderBits;
            }
        }
        return borderBits;
    }

    public static int getBorderPenStyleIndex(Styles.Position pos) {
        int index;
        switch (pos.getIndex()) {
            case 0: {
                index = BORDER_LEFT_PENSTYLE;
                break;
            }
            case 1: {
                index = BORDER_TOP_PENSTYLE;
                break;
            }
            case 2: {
                index = BORDER_RIGHT_PENSTYLE;
                break;
            }
            case 3: {
                index = BORDER_BOTTOM_PENSTYLE;
                break;
            }
            case 5: {
                index = BORDER_DIAGONALRIGHT_PENSTYLE;
                break;
            }
            default: {
                index = BORDER_DIAGONALLEFT_PENSTYLE;
            }
        }
        return index;
    }

    public static int getBorderLineStyleIndex(Styles.Position pos) {
        int index;
        switch (pos.getIndex()) {
            case 0: {
                index = BORDER_LEFT_LINESTYLE;
                break;
            }
            case 1: {
                index = BORDER_TOP_LINESTYLE;
                break;
            }
            case 2: {
                index = BORDER_RIGHT_LINESTYLE;
                break;
            }
            case 3: {
                index = BORDER_BOTTOM_LINESTYLE;
                break;
            }
            case 5: {
                index = BORDER_DIAGONALRIGHT_LINESTYLE;
                break;
            }
            default: {
                index = BORDER_DIAGONALLEFT_LINESTYLE;
            }
        }
        return index;
    }

    public static int getBorderColorIndex(Styles.Position pos) {
        int index;
        switch (pos.getIndex()) {
            case 0: {
                index = BORDER_LEFT_COLOR;
                break;
            }
            case 1: {
                index = BORDER_TOP_COLOR;
                break;
            }
            case 2: {
                index = BORDER_RIGHT_COLOR;
                break;
            }
            case 3: {
                index = BORDER_BOTTOM_COLOR;
                break;
            }
            case 5: {
                index = BORDER_DIAGONALRIGHT_COLOR;
                break;
            }
            default: {
                index = BORDER_DIAGONALLEFT_COLOR;
            }
        }
        return index;
    }

    public static boolean isEmptySSA(ShareStyleAttributes ssa) {
        return ssa == null || ssa.isEmpty();
    }

    protected ShareStyleAttributes() {
    }

    public ShareStyleAttributes(ShareStyleAttributes ssa) {
        this();
        if (ssa == null) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(ssa._attrs, 0, this._attrs, 0, this._attrs.length);
        this._attrsBits = ssa._attrsBits;
        this._dirtyBits = ssa._dirtyBits;
    }

    public int getIndex(String id) {
        Object obj = _name2Index.get(id);
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        return (Integer)obj;
    }

    public boolean isDirty() {
        return this._dirtyBits != 0L;
    }

    public void clearDirtyFlag() {
        this._dirtyBits = 0L;
    }

    public void clearDirtyFlag(long index) {
        long bit = 1L << (int)index;
        if ((this._dirtyBits & bit) != 0L) {
            this._dirtyBits &= bit ^ 0xFFFFFFFFFFFFFFFFL;
            this._hashCode = -1;
        }
    }

    public void setDirty(long bit) {
        this._dirtyBits |= bit;
        this._hashCode = -1;
    }

    public boolean isDirtyAttribute(int index) {
        return (this._dirtyBits & 1L << index) != 0L;
    }

    public boolean isDirtyBorder(Styles.Position pos) {
        long borderBits = ShareStyleAttributes.getBorderBits(pos);
        return (this._dirtyBits & borderBits) != 0L;
    }

    public boolean isDirtyBorder() {
        return (this._dirtyBits & _allBorderBits) != 0L;
    }

    public int getFirstDirtyIndex() {
        if (this._dirtyBits == 0L) {
            return 0;
        }
        int i = 0;
        long bits = this._dirtyBits;
        while ((bits & 1L) != 1L) {
            ++i;
            bits >>= 1;
        }
        return i;
    }

    public long getAttrsBits() {
        return this._attrsBits;
    }

    public long getAllDirtyBits() {
        return this._dirtyBits;
    }

    public boolean hasAttributes(int index) {
        if (index >= ATTRS_COUNT || index < 0) {
            throw new IllegalArgumentException();
        }
        Object obj = this._attrs[index];
        return obj != null && obj != UNKOWN_VALUE;
    }

    public boolean isFull() {
        return _bitsAll == this._attrsBits;
    }

    public boolean isFull(long bits) {
        return bits == this._attrsBits;
    }

    public boolean isEmpty() {
        return this._attrsBits == 0L;
    }

    public int count() {
        return this._attrs.length;
    }

    public int getUID() {
        return this._uid;
    }

    public void setUID(int uid) {
        this._uid = uid;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            this._hashCode = 0;
            for (int i = 0; i < this._attrs.length; ++i) {
                Object obj = this._attrs[i];
                if (obj == null) continue;
                this._hashCode = 37 * this._hashCode + obj.hashCode();
            }
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ShareStyleAttributes) {
            ShareStyleAttributes cmp = (ShareStyleAttributes)obj;
            if (this._attrsBits != cmp._attrsBits) {
                return false;
            }
            Object[] as = cmp._attrs;
            for (int i = 0; i < this._attrs.length; ++i) {
                Object a = this._attrs[i];
                Object a2 = as[i];
                if (!(a == null ? a2 != null : !a.equals(a2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isFull()) {
            sb.append("[Full]");
        } else if (this.isEmpty()) {
            sb.append("[Empty]");
        }
        this.appendBorderName(sb, Styles.Position.LEFT);
        this.appendBorderName(sb, Styles.Position.TOP);
        this.appendBorderName(sb, Styles.Position.RIGHT);
        this.appendBorderName(sb, Styles.Position.BOTTOM);
        return sb.toString();
    }

    private void appendBorderName(StringBuilder sb, Styles.Position pos) {
        if (this.hasBorderAttributes(pos)) {
            sb.append(" [");
            sb.append(pos.toString().substring(0, 1).toUpperCase());
            sb.append("-");
            int index = ShareStyleAttributes.getBorderLineStyleIndex(pos);
            if (this.hasAttributes(index)) {
                sb.append(this.get(index).toString());
                sb.append("|");
            }
            if (this.hasAttributes(index = ShareStyleAttributes.getBorderPenStyleIndex(pos))) {
                sb.append(this.get(index).toString());
                sb.append("|");
            }
            if (this.hasAttributes(index = ShareStyleAttributes.getBorderColorIndex(pos))) {
                sb.append(Integer.toHexString(((Color)this.get(index)).getRGB()).toUpperCase().substring(2));
            }
            sb.append(']');
        }
    }

    public Object get(int index) {
        if (index >= ATTRS_COUNT || index < 0) {
            throw new IllegalArgumentException();
        }
        return this._attrs[index];
    }

    Object _get(int index) {
        return this._attrs[index];
    }

    public boolean isUnsureValue(int index) {
        Object value = this.get(index);
        return value == null ? false : value == UNKOWN_VALUE;
    }

    public long crashBits(ShareStyleAttributes ssa, boolean crashDirty) {
        if (ssa == null || ssa.isEmpty()) {
            return 0L;
        }
        long crashBits = 0L;
        long bits = this._attrsBits & (crashDirty ? ssa._dirtyBits : ssa._attrsBits);
        if (bits != 0L) {
            long bit = 1L;
            for (int i = 0; i < this.count(); ++i) {
                if ((bits & bit) != 0L) {
                    Object thisObj = this._attrs[i];
                    Object thatObj = ssa._attrs[i];
                    if (thisObj == null && thatObj != null || thisObj != null && !thisObj.equals(thatObj)) {
                        crashBits |= bit;
                    }
                    if ((bits &= bit ^ 0xFFFFFFFFFFFFFFFFL) == 0L) break;
                }
                bit <<= 1;
            }
        }
        return crashBits;
    }

    public static String crashName(long bits) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (bits != 0L) {
            if ((bits & 1L) != 0L) {
                sb.append(ShareStyleAttributes.getAttributeName(index));
                sb.append(',');
            }
            ++index;
            bits >>= 1;
        }
        return sb.toString();
    }

    public long sameBits(ShareStyleAttributes ssa, int countFrom, int countTo) {
        if (ssa == null || ssa.isEmpty()) {
            return 0L;
        }
        long sameBits = 0L;
        long attrsBits = this._attrsBits & ssa._attrsBits;
        if (attrsBits != 0L) {
            long bit = 1L << countFrom;
            for (int i = countFrom; i < countTo; ++i) {
                if ((attrsBits & bit) != 0L) {
                    if (this._attrs[i].equals(ssa._attrs[i])) {
                        sameBits |= bit;
                    }
                    if ((attrsBits &= bit ^ 0xFFFFFFFFFFFFFFFFL) == 0L) break;
                }
                bit <<= 1;
            }
        }
        return sameBits;
    }

    public boolean hasBordersAttributes() {
        return (this._attrsBits & _allBorderBits) != 0L;
    }

    public boolean hasBorderAttributes(Styles.Position pos) {
        return (this._attrsBits & ShareStyleAttributes.getBorderBits(pos)) != 0L;
    }

    public boolean hasBorderAllAttributes(Styles.Position pos) {
        long bits = ShareStyleAttributes.getBorderBits(pos);
        return (this._attrsBits & bits) == bits;
    }

    public boolean hasBorder(Styles.Position pos) {
        Object obj = this._attrs[ShareStyleAttributes.getBorderLineStyleIndex(pos)];
        return obj != null && obj != LineStyle.NULL_LINE;
    }

    public boolean hasBorderWidthOne(Styles.Position pos) {
        Object lineStyle = this._attrs[ShareStyleAttributes.getBorderLineStyleIndex(pos)];
        Object penStyle = this._attrs[ShareStyleAttributes.getBorderPenStyleIndex(pos)];
        Object color = this._attrs[ShareStyleAttributes.getBorderColorIndex(pos)];
        if (lineStyle != null && lineStyle != LineStyle.NULL_LINE) {
            return true;
        }
        return penStyle != null || color != null;
    }

    public boolean hasHorizontalAlign() {
        Object obj = this._attrs[HORIZONTAL_ALIGN];
        return obj != null && obj != Styles.HorizontalAlignment.NORMAL;
    }

    public boolean hasFontAttributes() {
        return (this._attrsBits & _fontBits) != 0L;
    }

    public String getFontName() {
        return (String)this._attrs[FONT_NAME];
    }

    @Deprecated
    public int getFontSize() {
        return (int)this.getFontSizeF();
    }

    public float getFontSizeF() {
        Object val = this._attrs[FONT_SIZE];
        if (val instanceof Float) {
            return ((Float)val).floatValue();
        }
        if (val instanceof Integer) {
            return ((Integer)val).floatValue();
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).floatValue();
        }
        return Float.parseFloat(val.toString());
    }

    public int getIndentation() {
        return (Integer)this._attrs[AUTO_INDENTATION];
    }

    public boolean isBold() {
        return (Boolean)this._attrs[FONT_BOLD];
    }

    public boolean isItalic() {
        return (Boolean)this._attrs[FONT_ITALIC];
    }

    public boolean isUnderline() {
        return (Boolean)this._attrs[FONT_UNDERLINE];
    }

    public boolean isStrikeThrough() {
        return (Boolean)this._attrs[FONT_STRIKETHROUGH];
    }

    public float getWeight() {
        return ((Float)this._attrs[FONT_WEIGHT]).floatValue();
    }

    public Color getFontColor() {
        return (Color)this._attrs[FONT_COLOR];
    }

    public boolean hasProtectionAttributes() {
        return (this._attrsBits & _protectionBits) != 0L;
    }

    public boolean isLocked() {
        return (Boolean)this._attrs[PROTECTION_LOCKED];
    }

    public boolean isHided() {
        return (Boolean)this._attrs[PROTECTION_HIDDED];
    }

    public boolean hasInteriorAttributes() {
        return (this._attrsBits & _interiorBits) != 0L;
    }

    public Color getBackground() {
        return (Color)this._attrs[BACKGROUND_COLOR];
    }

    public Pattern getPattern() {
        return (Pattern)this._attrs[PATTERN];
    }

    public Color getPatternColor() {
        return (Color)this._attrs[PATTERN_COLOR];
    }

    public boolean hasAlignmentAttributes() {
        return (this._attrsBits & _alignmentBits) != 0L;
    }

    public boolean hasIndentationAttributes() {
        return (this._attrsBits & ShareStyleAttributes.bits(AUTO_INDENTATION)) != 0L;
    }

    public Styles.HorizontalAlignment getHorizontalAlign() {
        return (Styles.HorizontalAlignment)this._attrs[HORIZONTAL_ALIGN];
    }

    public Styles.VerticalAlignment getVerticalAlign() {
        return (Styles.VerticalAlignment)this._attrs[VERTICAL_ALIGN];
    }

    public boolean isWrapText() {
        return (Boolean)this._attrs[WRAP_TEXT];
    }

    public boolean isShrinkText() {
        return (Boolean)this._attrs[SHRINK_TEXT];
    }

    public boolean isClip() {
        return (Boolean)this._attrs[AUTO_CLIP];
    }

    public int getRotation() {
        return (Integer)this._attrs[ROTATION];
    }

    public float getLinespacing() {
        float spacing = ((Float)this._attrs[LINE_SPACING]).floatValue();
        if (this.getLineSpacingType() == 1) {
            spacing = 0.0f;
        }
        return spacing;
    }

    protected float getOLinespacing() {
        return ((Float)this._attrs[LINE_SPACING]).floatValue();
    }

    public float getLineSpaceB() {
        if (this.getLineSpacingType() != 1) {
            return 1.0f;
        }
        float value = ((Float)this._attrs[LINE_SPACING]).floatValue();
        if (value < 1.0f) {
            return 1.0f;
        }
        return value;
    }

    public int getLineSpacingType() {
        return ((Number)this._attrs[LINE_SPACING_TYPE]).intValue();
    }

    public float getWordspacing() {
        return ((Float)this._attrs[WORD_SPACING]).floatValue();
    }

    public Rect getPadding() {
        return (Rect)this._attrs[PADDING];
    }

    public int getPadding(Styles.Dir dir) {
        Rect rc = this.getPadding();
        return rc != null ? rc.get(dir) : 0;
    }

    public String getNumberFormat() {
        return (String)this._attrs[NUMBER_FORMAT];
    }

    public PenStyle getBorderPenStyle(Styles.Position pos) {
        return (PenStyle)this._attrs[ShareStyleAttributes.getBorderPenStyleIndex(pos)];
    }

    public LineStyle getBorderLineStyle(Styles.Position pos) {
        return (LineStyle)this._attrs[ShareStyleAttributes.getBorderLineStyleIndex(pos)];
    }

    public Color getBorderColor(Styles.Position pos) {
        return (Color)this._attrs[ShareStyleAttributes.getBorderColorIndex(pos)];
    }

    public boolean isNullBorder(Styles.Position pos) {
        return LineStyle.isNull(this.getBorderLineStyle(pos));
    }

    static {
        START = _index = 0;
        FONT_NAME = _index++;
        FONT_SIZE = _index++;
        FONT_COLOR = _index++;
        FONT_BOLD = _index++;
        FONT_WEIGHT = _index++;
        FONT_ITALIC = _index++;
        FONT_UNDERLINE = _index++;
        FONT_STRIKETHROUGH = _index++;
        BACKGROUND_COLOR = _index++;
        PATTERN = _index++;
        PATTERN_COLOR = _index++;
        NUMBER_FORMAT = _index++;
        PROTECTION_LOCKED = _index++;
        PROTECTION_HIDDED = _index++;
        HORIZONTAL_ALIGN = _index++;
        VERTICAL_ALIGN = _index++;
        WRAP_TEXT = _index++;
        SHRINK_TEXT = _index++;
        ROTATION = _index++;
        LINE_SPACING = _index++;
        LINE_SPACING_TYPE = _index++;
        WORD_SPACING = _index++;
        PADDING = _index++;
        AUTO_CLIP = _index++;
        BEFORE_BORDER = _index - 1;
        BORDER_START = _index;
        BORDER_LEFT_LINESTYLE = _index++;
        BORDER_LEFT_PENSTYLE = _index++;
        BORDER_LEFT_COLOR = _index++;
        BORDER_TOP_LINESTYLE = _index++;
        BORDER_TOP_PENSTYLE = _index++;
        BORDER_TOP_COLOR = _index++;
        BORDER_RIGHT_LINESTYLE = _index++;
        BORDER_RIGHT_PENSTYLE = _index++;
        BORDER_RIGHT_COLOR = _index++;
        BORDER_BOTTOM_LINESTYLE = _index++;
        BORDER_BOTTOM_PENSTYLE = _index++;
        BORDER_BOTTOM_COLOR = _index++;
        BORDER_DIAGONALLEFT_LINESTYLE = _index++;
        BORDER_DIAGONALLEFT_PENSTYLE = _index++;
        BORDER_DIAGONALLEFT_COLOR = _index++;
        BORDER_DIAGONALRIGHT_LINESTYLE = _index++;
        BORDER_DIAGONALRIGHT_PENSTYLE = _index++;
        BORDER_DIAGONALRIGHT_COLOR = _index++;
        AUTO_INDENTATION = _index++;
        ATTRS_COUNT = _index;
        _name2Index = new HashMap();
        _attrNames = new String[ATTRS_COUNT];
        _bitsAll = Long.MAX_VALUE >> 64 - _index - 1;
        _topBorderBits = ShareStyleAttributes.bits(BORDER_TOP_LINESTYLE) | ShareStyleAttributes.bits(BORDER_TOP_PENSTYLE) | ShareStyleAttributes.bits(BORDER_TOP_COLOR);
        _leftBorderBits = ShareStyleAttributes.bits(BORDER_LEFT_LINESTYLE) | ShareStyleAttributes.bits(BORDER_LEFT_PENSTYLE) | ShareStyleAttributes.bits(BORDER_LEFT_COLOR);
        _bottomBorderBits = ShareStyleAttributes.bits(BORDER_BOTTOM_LINESTYLE) | ShareStyleAttributes.bits(BORDER_BOTTOM_PENSTYLE) | ShareStyleAttributes.bits(BORDER_BOTTOM_COLOR);
        _rightBorderBits = ShareStyleAttributes.bits(BORDER_RIGHT_LINESTYLE) | ShareStyleAttributes.bits(BORDER_RIGHT_PENSTYLE) | ShareStyleAttributes.bits(BORDER_RIGHT_COLOR);
        _dleftBorderBits = ShareStyleAttributes.bits(BORDER_DIAGONALLEFT_LINESTYLE) | ShareStyleAttributes.bits(BORDER_DIAGONALLEFT_PENSTYLE) | ShareStyleAttributes.bits(BORDER_DIAGONALLEFT_COLOR);
        _drightBorderBits = ShareStyleAttributes.bits(BORDER_DIAGONALRIGHT_LINESTYLE) | ShareStyleAttributes.bits(BORDER_DIAGONALRIGHT_PENSTYLE) | ShareStyleAttributes.bits(BORDER_DIAGONALRIGHT_COLOR);
        _allLineStyleBits = ShareStyleAttributes.bits(BORDER_LEFT_LINESTYLE) | ShareStyleAttributes.bits(BORDER_TOP_LINESTYLE) | ShareStyleAttributes.bits(BORDER_RIGHT_LINESTYLE) | ShareStyleAttributes.bits(BORDER_BOTTOM_LINESTYLE) | ShareStyleAttributes.bits(BORDER_DIAGONALLEFT_LINESTYLE) | ShareStyleAttributes.bits(BORDER_DIAGONALRIGHT_LINESTYLE);
        _outerBorderBits = _topBorderBits | _leftBorderBits | _bottomBorderBits | _rightBorderBits;
        _allBorderBits = _outerBorderBits | _dleftBorderBits | _drightBorderBits;
        _fontBits = ShareStyleAttributes.bits(FONT_NAME) | ShareStyleAttributes.bits(FONT_SIZE) | ShareStyleAttributes.bits(FONT_COLOR) | ShareStyleAttributes.bits(FONT_BOLD) | ShareStyleAttributes.bits(FONT_WEIGHT) | ShareStyleAttributes.bits(FONT_ITALIC) | ShareStyleAttributes.bits(FONT_UNDERLINE) | ShareStyleAttributes.bits(FONT_STRIKETHROUGH);
        _interiorBits = ShareStyleAttributes.bits(BACKGROUND_COLOR) | ShareStyleAttributes.bits(PATTERN) | ShareStyleAttributes.bits(PATTERN_COLOR);
        _alignmentBits = ShareStyleAttributes.bits(HORIZONTAL_ALIGN) | ShareStyleAttributes.bits(VERTICAL_ALIGN) | ShareStyleAttributes.bits(WRAP_TEXT) | ShareStyleAttributes.bits(SHRINK_TEXT) | ShareStyleAttributes.bits(ROTATION) | ShareStyleAttributes.bits(LINE_SPACING) | ShareStyleAttributes.bits(LINE_SPACING_TYPE) | ShareStyleAttributes.bits(WORD_SPACING) | ShareStyleAttributes.bits(AUTO_CLIP);
        _protectionBits = ShareStyleAttributes.bits(PROTECTION_HIDDED) | ShareStyleAttributes.bits(PROTECTION_LOCKED);
        ShareStyleAttributes.buildName("font-name", FONT_NAME);
        ShareStyleAttributes.buildName("font-size", FONT_SIZE);
        ShareStyleAttributes.buildName("font-color", FONT_COLOR);
        ShareStyleAttributes.buildName("font-bold", FONT_BOLD);
        ShareStyleAttributes.buildName("font-weight", FONT_WEIGHT);
        ShareStyleAttributes.buildName("font-italic", FONT_ITALIC);
        ShareStyleAttributes.buildName("font-underline", FONT_UNDERLINE);
        ShareStyleAttributes.buildName("font-StrikeThrough", FONT_STRIKETHROUGH);
        ShareStyleAttributes.buildName("border-top-linestyle", BORDER_TOP_LINESTYLE);
        ShareStyleAttributes.buildName("border-top-penstyle", BORDER_TOP_PENSTYLE);
        ShareStyleAttributes.buildName("border-top-color", BORDER_TOP_COLOR);
        ShareStyleAttributes.buildName("border-left-linestyle", BORDER_LEFT_LINESTYLE);
        ShareStyleAttributes.buildName("border-left-penstyle", BORDER_LEFT_PENSTYLE);
        ShareStyleAttributes.buildName("border-left-color", BORDER_LEFT_COLOR);
        ShareStyleAttributes.buildName("border-bottom-linestyle", BORDER_BOTTOM_LINESTYLE);
        ShareStyleAttributes.buildName("border-bottom-penstyle", BORDER_BOTTOM_PENSTYLE);
        ShareStyleAttributes.buildName("border-bottom-color", BORDER_BOTTOM_COLOR);
        ShareStyleAttributes.buildName("border-right-linestyle", BORDER_RIGHT_LINESTYLE);
        ShareStyleAttributes.buildName("border-right-penstyle", BORDER_RIGHT_PENSTYLE);
        ShareStyleAttributes.buildName("border-right-color", BORDER_RIGHT_COLOR);
        ShareStyleAttributes.buildName("border-diagonalright-linestyle", BORDER_DIAGONALRIGHT_LINESTYLE);
        ShareStyleAttributes.buildName("border-diagonalright-penstyle", BORDER_DIAGONALRIGHT_PENSTYLE);
        ShareStyleAttributes.buildName("border-diagonalright-color", BORDER_DIAGONALRIGHT_COLOR);
        ShareStyleAttributes.buildName("border-diagonalleft-linestyle", BORDER_DIAGONALLEFT_LINESTYLE);
        ShareStyleAttributes.buildName("border-diagonalleft-penstyle", BORDER_DIAGONALLEFT_PENSTYLE);
        ShareStyleAttributes.buildName("border-diagonalleft-color", BORDER_DIAGONALLEFT_COLOR);
        ShareStyleAttributes.buildName("background-color", BACKGROUND_COLOR);
        ShareStyleAttributes.buildName("pattern", PATTERN);
        ShareStyleAttributes.buildName("pattern-color", PATTERN_COLOR);
        ShareStyleAttributes.buildName("string-format", NUMBER_FORMAT);
        ShareStyleAttributes.buildName("protection-locked", PROTECTION_LOCKED);
        ShareStyleAttributes.buildName("protection-hided", PROTECTION_HIDDED);
        ShareStyleAttributes.buildName("text-align", HORIZONTAL_ALIGN);
        ShareStyleAttributes.buildName("vertical-align", VERTICAL_ALIGN);
        ShareStyleAttributes.buildName("wrap-text", WRAP_TEXT);
        ShareStyleAttributes.buildName("shrink-text", SHRINK_TEXT);
        ShareStyleAttributes.buildName("rotation", ROTATION);
        ShareStyleAttributes.buildName("line_space", LINE_SPACING);
        ShareStyleAttributes.buildName("line_space_type", LINE_SPACING_TYPE);
        ShareStyleAttributes.buildName("word_space", WORD_SPACING);
        ShareStyleAttributes.buildName("padding", PADDING);
        ShareStyleAttributes.buildName("clip", AUTO_CLIP);
        ShareStyleAttributes.buildName("indent", AUTO_INDENTATION);
    }

    private static class Unknown {
        private Unknown() {
        }

        public String toString() {
            return "Unknown";
        }
    }
}

