/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.kdf.util.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.UIManager;
import kd.bos.print.core.ctrl.kdf.util.style.Border;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Pattern;
import kd.bos.print.core.ctrl.kdf.util.style.PenStyle;
import kd.bos.print.core.ctrl.kdf.util.style.ShareStyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.swing.KDFont;

public class Style
extends ShareStyleAttributes {
    private KDFontShell _fs;
    private StrokeShell[] _aSS;
    private Paint _paint;

    public Style(ShareStyleAttributes ssa) {
        super(ssa);
        if (!ssa.isFull()) {
            throw new IllegalArgumentException();
        }
        this._aSS = new StrokeShell[6];
    }

    public ShareStyleAttributes subtract(Style style) {
        if (this == style) {
            return null;
        }
        StyleAttributes sa = Styles.getSA(this);
        sa.clearAttributes(sa.sameBits(style, 0, sa.count()));
        return Styles.getSSA(sa);
    }

    @Deprecated
    public static void setDefaultFont(Font font) {
    }

    public KDFont getKDFont() {
        if (this._fs == null) {
            int flag = 0;
            if (this.isBold()) {
                ++flag;
            }
            if (this.isItalic()) {
                flag += 2;
            }
            this._fs = Styles.getFontShell(this.getFontName(), flag, this.getFontSizeF());
        }
        return this._fs.getFont();
    }

    public Font getFont() {
        Font f;
        if (this._fs == null) {
            int flag = 0;
            if (this.isBold()) {
                ++flag;
            }
            if (this.isItalic()) {
                flag += 2;
            }
            this._fs = Styles.getFontShell(this.getFontName(), flag, this.getFontSizeF());
        }
        if ((f = this._fs.getJARFont()) == null) {
            return this._fs.getFont();
        }
        return f;
    }

    private StrokeShell getStrokeShell(Styles.Position pos) {
        int index = pos.getIndex();
        StrokeShell ss = this._aSS[index];
        if (ss == null) {
            this._aSS[index] = ss = Styles.getStrokeShell(this.getBorderPenStyle(pos), this.getBorderLineStyle(pos));
        }
        return ss;
    }

    public Stroke getStroke(Styles.Position pos) {
        return this.getStrokeShell(pos).getStroke();
    }

    public Stroke getBaseStroke(Styles.Position pos) {
        return this.getStrokeShell(pos).getBaseStroke();
    }

    public StyleAttributes getNewAttribute() {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorder(this.getBorder(Styles.Position.LEFT));
        sa.setBorder(this.getBorder(Styles.Position.RIGHT));
        sa.setBorder(this.getBorder(Styles.Position.BOTTOM));
        sa.setBorder(this.getBorder(Styles.Position.TOP));
        sa.setPadding(this.getPadding());
        sa.setWrapText(this.isWrapText());
        sa.setClip(this.isClip());
        sa.setUnderline(this.isUnderline());
        sa.setItalic(this.isItalic());
        sa.setBackground(this.getBackground());
        sa.setFontName(this.getFontName());
        sa.setBold(this.isBold());
        sa.setFontSize(this.getFontSizeF());
        sa.setWrapText(this.isWrapText());
        sa.setShrinkText(this.isShrinkText());
        sa.setWeight(this.getWeight());
        sa.setFontColor(this.getFontColor());
        sa.setHorizontalAlign(this.getHorizontalAlign());
        sa.setVerticalAlign(this.getVerticalAlign());
        sa.setIndentation(this.getIndentation());
        sa.setHided(this.isHided());
        sa.setWordspacing(this.getWordspacing());
        sa.setRotation(this.getRotation());
        sa.setStrikeThrough(this.isStrikeThrough());
        sa.setLinespacingType(this.getLineSpacingType());
        sa.setLinespacing(this.getOLinespacing());
        return sa;
    }

    public Paint getFillPaint() {
        if (this._paint == null) {
            Pattern pattern = this.getPattern();
            if (pattern == Pattern.Solid) {
                this._paint = this.getBackground();
            } else if (pattern == Pattern.None) {
                this._paint = Styles.getNullColor();
            } else {
                Color clrPattern = this.getPatternColor();
                Color clrGround = this.getBackground();
                if (Styles.isNullColor(clrGround)) {
                    clrGround = UIManager.getColor("Panel.background");
                }
                byte[] r = new byte[]{(byte)clrGround.getRed(), (byte)clrPattern.getRed()};
                byte[] g = new byte[]{(byte)clrGround.getGreen(), (byte)clrPattern.getGreen()};
                byte[] b = new byte[]{(byte)clrGround.getBlue(), (byte)clrPattern.getBlue()};
                byte[] a = new byte[]{(byte)clrGround.getAlpha(), (byte)clrPattern.getAlpha()};
                IndexColorModel cm = new IndexColorModel(1, 2, r, g, b, a);
                BufferedImage img = new BufferedImage(8, 8, 12, cm);
                byte[] data = pattern.getPatternData();
                DataBufferByte db = new DataBufferByte(data, data.length);
                WritableRaster ras = Raster.createPackedRaster(db, 8, 8, 1, null);
                img.setData(ras);
                Rectangle rc = new Rectangle(0, 0, 8, 8);
                this._paint = new TexturePaint(img, rc);
            }
        }
        return this._paint;
    }

    public Border getBorder(Styles.Position pos) {
        return new Border(pos, this);
    }

    static class KDFontShell {
        private String _name;
        private int _fontStyle;
        private float _size;
        private KDFont _font;
        private Font JARFont;

        @Deprecated
        public KDFontShell(String name, int fontStyle, int size) {
            new KDFontShell(name, fontStyle, (float)size);
        }

        public KDFontShell(String name, int fontStyle, float size) {
            this._name = name;
            this._fontStyle = fontStyle;
            this._size = size;
        }

        public KDFont getFont() {
            this._font = new KDFont(this._name, this._fontStyle, this._size);
            return this._font;
        }

        public Font getJARFont() {
            if (this.JARFont == null) {
                this.JARFont = KDFont.loadFontFromJAR(this._name, this._fontStyle, this._size);
            }
            return this.JARFont;
        }

        public int hashCode() {
            return this._name.hashCode() ^ this._fontStyle ^ (int)(this._size * 100.0f);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof KDFontShell) {
                KDFontShell cmp = (KDFontShell)obj;
                return this._fontStyle == cmp._fontStyle && this._size == cmp._size && this._name.equals(cmp._name);
            }
            return false;
        }
    }

    static class StrokeShell {
        private PenStyle penStyle;
        private LineStyle lineStyle;
        private Stroke stroke;
        private Stroke baseStroke;

        public StrokeShell(PenStyle ps, LineStyle ls) {
            this.penStyle = ps;
            this.lineStyle = ls;
        }

        public int hashCode() {
            return this.penStyle.hashCode() ^ this.lineStyle.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StrokeShell)) {
                return false;
            }
            StrokeShell ss = (StrokeShell)obj;
            return this.penStyle.equals(ss.penStyle) && this.lineStyle.equals(ss.lineStyle);
        }

        public Stroke getStroke() {
            if (this.stroke == null) {
                this.stroke = this.penStyle.getStroke(this.lineStyle.getWidth());
            }
            return this.stroke;
        }

        public Stroke getBaseStroke() {
            if (this.baseStroke == null) {
                this.baseStroke = this.penStyle.getBaseStroke();
            }
            return this.baseStroke;
        }
    }
}

