/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.text.AttributedString;
import javax.imageio.ImageIO;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.url.UrlService;
import sun.awt.image.BufferedImageGraphicsConfig;

public class ImageWatermarkDrawer {
    private static final Log log = LogFactory.getLog(ImageWatermarkDrawer.class);
    private static final Integer WATERMARK_INTERVAL = 80;
    private static final double radian = Math.toRadians(-10.0);
    private static final float[] offsetY = new float[]{30.0f, 30.0f};
    private BufferedImage cacheImage = null;

    public void addWaterMark(Graphics2D graphics2D, float width, float height, WaterMark waterMark) {
        if (waterMark == null) {
            return;
        }
        String wmText = waterMark.getText();
        if (wmText == null) {
            wmText = "";
        }
        wmText = wmText.replaceAll("\\\\n", "\n").replaceAll("\\/n", "\n");
        waterMark.setText(wmText);
        String fontName = "\u601d\u6e90\u5b8b\u4f53 CN";
        int fontSize = this.getFontSize(waterMark);
        Font font = KDFont.loadFontFromJAR(fontName, 0, fontSize);
        this.initG2DAttribute(graphics2D, font, waterMark);
        String type = waterMark.getType();
        if ("1".equals(type) && StringUtils.isNotBlank((CharSequence)wmText)) {
            this.textWatermark(graphics2D, fontSize, wmText, width, height);
        } else if ("2".equals(type)) {
            this.imgWatermark(graphics2D, waterMark, width, height);
        } else if ("3".equals(type) || "4".equals(type)) {
            this.mixWatermark(graphics2D, font.getSize(), waterMark, width, height);
        }
    }

    private int getFontSize(WaterMark waterMark) {
        int fontSize = 12;
        String size = waterMark.getFontSize();
        if (StringUtils.isNotBlank((CharSequence)size)) {
            try {
                size = size.replace("px", "");
                fontSize = Integer.parseInt(size);
            }
            catch (Exception ignore) {
                log.error("watermark font transfer error\uff1afontSize=%s", (Object)size);
                fontSize = 12;
            }
        }
        return fontSize;
    }

    private void initG2DAttribute(Graphics2D graphics2D, Font font, WaterMark waterMark) {
        graphics2D.setFont(font);
        int i = 819;
        String color = waterMark.getColor();
        if (StringUtils.isNotBlank((CharSequence)color)) {
            i = Integer.parseInt(color.substring(1), 16);
        }
        float opacity = 0.85f;
        int globalAlpha = waterMark.getGlobalAlpha();
        if (globalAlpha > 0 && globalAlpha <= 100) {
            opacity = (float)globalAlpha / 100.0f;
        }
        graphics2D.setColor(new Color(i));
        graphics2D.setComposite(AlphaComposite.getInstance(3, opacity));
    }

    private void textWatermark(Graphics2D graphics2D, float fontSize, String wmText, float pageWidth, float pageHeight) {
        String[] splitText = wmText.split("\n");
        float xLen = this.getXLen(fontSize, splitText);
        float yLen = (float)(splitText.length - 1) * fontSize;
        int i = 0;
        for (float width = 0.0f; width < pageWidth; width += (float)WATERMARK_INTERVAL.intValue() + xLen) {
            float height;
            float f = height = i % 2 == 0 ? offsetY[0] : offsetY[1];
            while (height < pageHeight) {
                this.drawWmText(graphics2D, splitText, fontSize, width, height);
                height += (float)WATERMARK_INTERVAL.intValue() + yLen;
            }
            ++i;
        }
    }

    private void drawWmText(Graphics2D graphics2D, String[] splitText, float fontSize, float x, float y) {
        for (String text : splitText) {
            AttributedString as = new AttributedString(text);
            AffineTransform at = new AffineTransform();
            at.rotate(radian);
            as.addAttribute(TextAttribute.TRANSFORM, at);
            graphics2D.drawString(as.getIterator(), x, y);
            y += fontSize;
        }
    }

    private float getXLen(float size, String[] splitText) {
        float xLen = 0.0f;
        for (String text : splitText) {
            float textLen = (float)text.length() * size;
            if (!(textLen > xLen)) continue;
            xLen = textLen;
        }
        return xLen;
    }

    private void imgWatermark(Graphics2D graphics2D, WaterMark waterMark, float pageWidth, float pageHeight) {
        BufferedImage image = this.transferOri2BufferedImage(waterMark);
        if (image == null) {
            return;
        }
        int xLen = image.getWidth();
        int yLen = image.getHeight();
        try {
            int i = 0;
            for (float width = 0.0f; width < pageWidth; width += (float)(WATERMARK_INTERVAL + xLen)) {
                float heigh;
                float f = heigh = i % 2 == 0 ? offsetY[0] : offsetY[1];
                while (heigh < pageHeight) {
                    graphics2D.drawImage(image, null, (int)width, (int)heigh);
                    heigh += (float)(WATERMARK_INTERVAL + yLen);
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage transferOri2BufferedImage(WaterMark waterMark) {
        if (this.cacheImage != null) {
            return this.cacheImage;
        }
        String imgUrl = waterMark.getPicture();
        if (StringUtils.isBlank((CharSequence)imgUrl)) {
            return null;
        }
        String imageUrl = UrlService.getDomainContextUrl() + imgUrl;
        try (InputStream is = new URL(imageUrl).openStream();){
            BufferedImage bi = ImageIO.read(is);
            int height = bi.getHeight();
            int width = bi.getWidth();
            if (height > 22) {
                width = bi.getWidth() * 22 / height;
                height = 22;
            }
            double sin = Math.abs(Math.sin(radian));
            double cos = Math.abs(Math.cos(radian));
            int neww = (int)Math.floor((double)width * cos + (double)height * sin);
            int newh = (int)Math.floor((double)height * cos + (double)width * sin);
            BufferedImage bufferedImage2 = new BufferedImage(neww, newh, bi.getType());
            BufferedImageGraphicsConfig config = BufferedImageGraphicsConfig.getConfig(bufferedImage2);
            bufferedImage2 = config.createCompatibleImage(neww, newh, 3);
            Graphics2D g = bufferedImage2.createGraphics();
            g.setComposite(AlphaComposite.getInstance(2));
            g.translate((neww - width) / 2, (newh - height) / 2);
            g.rotate(radian, width / 2, height / 2);
            g.drawImage(bi.getScaledInstance(width, height, 4), 0, 0, null);
            g.dispose();
            this.cacheImage = bufferedImage2;
            BufferedImage bufferedImage = bufferedImage2;
            return bufferedImage;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private void mixWatermark(Graphics2D graphics2D, float fontSize, WaterMark waterMark, float pageWidth, float pageHeight) {
        try {
            String type = waterMark.getType();
            BufferedImage image = this.transferOri2BufferedImage(waterMark);
            String wmText = waterMark.getText();
            float imageWidth = 0.0f;
            float imageHeight = 0.0f;
            if (image != null) {
                imageHeight = image.getHeight();
                imageWidth = image.getWidth();
            }
            String[] splitText = wmText.split("\n");
            float textXLen = this.getXLen(fontSize, splitText);
            float textYLen = (float)splitText.length * fontSize;
            float xLen = 0.0f;
            float yLen = 0.0f;
            if ("3".equals(type)) {
                xLen = Math.max(textXLen, imageWidth);
                yLen = textYLen + imageHeight + 10.0f;
            }
            if ("4".equals(type)) {
                xLen = textXLen + imageWidth + 10.0f;
                yLen = Math.max(textYLen, imageHeight);
            }
            int i = 0;
            for (float width = 0.0f; width < pageWidth; width += (float)WATERMARK_INTERVAL.intValue() + xLen) {
                float heigh;
                float f = heigh = i % 2 == 0 ? offsetY[0] : offsetY[1];
                while (heigh < pageHeight) {
                    if (image != null) {
                        graphics2D.drawImage(image, null, (int)width, (int)heigh);
                    }
                    if (!StringUtils.isBlank((CharSequence)wmText)) {
                        if ("3".equals(type)) {
                            this.drawWmText(graphics2D, splitText, fontSize, width, heigh + imageHeight + fontSize + 5.0f);
                        }
                        if ("4".equals(type)) {
                            this.drawWmText(graphics2D, splitText, fontSize, width + imageWidth + 5.0f, heigh + fontSize);
                        }
                    }
                    heigh += (float)WATERMARK_INTERVAL.intValue() + yLen;
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

