/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.io;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.print.util.PdfWaterMarkUtil;
import kd.bos.url.UrlService;
import sun.awt.image.BufferedImageGraphicsConfig;

public class PdfWatermarkDrawer {
    private static final Log log = LogFactory.getLog(PdfWaterMarkUtil.class);
    private static final Integer WATERMARK_INTERVAL = 80;
    private Image cacheImage = null;

    private Image getImage(WaterMark waterMark) {
        String imageUrl;
        byte[] bb;
        if (this.cacheImage != null) {
            return this.cacheImage;
        }
        Image image = null;
        String imgUrl = waterMark.getPicture();
        if (StringUtils.isNotBlank((CharSequence)imgUrl) && (bb = this.transferOri2Byte(imageUrl = UrlService.getDomainContextUrl() + imgUrl)) != null && bb.length > 0) {
            try {
                image = Image.getInstance((byte[])bb);
                image.setRotationDegrees(10.0f);
                image.scalePercent(100.0f);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        this.cacheImage = image;
        return image;
    }

    public void addWaterMark(PdfWriter writer, Document document, Font font, WaterMark waterMark) {
        if (waterMark == null) {
            return;
        }
        float pageWidth = document.getPageSize().getWidth();
        float pageHeight = document.getPageSize().getHeight();
        String wmText = waterMark.getText();
        if (wmText == null) {
            wmText = "";
        }
        wmText = wmText.replaceAll("\\\\n", "\n").replaceAll("\\/n", "\n");
        waterMark.setText(wmText);
        String type = waterMark.getType();
        if ("1".equals(type)) {
            if (StringUtils.isNotBlank((CharSequence)wmText)) {
                this.textWatermark(this.getPdfContent(writer, waterMark), font, wmText, pageWidth, pageHeight);
            }
        } else if ("2".equals(type)) {
            this.imgWatermark(this.getPdfContent(writer, waterMark), waterMark, pageWidth, pageHeight);
        } else if ("3".equals(type) || "4".equals(type)) {
            this.mixWatermark(this.getPdfContent(writer, waterMark), font, waterMark, pageWidth, pageHeight);
        }
    }

    private PdfContentByte getPdfContent(PdfWriter writer, WaterMark waterMark) {
        return this.setColorAndOpacity(writer.getDirectContent(), waterMark);
    }

    private PdfContentByte setColorAndOpacity(PdfContentByte pdfContent, WaterMark waterMark) {
        int i = 819;
        String color = waterMark.getColor();
        if (StringUtils.isNotBlank((CharSequence)color)) {
            i = Integer.parseInt(color.substring(1), 16);
        }
        pdfContent.setColorFill(new Color(i));
        PdfGState gs = new PdfGState();
        float opacity = 0.85f;
        int globalAlpha = waterMark.getGlobalAlpha();
        if (globalAlpha > 0 && globalAlpha <= 100) {
            opacity = (float)globalAlpha / 100.0f;
        }
        gs.setFillOpacity(opacity);
        pdfContent.setGState(gs);
        return pdfContent;
    }

    private void textWatermark(PdfContentByte pdfContent, Font textFont, String wmText, float pageWidth, float pageHeight) {
        float size = textFont.getSize();
        String[] splitText = wmText.split("\n");
        float xLen = this.getXLen(size, splitText);
        float yLen = (float)(splitText.length - 1) * size;
        float radian = 10.0f;
        for (float heigh = 30.0f; heigh < pageHeight; heigh += (float)WATERMARK_INTERVAL.intValue() + yLen) {
            for (float width = 0.0f; width < pageWidth; width += (float)WATERMARK_INTERVAL.intValue() + xLen) {
                this.drawText(pdfContent, textFont, size, splitText, radian, width, heigh);
            }
        }
    }

    private void drawText(PdfContentByte pdfContent, Font textFont, float size, String[] splitText, float radian, float x, float y) {
        for (String text : splitText) {
            ColumnText.showTextAligned((PdfContentByte)pdfContent, (int)0, (Phrase)new Phrase(text, textFont), (float)x, (float)y, (float)radian);
            y = (float)((double)y - (double)size * Math.cos(Math.toRadians(radian)));
            x = (float)((double)x + (double)size * Math.sin(Math.toRadians(radian)));
        }
    }

    private float getXLen(float size, String[] splitText) {
        float xLen = 0.0f;
        for (String text : splitText) {
            float textLen = (float)text.length() * size;
            if (!(textLen > xLen)) continue;
            xLen = textLen;
        }
        return xLen;
    }

    private void imgWatermark(PdfContentByte pdfContent, WaterMark waterMark, float pageWidth, float pageHeight) {
        Image image = this.getImage(waterMark);
        if (image == null) {
            return;
        }
        float xLen = image.getWidth();
        float yLen = image.getHeight();
        try {
            for (float heigh = 30.0f; heigh < pageHeight; heigh += (float)WATERMARK_INTERVAL.intValue() + yLen) {
                for (float width = 0.0f; width < pageWidth; width += (float)WATERMARK_INTERVAL.intValue() + xLen) {
                    pdfContent.addImage(this.getWaterMarkImage(image, width, heigh));
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void mixWatermark(PdfContentByte pdfContent, Font font, WaterMark waterMark, float pageWidth, float pageHeight) {
        try {
            String type = waterMark.getType();
            Image image = this.getImage(waterMark);
            String wmText = waterMark.getText();
            float imageWidth = 0.0f;
            float imageHeight = 0.0f;
            if (image != null) {
                imageHeight = image.getHeight();
                imageWidth = image.getWidth();
            }
            float size = font.getSize();
            String[] splitText = wmText.split("\n");
            float textXLen = this.getXLen(size, splitText);
            float textYLen = (float)(splitText.length - 1) * size;
            float xLen = 0.0f;
            float yLen = 0.0f;
            if ("3".equals(type)) {
                xLen = Math.max(textXLen, imageWidth);
                yLen = textYLen + imageHeight + 10.0f;
            }
            if ("4".equals(type)) {
                xLen = textXLen + imageWidth + 10.0f;
                yLen = Math.max(textYLen, imageHeight);
            }
            float radian = 10.0f;
            for (float heigh = 30.0f; heigh < pageHeight; heigh += (float)WATERMARK_INTERVAL.intValue() + yLen) {
                for (float width = 0.0f; width < pageWidth; width += (float)WATERMARK_INTERVAL.intValue() + xLen) {
                    if (image != null) {
                        Image newImg = this.getWaterMarkImage(image, width, heigh);
                        pdfContent.addImage(newImg);
                    }
                    if (StringUtils.isBlank((CharSequence)wmText)) continue;
                    if ("3".equals(type)) {
                        this.drawText(pdfContent, font, size, splitText, radian, width, heigh - imageHeight - 5.0f);
                    }
                    if (!"4".equals(type)) continue;
                    this.drawText(pdfContent, font, size, splitText, radian, width + imageWidth + 5.0f, heigh);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private Image getWaterMarkImage(Image waterMarkImage, float xPosition, float yPosition) {
        waterMarkImage.setAbsolutePosition(xPosition, yPosition);
        waterMarkImage.scalePercent(100.0f);
        return waterMarkImage;
    }

    private byte[] transferOri2Byte(String url) {
        byte[] result = null;
        try (InputStream is = new URL(url).openStream();
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            BufferedImage bi = ImageIO.read(is);
            int height = bi.getHeight();
            int width = bi.getWidth();
            if (height > 22) {
                width = bi.getWidth() * 22 / height;
                height = 22;
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, bi.getType());
            BufferedImageGraphicsConfig config = BufferedImageGraphicsConfig.getConfig(bufferedImage);
            bufferedImage = config.createCompatibleImage(width, height, 3);
            Graphics2D g = bufferedImage.createGraphics();
            g.setComposite(AlphaComposite.getInstance(2));
            g.drawImage(bi.getScaledInstance(width, height, 4), 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            result = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return result;
    }
}

